/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.platform.jakarta.websocket.server.handshakerequest.authenticatedlogoff;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.platform.jakarta.websocket.server.handshakerequest.authenticatedlogoff.CloseHttpSessionConfigurator;
import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;

@ServerEndpoint(value="/closehttpsession", configurator=CloseHttpSessionConfigurator.class)
public class WSCCloseHttpSessionServer {
    private static int lastCloseCode = 0;
    static final String[] MESSAGES = new String[]{"invalidate", "interval", "lastcode"};

    @OnMessage
    public String onMessage(String msg) {
        if (MESSAGES[0].equals(msg)) {
            WSCCloseHttpSessionServer.setLastCloseCode(0);
            CloseHttpSessionConfigurator.getSession().invalidate();
        } else if (MESSAGES[1].equals(msg)) {
            WSCCloseHttpSessionServer.setLastCloseCode(0);
            CloseHttpSessionConfigurator.getSession().setMaxInactiveInterval(1);
        } else if (MESSAGES[2].equals(msg)) {
            msg = String.valueOf(lastCloseCode);
        }
        return msg;
    }

    @OnError
    public void onError(Session session, Throwable thr) throws IOException {
        thr.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)thr);
        session.getBasicRemote().sendText(message);
    }

    @OnClose
    public void onClose(CloseReason reason) {
        WSCCloseHttpSessionServer.setLastCloseCode(reason.getCloseCode().getCode());
        String msg = "Close code: " + WSCCloseHttpSessionServer.getLastCloseCode();
        CloseHttpSessionConfigurator.getSession().getServletContext().log(msg);
    }

    private static int getLastCloseCode() {
        return lastCloseCode;
    }

    private static void setLastCloseCode(int lastCloseCode) {
        WSCCloseHttpSessionServer.lastCloseCode = lastCloseCode;
    }
}

