/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex4a;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex4a.DID4MedicalHistory;
import ee.jakarta.tck.persistence.core.derivedid.ex4a.DID4Person;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void DIDTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID4Person person = new DID4Person("123456789", "DUKE");
            DID4MedicalHistory mHistory = new DID4MedicalHistory(person, "drFoo");
            this.getEntityManager().persist((Object)person);
            this.getEntityManager().persist((Object)mHistory);
            this.logTrace("persisted Patient and MedicalHistory");
            this.getEntityManager().flush();
            DID4MedicalHistory newMHistory = (DID4MedicalHistory)this.getEntityManager().find(DID4MedicalHistory.class, (Object)"123456789");
            if (newMHistory != null) {
                this.getEntityManager().refresh((Object)newMHistory);
            }
            List depList = this.getEntityManager().createQuery("Select m from DID4MedicalHistory m where m.patient.ssn='123456789'").getResultList();
            newMHistory = null;
            if (depList.size() > 0) {
                newMHistory = (DID4MedicalHistory)depList.get(0);
                if (newMHistory != null) {
                    if (newMHistory.getPatient() == person) {
                        pass = true;
                        this.logTrace("Received Expected Patient");
                    } else {
                        this.logErr("Searched Patient not found");
                    }
                } else {
                    this.logErr("getEntityManager().createQuery returned null entry");
                }
            } else {
                this.logErr("getEntityManager().createQuery returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new Exception("DTDTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID4MEDICALHISTORY").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID4PERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

