/*
 * Decompiled with CFR 0.152.
 */
package ee.tck.javadb;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.derby.drda.NetworkServerControl;

public class JavaDBController {
    String dbName = "derbyDB";
    String server = "localhost";
    int port = 1527;
    String dmlFile = "derby/derby.dml.sql";
    String user = "cts1";
    String passwd = "cts1";
    int startupDelay = 5;

    public JavaDBController() {
    }

    public JavaDBController(String dbName, String server, int port, String user, String passwd) {
        this.dbName = dbName;
        this.server = server;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
    }

    public JavaDBController(Path tsJte) throws IOException {
        Properties props = new Properties();
        props.load(Files.newInputStream(tsJte, new OpenOption[0]));
        this.dbName = props.getProperty("derby.db.name");
        this.server = this.server;
        this.port = this.port;
        this.user = this.user;
        this.passwd = this.passwd;
    }

    public void startJavaDB(Path derbyHome) throws Exception {
        System.setProperty("derby.system.home", derbyHome.toString());
        InetAddress inetAddress = InetAddress.getByName(this.server);
        NetworkServerControl server = new NetworkServerControl(inetAddress, this.port);
        server.start(null);
    }

    public void stopJavaDB() throws Exception {
        InetAddress inetAddress = InetAddress.getByName(this.server);
        NetworkServerControl server = new NetworkServerControl(inetAddress, this.port);
        server.shutdown();
    }

    public boolean isJavaDBRunning() {
        Properties props = new Properties();
        String dbURL = "jdbc:derby://" + this.server + ":" + this.port + "/" + this.dbName + ";user=" + this.user + ";password=" + this.passwd + ";create=true";
        props.setProperty("user", this.user);
        props.setProperty("password", this.passwd);
        boolean isRunning = false;
        try (Connection conn = DriverManager.getConnection(dbURL, props);){
            isRunning = conn.isValid(0);
            try (Statement s = conn.createStatement();){
                try {
                    ResultSet rs = s.executeQuery("values user");
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    isRunning = false;
                }
            }
            catch (Exception e) {
                isRunning = false;
            }
        }
        catch (Exception e) {
            isRunning = false;
        }
        return isRunning;
    }
}

