/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.propagation.am;

import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.ee.propagation.am.Member;
import ee.jakarta.tck.persistence.ee.propagation.am.Stateful3IF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceUnit;
import java.math.BigInteger;
import java.util.Properties;

@Stateful(name="Stateful3Bean")
public class Stateful3Bean
implements Stateful3IF {
    @PersistenceUnit(unitName="CTS-APPMANAGED-UNIT")
    private EntityManagerFactory entityManagerFactory;
    public SessionContext sessionContext;
    private EntityManager entityManager;
    private static final Member[] mRef = new Member[5];
    public Properties p;

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @PostConstruct
    public void prepareEnvironment() {
        try {
            TestUtil.logTrace((String)"In PostContruct");
            if (this.entityManagerFactory != null) {
                this.entityManager = this.entityManagerFactory.createEntityManager();
            } else {
                TestUtil.logErr((String)"EntityManagerFactory is null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)" In PostConstruct: Exception caught while setting EntityManager", (Throwable)e);
        }
    }

    @Override
    public void init(Properties p) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test3() {
        boolean pass = false;
        int memId = 9;
        try {
            TestUtil.logTrace((String)"createTestData");
            this.entityManager.joinTransaction();
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"find member");
            Member member = this.getMember(memId);
            this.entityManager.clear();
            Member memberClone = this.getMember(memId);
            if (null != member) {
                this.checkMemberStatus(memberClone);
                this.entityManager.merge((Object)member);
                this.entityManager.flush();
            } else {
                TestUtil.logErr((String)" member is null, Unexpected - cannot proceed with test.");
            }
            pass = false;
        }
        catch (OptimisticLockException e) {
            pass = true;
            TestUtil.logTrace((String)"Caught expected OptimisticLockException");
        }
        finally {
            TestUtil.logTrace((String)"Finally, removeTestData");
            this.removeTestData();
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test4() {
        boolean pass = false;
        int memId = 8;
        try {
            TestUtil.logTrace((String)"test4: createTestData");
            this.entityManager.joinTransaction();
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"find member");
            Member member = this.getMember(memId);
            if (null != member) {
                TestUtil.logTrace((String)"check member status");
                this.checkMemberStatus(member);
                this.entityManager.refresh((Object)member);
                if (member.getDonation().toString().equals("10000")) {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)" member is null, Unexpected - cannot proceed with test.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception:", (Throwable)e);
        }
        finally {
            this.removeTestData();
        }
        return pass;
    }

    public void checkMemberStatus(Member m) {
        System.out.println("checkMemberStatus - joinTransaction");
        int newDonation = 10000;
        if (null == m) {
            TestUtil.logTrace((String)"checkMemberStatus: member is NULL");
        } else {
            if (m.isDuesPaid()) {
                TestUtil.logTrace((String)"checkCustomerStatus: thisMember is not null, setDonation");
                m.setDonation(new BigInteger("10000"));
            } else {
                BigInteger currentDonation = m.getDonation();
                int convertedDonation = 0;
                if (currentDonation != null) {
                    convertedDonation = currentDonation.intValue();
                }
                m.setDonation(new BigInteger(String.valueOf(convertedDonation + newDonation)));
                m.setDuesPaid(true);
            }
            TestUtil.logTrace((String)"merge thisMember");
            this.entityManager.flush();
        }
    }

    public Member getMember(int memberId) {
        TestUtil.logTrace((String)"getMember");
        return (Member)this.entityManager.find(Member.class, (Object)memberId);
    }

    public void createTestData() {
        TestUtil.logTrace((String)"createTestData");
        try {
            TestUtil.logTrace((String)"Create Member Entities");
            Stateful3Bean.mRef[0] = new Member(7, "Jane Lam", false);
            Stateful3Bean.mRef[1] = new Member(8, "Vinny Testa", false);
            Stateful3Bean.mRef[2] = new Member(9, "Mario Luigi", true, new BigInteger("25000"));
            Stateful3Bean.mRef[3] = new Member(10, "Sky Blue", false);
            Stateful3Bean.mRef[4] = new Member(11, "Leonardi DaVinci", true, new BigInteger("100000"));
            TestUtil.logTrace((String)"Start to persist Members ");
            System.out.println("Persist Member Entities");
            for (Member m : mRef) {
                if (m == null) continue;
                this.entityManager.persist((Object)m);
                TestUtil.logTrace((String)("persisted Member " + m));
            }
            this.entityManager.flush();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating member data:" + e));
        }
    }

    public void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        try {
            this.entityManager.createNativeQuery("DELETE FROM MEMBER").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.entityManagerFactory.getCache().evictAll();
    }
}

