/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.commonee;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import com.sun.ts.tests.jms.commonee.MDB_T_Test;
import java.util.Enumeration;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

@Stateful
@Remote(value={MDB_T_Test.class})
public class MDB_T_TestEJB
implements MDB_T_Test {
    @Resource
    private SessionContext sessionContext;
    private Properties p = null;
    @Resource(name="jms/MDB_QUEUE_REPLY")
    private transient Queue rcvrQueue;
    @Resource(name="jms/MyQueueConnectionFactory")
    private transient QueueConnectionFactory qFactory;
    private transient QueueConnection qConnect;
    @Resource(name="jms/MDB_TOPIC")
    private transient Topic topic;
    @Resource(name="jms/MyTopicConnectionFactory")
    private transient TopicConnectionFactory tFactory;
    private transient TopicConnection tConnect;
    private String jmsUser;
    private String jmsPassword;
    private long timeout;

    @Override
    public void setup(Properties props) {
        TestUtil.logTrace((String)"MDB_T_TestEJB.setup()");
        this.p = props;
        try {
            TestUtil.init((Properties)props);
            this.timeout = Long.parseLong(props.getProperty("jms_timeout"));
            this.jmsUser = props.getProperty("user");
            this.jmsPassword = props.getProperty("password");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.jmsUser == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.jmsPassword == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.qFactory == null || this.tFactory == null | this.rcvrQueue == null || this.topic == null || this.sessionContext == null) {
                throw new Exception("@Resource injection failed");
            }
        }
        catch (Exception e) {
            throw new EJBException("@setup failed: ", e);
        }
    }

    @Override
    public boolean askMDBToRunATest(String typeOfTest) {
        TestUtil.logTrace((String)"MDB_T_TestEJB.askMDBToRunATest()");
        boolean ok = true;
        String myMessage = "Sending a message to mdb";
        try {
            this.tConnect = this.tFactory.createTopicConnection(this.jmsUser, this.jmsPassword);
            TopicSession tSession = this.tConnect.createTopicSession(true, 0);
            this.tConnect.start();
            TopicPublisher tPublisher = tSession.createPublisher(this.topic);
            TextMessage msg = tSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.setText(myMessage);
            msg.setStringProperty("TestCase", typeOfTest);
            tPublisher.publish((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("@askMDBToRunATest: Error!", e);
        }
        finally {
            try {
                if (this.tConnect != null) {
                    this.tConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing TopicConnection", (Throwable)e);
            }
        }
        return ok;
    }

    @Override
    public boolean askMDBToSendAMessage(String typeOfMessage) {
        TestUtil.logTrace((String)"MDB_T_TestEJB.askMDBToSendAMessage()");
        boolean ok = true;
        String myMessage = "I want you to send a message";
        try {
            this.tConnect = this.tFactory.createTopicConnection(this.jmsUser, this.jmsPassword);
            TopicSession session = this.tConnect.createTopicSession(true, 0);
            TopicPublisher tPublisher = session.createPublisher(this.topic);
            this.tConnect.start();
            TextMessage msg = session.createTextMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.setText(myMessage);
            msg.setStringProperty("MessageType", typeOfMessage);
            TestUtil.logTrace((String)"@TestEJB - about to publish a message");
            tPublisher.publish((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in askMDBToSendAMessage:", (Throwable)e);
            throw new EJBException("@askMDBToSendAMessage: Error!");
        }
        finally {
            try {
                if (this.tConnect != null) {
                    this.tConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error Closing TopicConnection!", (Throwable)e);
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkOnResponse(String prop) {
        boolean status = false;
        try {
            TestUtil.logTrace((String)"MDB_T_TestEJB.checkOnResponse()");
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            status = this.recvMessageInternal(session, prop);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in checkOnResponse", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
        return status;
    }

    private boolean recvMessageInternal(QueueSession session, String prop) throws JMSException {
        boolean retcode = false;
        TestUtil.logTrace((String)"MDB_T_TestEJB.recvMessageInternal()");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            TestUtil.logTrace((String)("@recvMessageInternal trying to receive the message: " + i));
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            if (msgRec.getStringProperty("TestCase") != null || msgRec.getStringProperty("Status") != null) {
                if (msgRec.getStringProperty("TestCase").equals(prop) && msgRec.getStringProperty("Status").equals("Pass")) {
                    TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                    TestUtil.logTrace((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                    TestUtil.logTrace((String)"Pass: we got the expected msg back! ");
                    retcode = true;
                } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                    TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                    TestUtil.logTrace((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                    TestUtil.logTrace((String)"Fail: Error(s) occurred! ");
                } else {
                    TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
                    TestUtil.logTrace((String)("TestCase:  " + msgRec.getStringProperty("TestCase")));
                }
            } else if (msgRec.getStringProperty("MessageType") != null) {
                if (msgRec.getStringProperty("MessageType").equals(prop)) {
                    TestUtil.logTrace((String)"Success: received Msg");
                    TestUtil.logTrace((String)"Pass: we got the expected msg back! ");
                    retcode = true;
                } else {
                    TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
                    TestUtil.logTrace((String)("MessageType:  " + msgRec.getStringProperty("MessageType")));
                }
            } else {
                TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
            }
        } else {
            TestUtil.logTrace((String)"Fail: we didnt get any msg back! ");
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThereSomethingInTheQueue() {
        TestUtil.logTrace((String)"MDB_T_TestEJB.isThereSomethingInTheQueue()");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        boolean ret = false;
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            qBrowser = session.createBrowser(this.rcvrQueue);
            msgs = qBrowser.getEnumeration();
            if (msgs.hasMoreElements()) {
                ret = true;
            }
            qBrowser.close();
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in isThereSomethingInTheQueue", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanTheQueue() {
        TestUtil.logTrace((String)"MDB_T_TestEJB.cleanTheQueue()");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        int numMsgs = 0;
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            TextMessage msgRec = null;
            qBrowser = session.createBrowser(this.rcvrQueue);
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            qBrowser.close();
            QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
            TestUtil.logTrace((String)("Cleaning " + numMsgs + " messages from the Q: " + this.rcvrQueue.getQueueName()));
            block12: for (int n = 0; n < numMsgs; ++n) {
                TestUtil.logTrace((String)("dequeuing msg: " + n + " from the Q: " + this.rcvrQueue.getQueueName()));
                for (int i = 0; i < 10; ++i) {
                    msgRec = (TextMessage)rcvr.receive(this.timeout);
                    if (msgRec != null) {
                        TestUtil.logTrace((String)("dequeued message: " + n));
                        continue block12;
                    }
                    TestUtil.logTrace((String)("Attempt no: " + i + " Trying to dequeue message: " + n));
                }
            }
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in cleanTheQueue", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
    }

    @Override
    @Remove
    public void remove() {
        TestUtil.logTrace((String)"MDB_T_TestEJB.remove()");
    }

    @PostActivate
    public void activate() {
        TestUtil.logTrace((String)"MDB_T_TestEJB.activate()");
        try {
            TSNamingContext context = new TSNamingContext();
            this.rcvrQueue = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.qFactory = (QueueConnectionFactory)context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.tFactory = (TopicConnectionFactory)context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            this.topic = (Topic)context.lookup("java:comp/env/jms/MDB_TOPIC");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error looking up Queue, Topic, ConnectionFactory objects", (Throwable)e);
            throw new EJBException("@activate: Error!", e);
        }
    }

    @PrePassivate
    public void passivate() {
        TestUtil.logTrace((String)"MDB_T_TestEJB.passivate()");
        this.rcvrQueue = null;
        if (this.qConnect != null) {
            try {
                this.qConnect.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
            this.qConnect = null;
        }
        this.qFactory = null;
        this.topic = null;
        if (this.tConnect != null) {
            try {
                this.tConnect.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing TopicConnection", (Throwable)e);
            }
            this.tConnect = null;
        }
        this.tFactory = null;
    }
}

