/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.convert;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.convert.Address;
import com.sun.ts.tests.jpa.core.annotations.convert.B;
import com.sun.ts.tests.jpa.core.annotations.convert.Country;
import com.sun.ts.tests.jpa.core.annotations.convert.Customer;
import com.sun.ts.tests.jpa.core.annotations.convert.Employee;
import com.sun.ts.tests.jpa.core.annotations.convert.FullTimeEmployee;
import com.sun.ts.tests.jpa.core.annotations.convert.FullTimeEmployee2;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void convertTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Employee expected = new Employee(1, "Alan", "Smith", "3#5#0#0#0.0");
            TestUtil.logTrace((String)"Persisting Employee");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Employees and verify them and their departments");
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)expected.getId());
            if (emp != null) {
                TestUtil.logTrace((String)("Found employee: " + emp.getId()));
                expected.setSalary(expected.getSalary().replace("#", ""));
                if (emp.equals((Object)expected)) {
                    TestUtil.logTrace((String)("Received expected employee:" + emp.toString()));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected:" + expected.toString() + ", actual:" + emp.toString()));
                }
            } else {
                TestUtil.logErr((String)("Find returned null Employee instead of:" + expected));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("convertTest failed");
        }
    }

    public void convertExceptionDuringPersistTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)("isActive():" + this.getEntityTransaction().isActive()));
            B b = new B("1", "name1", 1, new Address("500 Oracle Parkway", "Redwood Shores", -1));
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"Did not received expected PersistenceException");
        }
        catch (PersistenceException pe) {
            TestUtil.logTrace((String)"Received expected PersistenceException");
            if (this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            } else {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("convertExceptionDuringPersistTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertExceptionDuringLoadTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)("isActive():" + this.getEntityTransaction().isActive()));
            B b = new B("1", "name1", 1, new Address("500 Oracle Parkway", "Redwood Shores", -2));
            TestUtil.logTrace((String)"Persisting B");
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            try {
                TestUtil.logTrace((String)"Finding B");
                B b1 = (B)this.getEntityManager().find(B.class, (Object)"1");
                TestUtil.logErr((String)"Did not received expected PersistenceException");
            }
            catch (PersistenceException pe) {
                TestUtil.logTrace((String)"Received expected PersistenceException");
                if (this.getEntityTransaction().getRollbackOnly()) {
                    TestUtil.logTrace((String)"Transaction was marked for rollback");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Transaction was not marked for rollback");
                }
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception re) {
                    TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
                }
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("convertExceptionDuringLoadTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertsTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            String street = "500.Oracle.Parkway";
            String city = "Redwood Shores";
            B b = new B("1", "name1", 1000, new Address(street, city, 1));
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            B b1 = (B)this.getEntityManager().find(B.class, (Object)"1");
            TestUtil.logTrace((String)("B:" + b1.toString()));
            if (b1.getBValue().equals(1110)) {
                TestUtil.logTrace((String)("Received expected value:" + b1.getBValue()));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Converter was not properly applied, expected value:1002, actual" + b1.getBValue()));
            }
            Address a = b1.getAddress();
            if (a.getStreet().equals(street.replace(".", "_"))) {
                TestUtil.logTrace((String)("Received expected street:" + a.getStreet()));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Converter was not properly applied, expected street:" + street + ", actual:" + a.getStreet()));
            }
            if (a.getState() == 1) {
                TestUtil.logTrace((String)("Received expected state:" + a.getState()));
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Converter was not properly applied, expected state: 1, actual: " + a.getState()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("convertsTest failed");
        }
    }

    public void mappedSuperClassTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            char[] c = new char[]{'D', 'o', 'e'};
            FullTimeEmployee expected = new FullTimeEmployee(1, "John", c, "3#5#0#0#0.0");
            TestUtil.logTrace((String)("Persisting FullTimeEmployee:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Employees and verify them and their departments");
            FullTimeEmployee emp = (FullTimeEmployee)this.getEntityManager().find(FullTimeEmployee.class, (Object)expected.getId());
            if (emp != null) {
                TestUtil.logTrace((String)("Found FullTimeEmployee: " + emp.getId()));
                expected.setSalary(expected.getSalary().replace("#", ""));
                c = new char[]{'J', 'a', 'm', 'e', 's'};
                expected.setLastName(c);
                if (emp.equals((Object)expected)) {
                    TestUtil.logTrace((String)("Received expected FullTimeEmployee:" + emp.toString()));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected:" + expected.toString() + ", actual:" + emp.toString()));
                }
            } else {
                TestUtil.logErr((String)("Find returned null FullTimeEmployee instead of:" + expected));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("mappedSuperClassTest failed");
        }
    }

    public void mappedSuperClass2Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            FullTimeEmployee2 expected = new FullTimeEmployee2(1, "J.o.h.n", "Hill", "3500.0");
            TestUtil.logTrace((String)("Persisting FullTimeEmployee2:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Employees and verify them and their departments");
            FullTimeEmployee2 emp = (FullTimeEmployee2)this.getEntityManager().find(FullTimeEmployee2.class, (Object)expected.getId());
            if (emp != null) {
                TestUtil.logTrace((String)("Found FullTimeEmployee2: " + emp.getId()));
                expected.setFirstName(expected.getFirstName().replace(".", "#"));
                if (emp.equals((Object)expected)) {
                    TestUtil.logTrace((String)("Received expected FullTimeEmployee:" + emp.toString()));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected:" + expected.toString() + ", actual:" + emp.toString()));
                }
            } else {
                TestUtil.logErr((String)("Find returned null FullTimeEmployee instead of:" + expected));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("mappedSuperClass2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert2Test() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            Employee expected = new Employee(1, "Alan", "Smith", "3#5#0#0#0.0");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            pass1 = true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing JPQL");
            List o = this.getEntityManager().createQuery("Select e from Employee e WHERE e.id = 1", Employee.class).getResultList();
            if (o.size() == 1) {
                Employee emp = (Employee)o.get(0);
                TestUtil.logTrace((String)("Employee:" + emp.toString()));
                if (emp.getSalary().equals("35000.0")) {
                    TestUtil.logTrace((String)("Received expected value:" + emp.getSalary()));
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)("Converter was not properly applied, expected value:35000.0, actual" + emp.getSalary()));
                }
            } else {
                TestUtil.logErr((String)("Expected 1 entity to be returned, actual:" + o.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing Criteria");
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            if (cquery != null) {
                TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee).where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)1));
                Employee emp = (Employee)this.getEntityManager().createQuery(cquery).getSingleResult();
                if (emp != null) {
                    TestUtil.logTrace((String)("Employee:" + emp.toString()));
                    if (emp.getSalary().equals("35000.0")) {
                        TestUtil.logTrace((String)("Received expected value:" + emp.getSalary()));
                        pass3 = true;
                    } else {
                        TestUtil.logErr((String)("Converter was not properly applied, expected value:35000.0, actual" + emp.getSalary()));
                    }
                } else {
                    TestUtil.logErr((String)"Null Employee result was returned");
                }
            } else {
                TestUtil.logErr((String)"createQuery returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("converts2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert3Test() throws EETest.Fault {
        Object expected;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            expected = new Employee(1, "Alan", "Smith", "0");
            this.getEntityManager().persist(expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            pass1 = true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing JPQL");
            expected = "54321.0";
            this.getEntityManager().createQuery("Update Employee e set e.salary='5#4#3#2#1.0'  WHERE e.id = 1").executeUpdate();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            if (emp != null) {
                TestUtil.logTrace((String)("Found employee: " + emp.getId()));
                if (emp.getSalary().equals(expected)) {
                    TestUtil.logTrace((String)("Received expected value:" + emp.getSalary()));
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)("Converter was not properly applied, expected value:" + (String)expected + ", actual" + emp.getSalary()));
                }
            } else {
                TestUtil.logErr((String)"Find returned null Employee");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing Criteria");
            expected = "3500.0";
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Employee.class);
            Root employee = cd.from(Employee.class);
            TestUtil.logTrace((String)"Obtained expected root");
            cd.set("salary", (Object)"3#5#0#0.0");
            cd.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)1));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            if (actual == 1) {
                this.clearCache();
                this.getEntityTransaction().begin();
                Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
                if (emp != null) {
                    TestUtil.logTrace((String)("Found employee: " + emp.getId()));
                    if (emp.getSalary().equals("3500.0")) {
                        TestUtil.logTrace((String)("Received expected value:" + emp.getSalary()));
                        pass3 = true;
                    } else {
                        TestUtil.logErr((String)("Converter was not properly applied, expected value:" + (String)expected + ", actual" + emp.getSalary()));
                    }
                } else {
                    TestUtil.logErr((String)("Find returned null Employee instead of:" + (String)expected));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)("Expected 1 update, actual:" + actual));
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("converts3Test failed");
        }
    }

    public void embeddedTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            String name = "john smith";
            String country = "United States";
            Customer expected = new Customer("1", name, new Country(country, "USA"));
            TestUtil.logTrace((String)("Persisting Customer:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                TestUtil.logTrace((String)("Found Customer: " + cust.toString()));
                String tmp = country.replace(" ", "_");
                if (cust.getCountry().getCountry().equals(tmp)) {
                    TestUtil.logTrace((String)("Received expected Country:" + cust.getCountry().getCountry()));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected:" + tmp + ", actual:" + cust.getCountry().getCountry()));
                }
            } else {
                TestUtil.logErr((String)"Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("embeddedTest failed");
        }
    }

    public void elementCollectionBasicType() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<String> phones = new ArrayList<String>();
            phones.add("781,442,2010");
            phones.add("781,442,2011");
            phones.add("781,442,2012");
            ArrayList<String> expectedphones = new ArrayList<String>();
            for (String p : phones) {
                expectedphones.add(p.replace(",", "-"));
            }
            expected.setPhones(phones);
            TestUtil.logTrace((String)("Persisting Customer:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                TestUtil.logTrace((String)("Found Customer: " + cust.toString()));
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    TestUtil.logTrace((String)"Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logTrace((String)("phone:" + s));
                    }
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    for (String s : expectedphones) {
                        TestUtil.logTrace((String)("expected:" + s));
                    }
                    TestUtil.logErr((String)"actual:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logTrace((String)("actual:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("elementCollectionBasicType failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM B_EMBEDDABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

