/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.handler.uniqueness;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices.handler.uniqueness.Bye;
import com.sun.ts.tests.webservices.handler.uniqueness.Hello;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;

public class Client
extends EETest {
    private Hello port1;
    private Bye port2;

    private void getStub() throws Exception {
        InitialContext ctx = new InitialContext();
        TestUtil.logMsg((String)"JNDI lookup for uniquenesshello Service");
        Service svc = (Service)ctx.lookup("java:comp/env/service/uniquenesshello");
        TestUtil.logMsg((String)"Service found");
        TestUtil.logMsg((String)"Get port from Service");
        this.port1 = (Hello)svc.getPort(Hello.class);
        TestUtil.logMsg((String)"Port obtained");
        TestUtil.logMsg((String)"JNDI lookup for uniquenessbye Service");
        svc = (Service)ctx.lookup("java:comp/env/service/uniquenessbye");
        TestUtil.logMsg((String)"Service found");
        TestUtil.logMsg((String)"Get port from Service");
        this.port2 = (Bye)svc.getPort(Bye.class);
        TestUtil.logMsg((String)"Port obtained");
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.getStub();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void printSeperationLine() {
        TestUtil.logMsg((String)"---------------------------");
    }

    public void checkUniqueness() throws EETest.Fault {
        TestUtil.logMsg((String)"checkUniqueness");
        try {
            this.port1.hello();
            this.port2.bye();
            TestUtil.logMsg((String)"checkUniqueness passed");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test checkUniqueness failed: got exception " + t.toString()));
            throw new EETest.Fault("checkUniqueness failed");
        }
    }

    public void seriousCheck() throws EETest.Fault {
        TestUtil.logMsg((String)"seriousCheck");
        try {
            this.port2.bye();
            this.port1.hello();
            this.port1.hello();
            this.port2.bye();
            TestUtil.logMsg((String)"seriousCheck passed");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test seriousCheck failed: got exception " + t.toString()));
            throw new EETest.Fault("seriousCheck failed");
        }
    }

    public void checkPerPCParameters() throws EETest.Fault {
        TestUtil.logMsg((String)"checkPerPCParameters");
        try {
            String v1 = this.port1.hello();
            int v2 = this.port2.bye();
            if (v1.indexOf("Null MessageContext obj!") != -1) {
                TestUtil.logMsg((String)"RPC call to hello endpoint had unexpected Null MessageContext obj!");
            }
            if (v2 == -1111) {
                TestUtil.logMsg((String)"RPC call to bye endpoint had unexpected Null MessageContext obj!");
            }
            if (!v1.endsWith("HelloPC") || v2 % 10 != 2) {
                TestUtil.logMsg((String)("***Bad return value(s): v1 = " + v1 + ", v2 = " + v2));
                throw new RuntimeException("did not get expected init data");
            }
            TestUtil.logMsg((String)"checkPerPCParameters passed");
            TestUtil.logMsg((String)("with return value(s): v1 = " + v1 + ", v2 = " + v2));
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test checkPerPCParameters failed: got exception " + t.toString()));
            throw new EETest.Fault("checkPerPCParameters failed");
        }
    }
}

