/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.HandlerTracker;
import com.sun.ts.tests.jaxws.common.Handler_Util;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;

public class LogicalHandlerBase2
implements LogicalHandler<LogicalMessageContext> {
    private int destroyCalled = 0;
    private int doingHandlerWork = 0;
    private String whichHandlerType = null;
    private String handlerName = null;

    public void setWhichHandlerType(String w) {
        this.whichHandlerType = w;
    }

    public String getWhichHandlerType() {
        return this.whichHandlerType;
    }

    public void setHandlerName(String h) {
        this.handlerName = h;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void preinvoke() {
        ++this.doingHandlerWork;
        if (this.destroyCalled > 0) {
            HandlerTracker.reportThrowable((Handler)this, new Exception("Violation of Handler Lifecycle - Handler used after destroy called"));
        }
    }

    public void postinvoke() {
        this.doingHandlerWork = 0;
    }

    @PostConstruct
    public void myInit() {
        System.out.println("in " + this + ":myInit");
        HandlerTracker.reportInit((Handler)this, "myInit");
    }

    @PreDestroy
    public void myDestroy() {
        System.out.println("in " + this + ":myDestroy");
        if (this.doingHandlerWork > 0) {
            HandlerTracker.reportThrowable((Handler)this, new Exception("Violation of Handler Lifecycle - destroy called during handler usage"));
        }
        ++this.destroyCalled;
        HandlerTracker.reportDestroy((Handler)this, "myDestroy");
    }

    public boolean handleMessage(LogicalMessageContext context) {
        System.out.println("in " + this + ":handleMessage");
        TestUtil.logTrace((String)("in " + this + ":handleMessage"));
        try {
            this.preinvoke();
            Handler_Util.setTraceFlag(Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogtraceflag"));
            Handler_Util.initTestUtil((Handler)this, Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnessloghost"), Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogport"), Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogtraceflag"));
            if (!Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "GetTrackerData")) {
                String direction = Handler_Util.getDirection((MessageContext)context);
                HandlerTracker.reportHandleMessage((Handler)this, direction);
            } else {
                TestUtil.logTrace((String)"found GetTrackerData message, handler will ignore");
            }
        }
        finally {
            this.postinvoke();
        }
        System.out.println("exiting " + this + ":handleMessage");
        TestUtil.logTrace((String)("exiting " + this + ":handleMessage"));
        return true;
    }

    public void close(MessageContext context) {
        TestUtil.logTrace((String)("in " + this + ":close"));
        try {
            this.preinvoke();
            HandlerTracker.reportClose((Handler)this);
        }
        finally {
            this.postinvoke();
        }
    }

    public boolean handleFault(LogicalMessageContext context) {
        System.out.println("in " + this + ":handleFault");
        TestUtil.logTrace((String)("in " + this + ":handleFault"));
        try {
            this.preinvoke();
            HandlerTracker.reportHandleFault((Handler)this);
        }
        finally {
            this.postinvoke();
        }
        TestUtil.logTrace((String)("exiting " + this + ":handleFault"));
        System.out.println("exiting " + this + ":handleFault");
        return true;
    }
}

