/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;

public class BytesMessageTestImpl
extends MessageTestImpl
implements BytesMessage {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("buf", byte[].class)};
    long bodyLength = 0L;
    transient ByteArrayInputStream bais;
    transient DataInputStream dis;
    byte[] buf;
    transient ByteArrayOutputStream baos;
    transient DataOutputStream dos;

    public BytesMessageTestImpl() {
        this.init();
    }

    private void init() {
        this.buf = new byte[0];
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.dos.flush();
        this.buf = this.baos.toByteArray();
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        if (this.buf != null) {
            this.dos.write(this.buf);
            this.buf = null;
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.buf = null;
        this.bais = null;
        this.dis = null;
        this.readMode = false;
    }

    public boolean readBoolean() throws JMSException {
        boolean ret = false;
        this.checkReadAccess();
        try {
            ret = this.dis.readBoolean();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public byte readByte() throws JMSException {
        TestUtil.logTrace((String)"readByte");
        this.checkReadAccess();
        byte ret = 0;
        try {
            ret = this.dis.readByte();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public int readUnsignedByte() throws JMSException {
        TestUtil.logTrace((String)"readUnsignedByte");
        int ret = 0;
        this.checkReadAccess();
        try {
            ret = this.dis.readUnsignedByte();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public short readShort() throws JMSException {
        TestUtil.logTrace((String)"readShort");
        this.checkReadAccess();
        short ret = 0;
        try {
            ret = this.dis.readShort();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public int readUnsignedShort() throws JMSException {
        TestUtil.logTrace((String)"readUnsignedShort");
        this.checkReadAccess();
        int ret = 0;
        try {
            ret = this.dis.readUnsignedShort();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public char readChar() throws JMSException {
        TestUtil.logTrace((String)"readChar");
        this.checkReadAccess();
        char ret = '\u0000';
        try {
            ret = this.dis.readChar();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public int readInt() throws JMSException {
        TestUtil.logTrace((String)"readInt");
        this.checkReadAccess();
        int ret = 0;
        try {
            ret = this.dis.readInt();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public long readLong() throws JMSException {
        TestUtil.logTrace((String)"readLong");
        this.checkReadAccess();
        long ret = 0L;
        try {
            ret = this.dis.readLong();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public float readFloat() throws JMSException {
        TestUtil.logTrace((String)"readFloat");
        this.checkReadAccess();
        float ret = 0.0f;
        try {
            ret = this.dis.readFloat();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public double readDouble() throws JMSException {
        TestUtil.logTrace((String)"readDouble");
        this.checkReadAccess();
        double ret = 0.0;
        try {
            ret = this.dis.readDouble();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public String readUTF() throws JMSException {
        TestUtil.logTrace((String)"readUTF");
        this.checkReadAccess();
        String ret = null;
        try {
            ret = this.dis.readUTF();
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public int readBytes(byte[] value) throws JMSException {
        TestUtil.logTrace((String)"readBytes");
        this.checkReadAccess();
        int ret = -1;
        try {
            ret = this.dis.read(value);
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        TestUtil.logTrace((String)"readBytes");
        this.checkReadAccess();
        int ret = -1;
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            ret = this.dis.read(value, 0, length);
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public void writeBoolean(boolean writeBoolean) throws JMSException {
        try {
            this.dos.writeBoolean(writeBoolean);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeByte(byte value) throws JMSException {
        try {
            this.dos.writeByte(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeShort(short value) throws JMSException {
        try {
            this.dos.writeShort(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeChar(char value) throws JMSException {
        try {
            this.dos.writeChar(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeInt(int value) throws JMSException {
        try {
            this.dos.writeInt(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeLong(long value) throws JMSException {
        try {
            this.dos.writeLong(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeFloat(float value) throws JMSException {
        try {
            this.dos.writeFloat(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeDouble(double value) throws JMSException {
        try {
            this.dos.writeDouble(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeUTF(String value) throws JMSException {
        try {
            this.dos.writeUTF(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        try {
            this.dos.write(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        try {
            this.dos.write(value, offset, length);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Invalid type");
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.bufferIsDirty) {
                TestUtil.logTrace((String)"flush dos");
                this.dos.flush();
                this.dos.close();
                this.baos.close();
            }
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        if (this.baos != null) {
            this.buf = this.baos.toByteArray();
            TestUtil.logTrace((String)"baos.toByteArray");
        } else if (this.buf == null) {
            this.buf = new byte[0];
            TestUtil.logTrace((String)"buf = new byte[0]");
        }
        this.bais = new ByteArrayInputStream(this.buf);
        TestUtil.logTrace((String)"dis = new DataInputStream(bais)");
        this.dis = new DataInputStream(this.bais);
        this.setBufferIsDirty(false);
        this.readMode = true;
    }

    public long getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(long l) {
        this.bodyLength = l;
    }
}

