/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler.GenericHandler;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler.GenericHandler.Hello;
import com.sun.ts.tests.jaxrpc.common.HandlerTracker;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;

public class Client
extends ServiceEETest {
    private Properties props = null;
    Hello port = null;
    Service svc = null;

    private void getStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            TestUtil.logMsg((String)"Obtained InitialContext");
            TestUtil.logMsg((String)"Lookup java:comp/env/service/generichandler");
            this.svc = (Service)ic.lookup("java:comp/env/service/generichandler");
            TestUtil.logMsg((String)"Obtained service");
            this.port = (Hello)this.svc.getPort(Hello.class);
            TestUtil.logMsg((String)"Obtained port");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        boolean pass = true;
        try {
            this.getStub();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void DoGenericHandlerTest() throws EETest.Fault {
        TestUtil.logTrace((String)"DoGenericHandlerTest");
        boolean pass = true;
        boolean fault = true;
        try {
            TestUtil.logMsg((String)"This is a test to verify the JAXRPC Soap Message Handler Functionality");
            TestUtil.logMsg((String)"Register Client-Side handlers: ClientHandler1,ClientHandler2,ClientHandler3");
            TestUtil.logMsg((String)"Register Server-Side handlers: ServeServerer1,ServerHandler2,ServerHandler3");
            String serverSideMsgs = this.port.doGenericHandlerTest();
            String clientSideMsgs = HandlerTracker.get();
            HandlerTracker.purge();
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)"Dumping Client-Side GenericHandler messages");
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)clientSideMsgs);
            TestUtil.logMsg((String)"Verifying Client-Side GenericHandler usage messages");
            if (!this.VerifyGenericHandler("client", clientSideMsgs)) {
                TestUtil.logErr((String)"Client-Side GenericHandler usage (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Client-Side GenericHandler usage (correct)");
            }
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)"Dumping Server-Side GenericHandler messages");
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)serverSideMsgs);
            TestUtil.logMsg((String)"Verifying Server-Side GenericHandler usage");
            if (!this.VerifyGenericHandler("server", serverSideMsgs)) {
                TestUtil.logErr((String)"Server-Side GenericHandler usage (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Server-Side GenericHandler usage (correct)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("DoGenericHandlerTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("DoGenericHandlerTest failed");
        }
    }

    private boolean VerifyGenericHandler(String who, String calls) {
        boolean startIdx = false;
        boolean endIdx = false;
        boolean pass = true;
        if (who.equals("client")) {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (calls.indexOf("ClientHandler1.handleRequest()") == -1) {
                TestUtil.logErr((String)"ClientHandler1.handleRequest() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler2.handleResponse()") == -1) {
                TestUtil.logErr((String)"ClientHandler2.handleResponse() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler3.handleRequest()") == -1) {
                TestUtil.logErr((String)"ClientHandler3.handleRequest() was not called");
                pass = false;
            }
        } else {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (calls.indexOf("ServerHandler1.handleRequest()") == -1) {
                TestUtil.logErr((String)"ServerHandler1.handleRequest() was not called");
                pass = false;
            }
            if (calls.indexOf("ServerHandler3.handleRequest()") == -1) {
                TestUtil.logErr((String)"ServerHandler3.handleRequest() was not called");
                pass = false;
            }
        }
        return pass;
    }
}

