/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.common;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManager;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManagerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;

public abstract class PMClientBase
extends ServiceEETest
implements UseEntityManager,
UseEntityManagerFactory,
Serializable {
    protected Properties myProps;
    private transient EntityManager em;
    private transient EntityTransaction et;
    private transient boolean inContainer;
    private transient EntityManagerFactory emf;
    EntityManagerFactory javaEEemf;
    public boolean cachingSupported = true;
    public static final transient String PROVIDER_PROP = "javax.persistence.provider";
    public static final transient String TRANSACTION_TYPE_PROP = "javax.persistence.transactionType";
    public static final transient String JTA_DATASOURCE_PROP = "javax.persistence.jtaDataSource";
    public static final transient String NON_JTA_DATASOURCE_PROP = "javax.persistence.nonJtaDataSource";
    public static final transient String RESOURCE_LOCAL = "RESOURCE_LOCAL";
    public static final transient String MODE_PROP = "platform.mode";
    public static final transient String JAVAEE_MODE = "javaEE";
    public static final transient String STANDALONE_MODE = "standalone";
    public static final transient String PERSISTENCE_UNIT_NAME_PROP = "persistence.unit.name";
    public static final transient String SECOND_PERSISTENCE_UNIT_NAME_PROP = "persistence.unit.name.2";
    public static final transient String JAVAX_PERSISTENCE_PROVIDER = "javax.persistence.provider";
    public static final transient String JAVAX_PERSISTENCE_JDBC_DRIVER = "javax.persistence.jdbc.driver";
    public static final transient String JAVAX_PERSISTENCE_JDBC_URL = "javax.persistence.jdbc.url";
    public static final transient String JAVAX_PERSISTENCE_JDBC_USER = "javax.persistence.jdbc.user";
    public static final transient String JAVAX_PERSISTENCE_JDBC_PASSWORD = "javax.persistence.jdbc.password";
    public static final transient String JPA_PROVIDER_IMPLEMENTATION_SPECIFIC_PROPERTIES = "jpa.provider.implementation.specific.properties";
    public static final transient String PERSISTENCE_SECOND_LEVEL_CACHING_SUPPORTED = "persistence.second.level.caching.supported";
    private transient String mode;
    private String persistenceUnitName;
    protected String secondPersistenceUnitName;

    protected PMClientBase() {
    }

    protected void removeEntity(Object o) {
        if (o != null) {
            try {
                this.getEntityManager().remove(o);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"removeEntity: Exception caught when removing entity: ", (Throwable)e);
            }
        }
    }

    public String getPersistenceUnitName() {
        TestUtil.logTrace((String)("getPersistenceUnitName() - Persistence Unit Name:" + this.persistenceUnitName));
        return this.persistenceUnitName;
    }

    public String getSecondPersistenceUnitName() {
        TestUtil.logTrace((String)("getSecondPersistenceUnitName() - Second Persistence Unit Name:" + this.secondPersistenceUnitName));
        return this.secondPersistenceUnitName;
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"PMClientBase.setup");
        this.myProps = p;
        this.mode = p.getProperty(MODE_PROP);
        this.persistenceUnitName = p.getProperty(PERSISTENCE_UNIT_NAME_PROP);
        TestUtil.logTrace((String)("Persistence Unit Name =" + this.persistenceUnitName));
        this.secondPersistenceUnitName = p.getProperty(SECOND_PERSISTENCE_UNIT_NAME_PROP);
        TestUtil.logTrace((String)("Second Persistence Unit Name =" + this.secondPersistenceUnitName));
        if (JAVAEE_MODE.equalsIgnoreCase(this.mode)) {
            TestUtil.logTrace((String)("platform.mode is set to " + this.mode + ", so tests are running in JavaEE environment."));
        } else if (STANDALONE_MODE.equalsIgnoreCase(this.mode)) {
            TestUtil.logTrace((String)("platform.mode is set to " + this.mode + ", so tests are running in J2SE environment standalone mode." + PERSISTENCE_UNIT_NAME_PROP + " is set to " + this.persistenceUnitName));
        } else {
            TestUtil.logMsg((String)("WARNING: platform.mode is set to " + this.mode + ", an invalid value."));
        }
        this.cachingSupported = Boolean.parseBoolean(p.getProperty(PERSISTENCE_SECOND_LEVEL_CACHING_SUPPORTED, "true"));
        if (TestUtil.traceflag) {
            this.displayProperties(p);
        }
    }

    public void displayProperties(Properties props) {
        TestUtil.logMsg((String)"Current properties:");
        for (Object entry : props.keySet()) {
            if (props.get(entry) instanceof String) {
                TestUtil.logTrace((String)("Key:" + (String)entry + ", value:[" + props.get(entry) + "]"));
                continue;
            }
            TestUtil.logTrace((String)("Key:" + (String)entry + ", value:" + props.get(entry).getClass().getSimpleName()));
        }
    }

    public void cleanup() throws EETest.Fault {
        this.closeEMAndEMF();
    }

    public void cleanupNoSuper() throws EETest.Fault {
    }

    public void closeEMAndEMF() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"Rolling back any existing transaction before closing EMF and EM if one exists.");
            if (this.getEntityTransaction(false) != null && this.getEntityTransaction(false).isActive()) {
                TestUtil.logTrace((String)"An active transaction was found, rolling it back.");
                this.getEntityTransaction(false).rollback();
            }
        }
        catch (Exception fe) {
            TestUtil.logMsg((String)"Unexpected exception rolling back TX:", (Throwable)fe);
        }
        this.clearCache();
        if (this.isStandAloneMode()) {
            TestUtil.logTrace((String)"Closing EM and EMF");
            if (this.getEntityManager(false) != null && this.getEntityManager(false).isOpen()) {
                this.getEntityManager(false).close();
            }
            if (this.getEntityManagerFactory() != null && this.getEntityManagerFactory().isOpen()) {
                this.getEntityManagerFactory().close();
            }
        }
    }

    public void clearEMAndEMF() throws EETest.Fault {
        this.closeEMAndEMF();
        this.clearEntityManager();
        this.clearEntityManagerFactory();
    }

    public void clearEntityManager() {
        if (this.isStandAloneMode()) {
            this.em = null;
        }
    }

    public void clearEntityManagerFactory() {
        if (this.isStandAloneMode()) {
            this.emf = null;
        }
    }

    public void clearCache() throws EETest.Fault {
        if (this.cachingSupported) {
            if (this.getEntityManager() != null && this.getEntityManager().isOpen()) {
                if (this.getEntityManager().getEntityManagerFactory() != null && this.getEntityManager().getEntityManagerFactory().isOpen()) {
                    TestUtil.logTrace((String)"Clearing context");
                    this.getEntityManager().clear();
                    TestUtil.logTrace((String)"Trying to clear cache via call to EMF.getCache().evictAll().");
                    Cache cache = this.getEntityManager().getEntityManagerFactory().getCache();
                    if (cache != null) {
                        cache.evictAll();
                        TestUtil.logTrace((String)"EMF.getCache().evictAll() was executed.");
                    } else {
                        TestUtil.logErr((String)"Cache supported is true in ts.jte but getCache() is returning null");
                    }
                } else {
                    TestUtil.logTrace((String)"Clearing of cache did not occur because either EntityManagerFactory was null or closed");
                }
            } else {
                TestUtil.logTrace((String)"Clearing of cache did not occur because either EntityManager was null or closed");
            }
        } else {
            TestUtil.logTrace((String)"Clearing of cache did not occur because it is not supposed.");
        }
    }

    @Override
    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    @Override
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.javaEEemf = emf;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.getEntityManager(false);
    }

    public EntityManager getEntityManager(boolean reInit) {
        if (!reInit) {
            if (this.em != null) {
                TestUtil.logTrace((String)("Using existing entity manager class:" + this.em.getClass().getName() + " isOpen:" + this.em.isOpen()));
                return this.em;
            }
            TestUtil.logTrace((String)"getEntityManager: false was specified and EM is null");
        }
        TestUtil.logTrace((String)"Need to Initialize EntityManager");
        if (this.isStandAloneMode()) {
            this.initEntityManager(this.persistenceUnitName, true);
            TestUtil.logTrace((String)("EntityManager class:" + this.em.getClass().getName() + " isOpen:" + this.em.isOpen()));
            return this.em;
        }
        throw new IllegalStateException("The test is running in JavaEE environment, but PMClientBase.em has not been initialized from the vehicle component.");
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.isStandAloneMode()) {
            if (this.emf != null) {
                TestUtil.logTrace((String)("EntityManagerFactory class:" + this.emf.getClass().getName() + " isOpen:" + this.emf.isOpen()));
            }
            return this.emf;
        }
        if (this.javaEEemf != null) {
            TestUtil.logTrace((String)("EntityManagerFactory class:" + this.javaEEemf.getClass().getName() + " isOpen:" + this.javaEEemf.isOpen()));
        }
        return this.javaEEemf;
    }

    public void clearEntityTransaction() {
        this.et = null;
    }

    @Override
    public void setEntityTransaction(EntityTransaction et) {
        this.et = et;
    }

    @Override
    public EntityTransaction getEntityTransaction() {
        if (this.et != null) {
            TestUtil.logTrace((String)("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive()));
            return this.et;
        }
        TestUtil.logTrace((String)"Need to get Transaction");
        if (this.isStandAloneMode()) {
            this.initEntityTransaction();
            if (this.et != null) {
                TestUtil.logTrace((String)("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive()));
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JavaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    public EntityTransaction getEntityTransaction(boolean reInit, EntityManager em) {
        if (!reInit && this.et != null) {
            TestUtil.logTrace((String)("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive()));
            return this.et;
        }
        if (this.isStandAloneMode()) {
            this.initEntityTransaction(em);
            if (this.et != null) {
                TestUtil.logTrace((String)("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive()));
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JavaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    public EntityTransaction getEntityTransaction(boolean reInit) {
        if (!reInit && this.et != null) {
            TestUtil.logTrace((String)("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive()));
            return this.et;
        }
        if (this.isStandAloneMode()) {
            this.initEntityTransaction();
            if (this.et != null) {
                TestUtil.logTrace((String)("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive()));
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JavaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    protected void initEntityManager(String persistenceUnitName, boolean useProps) {
        if (this.isStandAloneMode()) {
            TestUtil.logTrace((String)("in initEntityManager(String, boolean): " + persistenceUnitName));
            if (useProps) {
                Properties propsMap = this.getPersistenceUnitProperties();
                TestUtil.logTrace((String)"createEntityManagerFactory(String,Map)");
                this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)propsMap);
            } else {
                TestUtil.logTrace((String)"createEntityManagerFactory(String)");
                this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
            }
            Map emfMap = this.emf.getProperties();
            if (emfMap != null) {
                this.displayMap(emfMap);
            }
            this.em = this.emf.createEntityManager();
        } else {
            TestUtil.logMsg((String)"The test is running in JavaEE environment, the EntityManager is initialized in the vehicle component.");
        }
    }

    protected void initEntityTransaction() {
        EntityTransaction delegate;
        this.et = delegate = this.getEntityManager().getTransaction();
    }

    protected void initEntityTransaction(EntityManager em) {
        EntityTransaction delegate;
        this.et = delegate = em.getTransaction();
    }

    @Override
    public boolean isInContainer() {
        return this.inContainer;
    }

    @Override
    public void setInContainer(boolean inContainer) {
        this.inContainer = inContainer;
    }

    protected Properties getPersistenceUnitProperties() {
        Properties jpaProps = new Properties();
        jpaProps.put("javax.persistence.provider", this.myProps.get("javax.persistence.provider"));
        jpaProps.put(JAVAX_PERSISTENCE_JDBC_DRIVER, this.myProps.get(JAVAX_PERSISTENCE_JDBC_DRIVER));
        jpaProps.put(JAVAX_PERSISTENCE_JDBC_URL, this.myProps.get(JAVAX_PERSISTENCE_JDBC_URL));
        jpaProps.put(JAVAX_PERSISTENCE_JDBC_USER, this.myProps.get(JAVAX_PERSISTENCE_JDBC_USER));
        jpaProps.put(JAVAX_PERSISTENCE_JDBC_PASSWORD, this.myProps.get(JAVAX_PERSISTENCE_JDBC_PASSWORD));
        String provider_specific_props = (String)this.myProps.get(JPA_PROVIDER_IMPLEMENTATION_SPECIFIC_PROPERTIES);
        StringTokenizer st = new StringTokenizer(provider_specific_props, ":");
        while (st.hasMoreTokens()) {
            StringTokenizer st1 = new StringTokenizer(st.nextToken(), "=");
            String pspValue = null;
            String pspName = null;
            if (st1.hasMoreTokens()) {
                pspName = st1.nextToken();
            }
            if (st1.hasMoreTokens()) {
                pspValue = st1.nextToken();
            }
            jpaProps.put(pspName, pspValue);
        }
        this.checkPersistenceUnitProperties(jpaProps);
        return jpaProps;
    }

    public boolean isStandAloneMode() {
        return STANDALONE_MODE.equalsIgnoreCase(this.mode);
    }

    private void checkPersistenceUnitProperties(Properties jpaProps) {
        TestUtil.logTrace((String)("persistence unit properites from user: " + jpaProps.toString()));
        String provider = jpaProps.getProperty("javax.persistence.provider");
        if (provider == null) {
            throw new IllegalStateException("javax.persistence.provider not specified in persistence unit properties file");
        }
        String transactionType = jpaProps.getProperty(TRANSACTION_TYPE_PROP);
        if (transactionType != null && !RESOURCE_LOCAL.equals(transactionType)) {
            throw new IllegalStateException("javax.persistence.transactionType is set to an unsupported value: " + transactionType + ".  The only portably supported type is " + RESOURCE_LOCAL + ".  Please correct it in persistence unit properties file.");
        }
        String jtaDataSource = jpaProps.getProperty(JTA_DATASOURCE_PROP);
        if (jtaDataSource != null) {
            TestUtil.logMsg((String)("WARNING: javax.persistence.jtaDataSource is specified as " + jtaDataSource + ", and it will be passed to the persistence provider.  However, this is in general not supported in Java SE environment"));
        }
        TestUtil.logTrace((String)("persistence unit properites verified: " + jpaProps.toString()));
    }

    public Calendar getCalDate() {
        return Calendar.getInstance();
    }

    public Calendar getCalDate(int yy, int mm, int dd) {
        GregorianCalendar cal = new GregorianCalendar(yy, mm, dd);
        TestUtil.logTrace((String)("returning date:" + cal));
        return cal;
    }

    public Date getSQLDate(String sDate) {
        Date d = Date.valueOf(sDate);
        TestUtil.logTrace((String)("returning date:" + d));
        return d;
    }

    public Date getSQLDate(int yy, int mm, int dd) {
        Calendar newCal = this.getCalDate();
        newCal.clear();
        newCal.set(yy, mm, dd);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(newCal.getTime());
        TestUtil.logTrace((String)("returning date:" + Date.valueOf(sDate)));
        return Date.valueOf(sDate);
    }

    public Date getSQLDate() {
        Calendar calDate = this.getCalDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(calDate.getTime());
        Date d = Date.valueOf(sDate);
        TestUtil.logTrace((String)("returning date:" + d));
        return d;
    }

    public java.util.Date getUtilDate() {
        java.util.Date d = new java.util.Date();
        TestUtil.logTrace((String)("getPKDate: returning date:" + d));
        return d;
    }

    public java.util.Date getUtilDate(String sDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date d = null;
        try {
            d = formatter.parse(sDate);
        }
        catch (ParseException pe) {
            TestUtil.logErr((String)("Received unexpected exception:" + pe));
        }
        TestUtil.logTrace((String)("getPKDate: returning date:" + d));
        return d;
    }

    public Time getTimeData(String sTime) {
        Time t = Time.valueOf(sTime);
        TestUtil.logTrace((String)("getTimeData: returning Time:" + t));
        return t;
    }

    public Time getTimeData(int hh, int mm, int ss) {
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(hh, mm, ss);
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss");
        String sDate = sdf.format(newCal.getTime());
        TestUtil.logTrace((String)("getTimeData: returning Time:" + Time.valueOf(sDate)));
        return Time.valueOf(sDate);
    }

    public Timestamp getTimestampData(String sDate) {
        String tFormat = sDate + " 10:10:10";
        Timestamp ts = Timestamp.valueOf(tFormat);
        TestUtil.logTrace((String)("getTimestampData: returning TimeStamp:" + ts));
        return ts;
    }

    public Timestamp getTimestampData(int yy, int mm, int dd) {
        TestUtil.logTrace((String)"Entering getTimestampData");
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(yy, mm, dd);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = sdf.format(newCal.getTime());
        TestUtil.logTrace((String)("getTimestampData: returning TimeStamp:" + Timestamp.valueOf(sDate)));
        return Timestamp.valueOf(sDate);
    }

    public java.util.Date getPKDate(int yy, int mm, int dd) {
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(yy, mm, dd);
        TestUtil.logTrace((String)("getPKDate: returning date:" + newCal.getTime()));
        return newCal.getTime();
    }

    public void doFlush() throws PersistenceException {
        try {
            this.getEntityManager().flush();
        }
        catch (PersistenceException pe) {
            TestUtil.logErr((String)"Unexpected Exception caught while flushing: ", (Throwable)pe);
            throw new PersistenceException("Unexpected Exception caught while flushing: " + (Object)((Object)pe));
        }
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Collection<T> expectedPKS) {
        TestUtil.logTrace((String)"PMClientBase.checkEntityPK(Collection<T>,Collection<T>)");
        return this.checkEntityPK(actualPKS, expectedPKS, false);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Collection<T> expectedPKS, boolean allowDups) {
        Integer[] epks2 = new Integer[expectedPKS.size()];
        TestUtil.logTrace((String)"PMClientBase.checkEntityPK(Collection<T>,Collection<T>, boolean)");
        if (expectedPKS.size() != 0) {
            int i = 0;
            Iterator<T> iterator = expectedPKS.iterator();
            while (iterator.hasNext()) {
                T o;
                T ref = o = iterator.next();
                try {
                    if (ref instanceof Integer) {
                        epks2[i++] = (Integer)ref;
                        continue;
                    }
                    if (ref instanceof String) {
                        epks2[i++] = Integer.valueOf((String)ref);
                        continue;
                    }
                    Method m = ref.getClass().getMethod("getId", new Class[0]);
                    Object oo = m.invoke(ref, new Object[0]);
                    if (oo instanceof String) {
                        epks2[i++] = Integer.valueOf((String)oo);
                        continue;
                    }
                    epks2[i++] = (Integer)oo;
                }
                catch (NoSuchMethodException nsme) {
                    TestUtil.logErr((String)"Unexpected exception thrown", (Throwable)nsme);
                }
                catch (IllegalAccessException iae) {
                    TestUtil.logErr((String)"Unexpected exception thrown", (Throwable)iae);
                }
                catch (InvocationTargetException ite) {
                    TestUtil.logErr((String)"Unexpected exception thrown", (Throwable)ite);
                }
            }
        }
        return this.checkEntityPK(actualPKS, epks2, allowDups, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, String[] expectedPKS) {
        TestUtil.logTrace((String)"PMClientBase.checkEntityPK(Collection<T>,String[])");
        return this.checkEntityPK(actualPKS, expectedPKS, false);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, String[] expectedPKS, boolean allowDups) {
        Integer[] epks2 = new Integer[expectedPKS.length];
        TestUtil.logTrace((String)"PMClientBase.checkEntityPK(Collection<T>,String[], boolean)");
        if (expectedPKS.length != 0) {
            int i = 0;
            for (String s : expectedPKS) {
                epks2[i++] = Integer.valueOf(s);
            }
        }
        return this.checkEntityPK(actualPKS, epks2, allowDups, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Integer[] expectedPKS) {
        TestUtil.logTrace((String)"PMClientBase.checkEntityPK(Collection<T>,Integer[])");
        return this.checkEntityPK(actualPKS, expectedPKS, false, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Integer[] expectedPKS, boolean allowDups, boolean sortLists) {
        Object[] cpks2 = new Integer[actualPKS.size()];
        TestUtil.logTrace((String)"PMClientBase.checkEntityPK(Collection<T>,Integer[], boolean)");
        try {
            String cpks;
            String epks;
            if (expectedPKS.length == 0) {
                epks = "()";
            } else {
                if (sortLists) {
                    Arrays.sort((Object[])expectedPKS);
                }
                epks = this.createStringVersionOfPKS(expectedPKS);
            }
            if (actualPKS.size() == 0) {
                cpks = "()";
            } else {
                int k = 0;
                Iterator<T> iterator = actualPKS.iterator();
                while (iterator.hasNext()) {
                    T o;
                    T ref = o = iterator.next();
                    try {
                        if (ref instanceof Integer) {
                            cpks2[k++] = (Integer)ref;
                            continue;
                        }
                        if (ref instanceof String) {
                            cpks2[k++] = Integer.valueOf((String)ref);
                            continue;
                        }
                        Method m = ref.getClass().getMethod("getId", new Class[0]);
                        Object oo = m.invoke(ref, new Object[0]);
                        if (oo instanceof String) {
                            cpks2[k++] = Integer.valueOf((String)oo);
                            continue;
                        }
                        cpks2[k++] = (Integer)oo;
                    }
                    catch (NoSuchMethodException nsme) {
                        TestUtil.logErr((String)"Unexpected exception thrown", (Throwable)nsme);
                    }
                    catch (IllegalAccessException iae) {
                        TestUtil.logErr((String)"Unexpected exception thrown", (Throwable)iae);
                    }
                    catch (InvocationTargetException ite) {
                        TestUtil.logErr((String)"Unexpected exception thrown", (Throwable)ite);
                    }
                }
            }
            if (sortLists) {
                Arrays.sort(cpks2);
            }
            cpks = this.createStringVersionOfPKS((Integer[])cpks2);
            if (this.checkWrongSize(expectedPKS, (Integer[])cpks2)) {
                TestUtil.logErr((String)("Wrong size returned, expected PKs of " + epks + ", got PKs of " + cpks));
                return false;
            }
            if (!allowDups && this.checkDuplicates((Integer[])cpks2)) {
                TestUtil.logErr((String)("Duplicate values returned, expected PKs of " + epks + ", got PKs of " + cpks));
                return false;
            }
            if (!Arrays.equals((Object[])expectedPKS, cpks2)) {
                TestUtil.logErr((String)("Wrong values returned, expected PKs of " + epks + ", got PKs of " + cpks));
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in PMClientBase.checkEntityPK(Collection<T>,Integer[]: ", (Throwable)e);
            return false;
        }
        return true;
    }

    public String createStringVersionOfPKS(Integer[] iArray) {
        StringBuilder sb = new StringBuilder(2);
        sb.append("(");
        for (int i = 0; i < iArray.length; ++i) {
            sb.append(iArray[i]);
            if (i >= iArray.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean checkWrongSize(Integer[] expected, Integer[] actual) {
        TestUtil.logTrace((String)"PMClientbase.checkWrongSize");
        if (expected.length != actual.length) {
            TestUtil.logErr((String)("Wrong collection size returned (expected " + expected.length + ", got " + actual.length + ")"));
            return true;
        }
        return false;
    }

    public boolean checkDuplicates(Integer[] iArray) {
        TestUtil.logTrace((String)"PMClientbase.checkDuplicates");
        boolean duplicates = false;
        block0: for (int ii = 0; ii < iArray.length; ++ii) {
            for (int j = 0; j < iArray.length; ++j) {
                if (ii == j || !iArray[ii].equals(iArray[j])) continue;
                duplicates = true;
                continue block0;
            }
        }
        if (duplicates) {
            TestUtil.logErr((String)"Wrong collection contents returned (contains duplicate entries)");
            return true;
        }
        return false;
    }

    public String compareResultList(List expected, List actual) {
        if (!expected.equals(actual)) {
            String reason = "Expecting result list: " + expected + "  , actual: " + actual;
            throw new RuntimeException(reason);
        }
        String reason = "Got expected result list: " + expected;
        TestUtil.logTrace((String)reason);
        return reason;
    }

    public void displayMap(Map map) {
        if (map != null) {
            Set set = map.entrySet();
            for (Map.Entry me : set) {
                if (me.getValue() instanceof String) {
                    TestUtil.logTrace((String)("Map - name:" + (String)me.getKey() + ", value:" + me.getValue()));
                    continue;
                }
                TestUtil.logTrace((String)("Map - name:" + (String)me.getKey() + ", value:" + me.getValue().getClass().getName()));
            }
        } else {
            TestUtil.logTrace((String)"Map passed in to displayMap was null");
        }
    }

    public int convertToInt(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).intValue();
        }
        throw new IllegalArgumentException("convertToInt(): Received type not coded for:" + o.getClass().getName());
    }

    public boolean findDataInFile(File file, String searchString) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(searchString);
        return this.findDataInFile(file, list);
    }

    public boolean findDataInFile(File file, List<String> searchStrings) {
        boolean found = false;
        List<String> fileContents = this.getFileContent(file);
        int fileContentLineCount = 0;
        int foundCount = 0;
        block0: while (!found && foundCount != searchStrings.size() && fileContentLineCount != fileContents.size()) {
            for (String fileContent : fileContents) {
                ++fileContentLineCount;
                foundCount = 0;
                for (String searchString : searchStrings) {
                    TestUtil.logTrace((String)("searchString:" + searchString));
                    if (fileContent.toLowerCase().indexOf(searchString.toLowerCase()) < 0) continue;
                    TestUtil.logTrace((String)("Found string[" + searchString + "] in line [" + fileContent + "]"));
                    ++foundCount;
                }
                if (foundCount != searchStrings.size()) continue;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            if (searchStrings.size() > 1) {
                StringBuffer sb = new StringBuffer();
                int count = 0;
                for (String s : searchStrings) {
                    sb.append(s);
                    if (++count == searchStrings.size()) continue;
                    sb.append(" and ");
                }
                TestUtil.logErr((String)("Entries:" + sb.toString() + ", not found in file:" + file.toString()));
                for (String s : fileContents) {
                    TestUtil.logErr((String)("File line[" + s + "]"));
                }
            } else {
                TestUtil.logErr((String)("Entry:" + searchStrings.get(0) + ", not found in file:" + file.toString()));
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileContent(File file) {
        ArrayList<String> list;
        block8: {
            list = new ArrayList<String>();
            try {
                if (file.exists()) {
                    TestUtil.logTrace((String)("found file:" + file.getAbsolutePath()));
                    if (file.length() > 0L) {
                        try (BufferedReader input = new BufferedReader(new FileReader(file));){
                            String line = null;
                            while ((line = input.readLine()) != null) {
                                TestUtil.logTrace((String)("read line:" + line));
                                line = line.trim();
                                list.add(line);
                            }
                            break block8;
                        }
                    }
                    TestUtil.logErr((String)("File is empty: " + file.getAbsolutePath()));
                    break block8;
                }
                TestUtil.logErr((String)("Specified file " + file.getAbsolutePath() + " does not exist"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    public void deleteItem(File file) {
        if (file.exists()) {
            TestUtil.logTrace((String)("item:" + file.getAbsolutePath() + " exists"));
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        this.deleteItem(f);
                    }
                    if (file.delete()) {
                        TestUtil.logTrace((String)("directory: " + file.getAbsolutePath() + " deleted"));
                        if (file.exists()) {
                            TestUtil.logErr((String)"directory still exists even after calling delete");
                        }
                    } else {
                        TestUtil.logErr((String)("Could not delete directory: " + file.getAbsolutePath()));
                    }
                } else {
                    TestUtil.logErr((String)"listFiles returned null");
                }
            } else if (file.delete()) {
                TestUtil.logTrace((String)("file: " + file.getAbsolutePath() + " deleted"));
                if (file.exists()) {
                    TestUtil.logErr((String)"file still exists even after calling delete");
                }
            } else {
                TestUtil.logErr((String)("Could not delete file: " + file.getAbsolutePath()));
            }
        } else {
            TestUtil.logTrace((String)("file:" + file.getAbsolutePath() + " does not exist"));
        }
    }

    public String convertToURI(String path) {
        String sURI = null;
        try {
            sURI = new File(path).toURI().toASCIIString();
            TestUtil.logTrace((String)("URI=" + sURI));
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Received unexpected exception for path:" + path), (Throwable)ue);
        }
        return sURI;
    }
}

