/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Singleton;
import javax.interceptor.ExcludeDefaultInterceptors;

@Singleton
@ExcludeDefaultInterceptors
public class TimeoutStatusBean {
    private static final int maxNumOfRecords = 1000;
    private Map<String, ArrayList<String>> timeoutRecordsMap = new HashMap<String, ArrayList<String>>();
    private Map<String, Boolean> timeoutStatusMap = new HashMap<String, Boolean>();

    public Boolean getStatus(String testName) {
        return this.timeoutStatusMap.get(testName);
    }

    public void removeStatus(String testName) {
        this.timeoutStatusMap.remove(testName);
    }

    public void setStatus(String testName, boolean b) {
        this.timeoutStatusMap.put(testName, b);
        Helper.getLogger().fine("Set timeout status to " + b + ", for test " + testName);
    }

    public void addRecord(String testName, String record) {
        ArrayList<String> previousRecords = this.timeoutRecordsMap.get(testName);
        if (previousRecords == null) {
            previousRecords = new ArrayList();
            this.timeoutRecordsMap.put(testName, previousRecords);
        }
        if (previousRecords.size() < 1000) {
            previousRecords.add(record);
        }
        Helper.getLogger().fine("Added timeout record for test " + testName + ": " + record);
    }

    public List<String> getRecords(String testName) {
        ArrayList<String> rec = this.timeoutRecordsMap.get(testName);
        if (rec == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(rec);
    }

    public boolean containsRecords(String testName) {
        return this.timeoutRecordsMap.containsKey(testName);
    }

    public void clearRecords() {
        this.timeoutRecordsMap.clear();
    }

    public void removeRecords(String testName) {
        this.timeoutRecordsMap.remove(testName);
    }

    public int recordsSize() {
        return this.timeoutRecordsMap.size();
    }
}

