/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.common;

import com.sun.ts.lib.util.TestUtil;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class SessionThread
extends Thread {
    private QueueConnection qConnection = null;
    private QueueSession qSession = null;
    private TopicConnection tConnection = null;
    private TopicSession tSession = null;
    MessageConsumer consumer = null;
    MessageProducer producer = null;
    private boolean replyToMessages = false;
    private boolean stayAlive = false;
    private int messagesReceivedCount = 0;
    boolean stdebug = false;

    public SessionThread(QueueConnection qC, TopicConnection tC) throws JMSException {
        if (qC != null && tC != null) {
            throw new JMSException("Both QueueConnection and TopicConnection are assigned, this is an error, it must be one or the other");
        }
        if (qC == null && tC == null) {
            throw new JMSException("Both QueueConnection and TopicConnection are null, this is an error, it must be one or the other");
        }
        if (qC != null) {
            this.qConnection = qC;
            this.setQueueSession(false, 1);
        } else {
            this.tConnection = tC;
            this.setTopicSession(false, 1);
        }
    }

    public void setQueueSession(boolean transacted, int mode) throws JMSException {
        if (this.qConnection != null) {
            this.qSession = this.qConnection.createQueueSession(transacted, mode);
        }
    }

    public void setTopicSession(boolean transacted, int mode) throws JMSException {
        if (this.tConnection != null) {
            this.tSession = this.tConnection.createTopicSession(transacted, mode);
        }
    }

    public QueueSession getQueueSession() {
        return this.qSession;
    }

    public TopicSession getTopicSession() {
        return this.tSession;
    }

    public void startConnection() throws JMSException {
        if (this.qConnection != null) {
            if (this.stdebug) {
                TestUtil.logMsg((String)"*ST: starting QueueConnection");
            }
            this.qConnection.start();
        }
        if (this.tConnection != null) {
            if (this.stdebug) {
                TestUtil.logMsg((String)"*ST: starting TopicConnection");
            }
            this.tConnection.start();
        }
    }

    public void startQueueConnection() throws Exception {
        if (this.stdebug) {
            TestUtil.logMsg((String)"*ST: starting specified connection -- Queue");
        }
        this.qConnection.start();
    }

    public void startTopicConnection() throws Exception {
        if (this.stdebug) {
            TestUtil.logMsg((String)"*ST: starting specified connection -- Topic");
        }
        this.tConnection.start();
    }

    public void createProducer(Destination dest) throws Exception {
        if (this.qSession != null) {
            if (this.stdebug) {
                TestUtil.logMsg((String)"*ST: creating QueueSender");
            }
            this.producer = this.qSession.createSender((Queue)dest);
        } else if (this.tSession != null) {
            if (this.stdebug) {
                TestUtil.logMsg((String)"*ST: creating TopicPublisher");
            }
            this.producer = this.tSession.createPublisher((Topic)dest);
        } else {
            throw new Exception("Neither Queue or Topic were set");
        }
        TestUtil.logMsg((String)("producer=" + this.producer));
    }

    public void createConsumer(Destination dest) throws Exception {
        if (this.qSession != null) {
            if (this.stdebug) {
                TestUtil.logMsg((String)"*ST: creating QueueReceiver");
            }
            this.consumer = this.qSession.createReceiver((Queue)dest);
        } else if (this.tSession != null) {
            if (this.stdebug) {
                TestUtil.logMsg((String)"*ST: creating TopicSubscriber");
            }
            this.consumer = this.tSession.createSubscriber((Topic)dest);
        } else {
            throw new Exception("Neither Queue or Topic were configured");
        }
        TestUtil.logMsg((String)("consumer=" + this.consumer));
    }

    public void setReplyToMessages(boolean boo) {
        this.replyToMessages = boo;
        if (this.stdebug) {
            TestUtil.logMsg((String)("*ST: will reply to messages -- " + this.replyToMessages));
        }
    }

    public void setStayAlive(boolean boo) {
        this.stayAlive = boo;
        if (this.stdebug) {
            TestUtil.logMsg((String)("*ST: will keep receiving after 1st message -- " + this.stayAlive));
        }
    }

    public int getMessagesReceivedCount() {
        return this.messagesReceivedCount;
    }

    public void resetMessagesReceivedCount() {
        this.messagesReceivedCount = 0;
        if (this.stdebug) {
            TestUtil.logMsg((String)("*ST: message count is now " + this.messagesReceivedCount));
        }
    }

    private void receiveMessages() throws Exception {
        if (this.consumer == null) {
            throw new Exception("No message consumer ready");
        }
        if (this.replyToMessages) {
            do {
                TestUtil.logMsg((String)"*ST: waiting to receive (reply mode)");
                Message msg = this.consumer.receive();
                if (msg == null) {
                    throw new Exception("Cannot respond to null message!");
                }
                ++this.messagesReceivedCount;
                TestUtil.logMsg((String)"*ST: received message -- creating reply");
                Destination dest = msg.getJMSReplyTo();
                if (this.stdebug) {
                    TestUtil.logMsg((String)("*ST: replying to " + dest));
                }
                if (this.qSession != null) {
                    TestUtil.logMsg((String)"Replying to TemporaryQueue");
                    this.qSession.createSender((Queue)dest).send(this.qSession.createMessage());
                } else if (this.tSession != null) {
                    TestUtil.logMsg((String)"Replying to TemporaryTopic");
                    this.tSession.createPublisher((Topic)dest).publish(this.tSession.createMessage());
                } else {
                    throw new Exception("Neither Queue or Topic were configured");
                }
                if (!this.stdebug) continue;
                TestUtil.logMsg((String)("*ST: keep receiving -- " + this.stayAlive));
            } while (this.stayAlive);
        } else {
            do {
                TestUtil.logMsg((String)("*ST: waiting to receive. Will continue after receiving: " + this.stayAlive));
                Message msg = this.consumer.receive();
                if (msg == null) {
                    throw new Exception("Received null message");
                }
                ++this.messagesReceivedCount;
                if (this.stdebug) {
                    TestUtil.logMsg((String)("*ST: messages received: " + this.messagesReceivedCount));
                }
                TestUtil.logMsg((String)("*ST: received " + msg.toString()));
            } while (this.stayAlive);
        }
    }

    public void stopWaiting() throws JMSException {
        TestUtil.logMsg((String)"Attempting to stop MessageConsumer(s)");
        this.consumer.close();
    }

    @Override
    public void run() {
        TestUtil.logMsg((String)"*ST: thread running");
        try {
            this.receiveMessages();
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Session thread: could not receive message");
            TestUtil.logMsg((String)("Reason being: " + e.getMessage()));
        }
    }
}

