/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class PatchCreate {
    PatchCreate() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonPatch API factory methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonPatch API factory methods added in JSON-P 1.1.");
        this.testCreateDiff(result);
        this.testCreatePatch(result);
        this.testCreatePatchBuilder(result);
        return result;
    }

    private void testCreateDiff(TestResult result) {
        TestUtil.logMsg((String)" - Json#createDiff(JsonStructure,JsonStructure)");
        JsonObject src = SimpleValues.createSimpleObject();
        JsonObject trg = SimpleValues.createSimpleObjectWithStr();
        JsonPatch patch = Json.createDiff((JsonStructure)src, (JsonStructure)trg);
        JsonObject out = (JsonObject)patch.apply((JsonStructure)src);
        if (this.operationFailed((JsonValue)trg, (JsonValue)out)) {
            result.fail("createDiff(JsonStructure,JsonStructure)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)trg));
        }
    }

    private void testCreatePatch(TestResult result) {
        TestUtil.logMsg((String)" - Json#createPatch(JsonArray)");
        JsonObject src = SimpleValues.createSimpleObject();
        JsonObject trg = SimpleValues.createSimpleObjectWithStr();
        JsonArray patchArray = Json.createDiff((JsonStructure)src, (JsonStructure)trg).toJsonArray();
        JsonPatch patch = Json.createPatch((JsonArray)patchArray);
        JsonObject out = (JsonObject)patch.apply((JsonStructure)src);
        if (this.operationFailed((JsonValue)trg, (JsonValue)out)) {
            result.fail("createPatch(JsonArray)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)trg));
        }
    }

    private void testCreatePatchBuilder(TestResult result) {
        TestUtil.logMsg((String)" - Json#createPatchBuilder(JsonArray)");
        JsonObject src = SimpleValues.createSimpleObject();
        JsonObject trg = SimpleValues.createSimpleObjectWithStr();
        JsonArray patchArray = Json.createDiff((JsonStructure)src, (JsonStructure)trg).toJsonArray();
        JsonPatchBuilder patchBuilder = Json.createPatchBuilder((JsonArray)patchArray);
        JsonObject out = (JsonObject)patchBuilder.build().apply((JsonStructure)src);
        if (this.operationFailed((JsonValue)trg, (JsonValue)out)) {
            result.fail("createPatchBuilder(JsonArray)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)trg));
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

