/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.Concept;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;

public class JAXRClient
extends JAXRCommonClient {
    JAXR_Util util = null;
    ClassificationScheme scheme = null;
    String schemeName = "Geography";
    String schemeDescription = "North American Regions";
    String[] childConceptName = new String[]{"California", "Alaska", "Alabama", "Arkansas", "Arizona", "Colorado", "Florida"};
    String[] childConceptValue = new String[]{"US-CA", "US-AK", "US-AL", "US-AR", "US-AZ", "US-CO", "US-FL"};
    String conceptName = "North America";
    String conceptValue = "NA";
    String conceptNameCA = "California";
    String conceptValueCA = "US-CA";
    String conceptNameAK = "Alaska";
    String conceptValueAK = "US-AK";
    String conceptNameAL = "Alabama";
    String conceptValueAL = "US-AL";
    String conceptNameAR = "Arkansas";
    String conceptValueAR = "US-AR";
    String conceptNameAZ = "Arizona";
    String conceptValueAZ = "US-AZ";
    String conceptNameCO = "Colorado";
    String conceptValueCO = "US-CO";
    String conceptNameFL = "Florida";
    String conceptValueFL = "US-FL";
    String conceptNameUS = "United States";
    String conceptValueUS = "US";

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void concept_get_setValue_Test() throws EETest.Fault {
        String testName = "concept_get_setValue_Test";
        boolean pass = false;
        String code = "51";
        try {
            Concept concept = (Concept)this.blm.createObject("Concept");
            this.debug.add("Setting the string value to " + code + "\n");
            concept.setValue(code);
            if (concept.getValue().equals(code)) {
                pass = true;
                this.debug.add("Success! setValue was returned.");
            } else {
                this.debug.add("FAIL: getValue returned " + concept.getValue());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_addChildConceptTest() throws EETest.Fault {
        String testName = "concept_addChildConceptTest";
        boolean pass = false;
        Concept concept2 = null;
        try {
            this.debug.add("Create a concept and then a child concept\n");
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            Concept usConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameUS, this.conceptValueUS);
            Concept caConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameCA, this.conceptValueCA);
            this.debug.add("Add a child to the concept\n");
            usConcept.addChildConcept(caConcept);
            Collection concepts = usConcept.getChildrenConcepts();
            this.debug.add("Child count returned from getChildrenConcepts is " + concepts.size() + "\n");
            for (Concept concept2 : concepts) {
                this.debug.add("Concept value is " + concept2.getValue() + "\n");
                if (!concept2.getValue().equals(this.conceptValueCA)) continue;
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_addGetChildConceptsTest() throws EETest.Fault {
        String testName = "concept_addGetChildConceptsTest";
        boolean pass = false;
        Concept concept = null;
        int childCount = 2;
        try {
            this.debug.add("Create a concept and then a child concept\n");
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            Concept usConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameUS, this.conceptValueUS);
            Concept caConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameCA, this.conceptValueCA);
            Concept akConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameAK, this.conceptValueAK);
            Collection concepts = new ArrayList<Concept>();
            concepts.add(caConcept);
            concepts.add(akConcept);
            this.debug.add("Add children \n");
            usConcept.addChildConcepts(concepts);
            concepts = usConcept.getChildrenConcepts();
            this.debug.add("Child count returned from getChildrenConcepts is " + concepts.size() + "\n");
            Iterator iter = concepts.iterator();
            int count = 0;
            while (iter.hasNext()) {
                concept = (Concept)iter.next();
                this.debug.add("Concept value is " + concept.getValue() + "\n");
                if (!concept.getValue().equals(this.conceptValueCA) && !concept.getValue().equals(this.conceptValueAK)) continue;
                ++count;
            }
            if (count == childCount) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_getChildConceptCount() throws EETest.Fault {
        String testName = "concept_getChildConceptCount";
        boolean pass = false;
        try {
            Concept[] childConcept = new Concept[this.childConceptName.length];
            this.debug.add("Create a concept and then a child concept\n");
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            ArrayList<Concept> concepts = new ArrayList<Concept>();
            this.debug.add("Creating Parent Concept: " + this.conceptNameUS + "\n");
            Concept usConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameUS, this.conceptValueUS);
            for (int i = 0; i < this.childConceptName.length; ++i) {
                this.debug.add("Creating child Concept for : " + this.childConceptName[i] + "\n");
                childConcept[i] = this.blm.createConcept((RegistryObject)this.scheme, this.childConceptName[i], this.childConceptValue[i]);
                concepts.add(childConcept[i]);
            }
            this.debug.add("Add children to Parent \n");
            usConcept.addChildConcepts(concepts);
            this.debug.add("Child count returned from getChildrenConcepts is " + usConcept.getChildConceptCount() + "\n");
            if (this.childConceptName.length == usConcept.getChildConceptCount()) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_getClassificationScheme() throws EETest.Fault {
        String testName = "concept_getClassificationScheme";
        boolean pass = false;
        String name = "conceptDescendent";
        try {
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            this.scheme.setName(this.blm.createInternationalString(name));
            Concept usConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameUS, this.conceptValueUS);
            this.scheme = usConcept.getClassificationScheme();
            if (this.scheme.getName().getValue().equals(name)) {
                pass = true;
                this.debug.add("Success! returned: " + this.scheme.getName().getValue());
            } else {
                this.debug.add("FAIL: isExternal returned " + this.scheme.getName().getValue());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_getDescendantConcepts() throws EETest.Fault {
        String testName = "concept_getDescendantConcepts";
        int passCount = this.childConceptName.length;
        int count = 0;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            Concept naConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptName, this.conceptValue);
            Concept usConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameUS, this.conceptValueUS);
            naConcept.addChildConcept(usConcept);
            Concept[] grandChildConcept = new Concept[this.childConceptName.length];
            ArrayList<Concept> concepts = new ArrayList<Concept>();
            for (int i = 0; i < this.childConceptName.length; ++i) {
                this.debug.add("Creating grandChild Concept for : " + this.childConceptName[i] + "\n");
                grandChildConcept[i] = this.blm.createConcept((RegistryObject)this.scheme, this.childConceptName[i], this.childConceptValue[i]);
                concepts.add(grandChildConcept[i]);
            }
            usConcept.addChildConcepts(concepts);
            this.debug.add("Descendants of naConcept\n");
            Collection d1Concepts = naConcept.getDescendantConcepts();
            Iterator iter = d1Concepts.iterator();
            count = 0;
            while (iter.hasNext()) {
                Concept c = (Concept)iter.next();
                this.debug.add("Concept : " + c.getValue() + "\n");
                ++count;
            }
            if (count == this.childConceptValue.length + 1) {
                pass1 = true;
            } else {
                this.debug.add("Error: Did not find all descendents of North America\n");
            }
            this.debug.add("Descendants of usConcept\n");
            Collection d2Concepts = usConcept.getDescendantConcepts();
            iter = d2Concepts.iterator();
            count = 0;
            block4: while (iter.hasNext()) {
                Concept c = (Concept)iter.next();
                this.debug.add("Concept : " + c.getValue() + "\n");
                for (int i = 0; i < this.childConceptValue.length; ++i) {
                    if (!c.getValue().equals(this.childConceptValue[i])) continue;
                    ++count;
                    this.debug.add("Found a match " + this.childConceptValue[i] + "\n");
                    continue block4;
                }
            }
            if (count == passCount) {
                pass2 = true;
            } else {
                this.debug.add("Error: Did not find all descendents of the United States\n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass2 = false;
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_getParentConceptScheme() throws EETest.Fault {
        String testName = "concept_getParentConceptScheme";
        Object concept = null;
        boolean pass = false;
        try {
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            Concept naConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptName, this.conceptValue);
            if (naConcept.getParentConcept() == null) {
                pass = true;
            } else {
                this.debug.add("Error: expected null parent\n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_getParentConcept() throws EETest.Fault {
        String testName = "concept_getParentConcept";
        Concept concept = null;
        boolean pass = false;
        try {
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            Concept naConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptName, this.conceptValue);
            Concept usConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameUS, this.conceptValueUS);
            naConcept.addChildConcept(usConcept);
            concept = usConcept.getParentConcept();
            this.debug.add("Expect NA concept value\n");
            if (concept.getValue().equals(this.conceptValue)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_removeChildConcept() throws EETest.Fault {
        String testName = "concept_removeChildConcept";
        Object concept = null;
        boolean pass = false;
        try {
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            Concept naConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptName, this.conceptValue);
            Concept usConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameUS, this.conceptValueUS);
            naConcept.addChildConcept(usConcept);
            if (naConcept.getChildConceptCount() != 1) {
                throw new EETest.Fault(testName + " did not complete.  Child count not valid\n");
            }
            naConcept.removeChildConcept(usConcept);
            if (naConcept.getChildConceptCount() != 0) {
                this.debug.add("Error: test failed to remove child concept\n");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_preDefinedEnumerationsObjectTypeTest() throws EETest.Fault {
        String testName = "concept_preDefinedEnumerationsObjectTypeTest";
        boolean pass = true;
        Concept concept = null;
        String[] ObjectTypes = new String[]{"CPP", "CPA", "Process", "WSDL", "Association", "AuditableEvent", "Classification", "Concept", "ExternalIdentifier", "ExternalLink", "ExtrinsicObject", "Organization", "Package", "Service", "ServiceBinding", "User"};
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            this.scheme = bqm.findClassificationSchemeByName(null, "ObjectType");
            this.debug.add("Child concept count is " + this.scheme.getChildConceptCount() + "\n");
            Collection concepts = this.scheme.getChildrenConcepts();
            Iterator iter = concepts.iterator();
            this.debug.add("\n");
            this.debug.add("---------------------------------------------    \n");
            ArrayList<String> values = new ArrayList<String>();
            while (iter.hasNext()) {
                concept = (Concept)iter.next();
                this.debug.add("Concept value is " + concept.getValue() + "\n");
                values.add(concept.getValue());
            }
            this.debug.add("---------------------------------------------    \n");
            int findcount = 0;
            for (int i = 0; i < ObjectTypes.length; ++i) {
                if (!values.contains(ObjectTypes[i])) {
                    this.debug.add("Error: did not find this --> " + ObjectTypes[i] + "\n");
                    pass = false;
                    continue;
                }
                this.debug.add("Found " + ObjectTypes[i] + "\n");
                ++findcount;
            }
            this.debug.add("Find count is " + findcount + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_preDefinedEnumerationsPhoneTypeTest() throws EETest.Fault {
        String testName = "concept_preDefinedEnumerationsPhoneTypeTest";
        boolean pass = true;
        Concept concept = null;
        String[] PhoneTypes = new String[]{"OfficePhone", "HomePhone", "MobilePhone", "Beeper", "FAX"};
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            this.scheme = bqm.findClassificationSchemeByName(null, "PhoneType");
            this.debug.add("Child concept count is " + this.scheme.getChildConceptCount() + "\n");
            Collection concepts = this.scheme.getChildrenConcepts();
            Iterator iter = concepts.iterator();
            this.debug.add("\n");
            this.debug.add("---------------------------------------------    \n");
            ArrayList<String> values = new ArrayList<String>();
            while (iter.hasNext()) {
                concept = (Concept)iter.next();
                this.debug.add("Concept value is " + concept.getValue() + "\n");
                values.add(concept.getValue());
            }
            this.debug.add("---------------------------------------------    \n");
            int findcount = 0;
            for (int i = 0; i < PhoneTypes.length; ++i) {
                if (!values.contains(PhoneTypes[i])) {
                    this.debug.add("Error: did not find this --> " + PhoneTypes[i] + "\n");
                    pass = false;
                    continue;
                }
                ++findcount;
            }
            this.debug.add("Find count is " + findcount + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_preDefinedEnumerationsAssociationTypeTest() throws EETest.Fault {
        String testName = "concept_preDefinedEnumerationsAssociationTypeTest";
        boolean pass = true;
        Concept concept = null;
        String[] AssociationTypes = new String[]{"RelatedTo", "HasChild", "HasMember", "HasParent", "ExternallyLinks", "Contains", "EquivalentTo", "Extends", "Implements", "InstanceOf", "Supersedes", "Uses", "Replaces", "ResponsibleFor", "SubmitterOf"};
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            this.scheme = bqm.findClassificationSchemeByName(null, "AssociationType");
            this.debug.add("Child concept count is " + this.scheme.getChildConceptCount() + "\n");
            Collection concepts = this.scheme.getChildrenConcepts();
            Iterator iter = concepts.iterator();
            this.debug.add("\n");
            this.debug.add("---------------------------------------------    \n");
            ArrayList<String> values = new ArrayList<String>();
            while (iter.hasNext()) {
                concept = (Concept)iter.next();
                this.debug.add("Concept value is " + concept.getValue() + "\n");
                values.add(concept.getValue());
            }
            this.debug.add("---------------------------------------------    \n");
            int findcount = 0;
            for (int i = 0; i < AssociationTypes.length; ++i) {
                if (!values.contains(AssociationTypes[i])) {
                    this.debug.add("Error: did not find this --> " + AssociationTypes[i] + "\n");
                    pass = false;
                    continue;
                }
                ++findcount;
            }
            this.debug.add("Find count is " + findcount + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_preDefinedEnumerationsURLTypeTest() throws EETest.Fault {
        String testName = "concept_preDefinedEnumerationsURLTypeTest";
        boolean pass = true;
        Concept concept = null;
        String[] URLTypes = new String[]{"HTTP", "HTTPS", "SMTP", "PHONE", "FAX", "OTHER"};
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            this.scheme = bqm.findClassificationSchemeByName(null, "URLType");
            this.debug.add("Child concept count is " + this.scheme.getChildConceptCount() + "\n");
            Collection concepts = this.scheme.getChildrenConcepts();
            Iterator iter = concepts.iterator();
            this.debug.add("\n");
            this.debug.add("---------------------------------------------    \n");
            ArrayList<String> values = new ArrayList<String>();
            while (iter.hasNext()) {
                concept = (Concept)iter.next();
                this.debug.add("Concept value is " + concept.getValue() + "\n");
                values.add(concept.getValue());
            }
            this.debug.add("---------------------------------------------    \n");
            int findcount = 0;
            for (int i = 0; i < URLTypes.length; ++i) {
                if (!values.contains(URLTypes[i])) {
                    this.debug.add("Error: did not find this --> " + URLTypes[i] + "\n");
                    pass = false;
                    continue;
                }
                ++findcount;
            }
            this.debug.add("Find count is " + findcount + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_preDefinedEnumerationsPostalAddressAttributesTest() throws EETest.Fault {
        String testName = "concept_preDefinedEnumerationsPostalAddressAttributesTest";
        boolean pass = true;
        Concept concept = null;
        String[] PostalAddressAttributes = new String[]{"StreetNumber", "Street", "City", "State", "PostalCode", "Country"};
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            this.scheme = bqm.findClassificationSchemeByName(null, "PostalAddressAttributes");
            this.debug.add("Child concept count is " + this.scheme.getChildConceptCount() + "\n");
            Collection concepts = this.scheme.getChildrenConcepts();
            Iterator iter = concepts.iterator();
            this.debug.add("\n");
            this.debug.add("---------------------------------------------    \n");
            ArrayList<String> values = new ArrayList<String>();
            while (iter.hasNext()) {
                concept = (Concept)iter.next();
                this.debug.add("Concept value is " + concept.getValue() + "\n");
                values.add(concept.getValue());
            }
            this.debug.add("---------------------------------------------    \n");
            int findcount = 0;
            for (int i = 0; i < PostalAddressAttributes.length; ++i) {
                if (!values.contains(PostalAddressAttributes[i])) {
                    this.debug.add("Error: did not find this --> " + PostalAddressAttributes[i] + "\n");
                    pass = false;
                    continue;
                }
                ++findcount;
            }
            this.debug.add("Find count is " + findcount + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void concept_removeChildConcepts() throws EETest.Fault {
        String testName = "concept_removeChildConcepts";
        boolean pass = false;
        try {
            Concept[] childConcept = new Concept[this.childConceptName.length];
            this.scheme = this.blm.createClassificationScheme(this.schemeName, this.schemeDescription);
            ArrayList<Concept> concepts = new ArrayList<Concept>();
            this.debug.add("Creating Parent Concept: " + this.conceptNameUS + "\n");
            Concept usConcept = this.blm.createConcept((RegistryObject)this.scheme, this.conceptNameUS, this.conceptValueUS);
            for (int i = 0; i < this.childConceptName.length; ++i) {
                this.debug.add("Creating child Concept for : " + this.childConceptName[i] + "\n");
                childConcept[i] = this.blm.createConcept((RegistryObject)this.scheme, this.childConceptName[i], this.childConceptValue[i]);
                concepts.add(childConcept[i]);
            }
            this.debug.add("Add children to Parent \n");
            usConcept.addChildConcepts(concepts);
            this.debug.add("Child count returned from getChildrenConcepts is " + usConcept.getChildConceptCount() + "\n");
            if (this.childConceptName.length != usConcept.getChildConceptCount()) {
                throw new EETest.Fault(testName + "did not complete. Invalid child count\n");
            }
            this.debug.add("Removing all of the children\n");
            usConcept.removeChildConcepts(concepts);
            if (usConcept.getChildConceptCount() != 0) {
                this.debug.add("Error: child count is: " + usConcept.getChildConceptCount() + "\n");
                throw new EETest.Fault(testName + "failure to remove all children");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
    }
}

