/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.BusinessLifeCycleManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.AuditableEvent;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class JAXRClient
extends JAXRCommonClient {
    String[] className = new String[]{"Association", "AuditableEvent", "Classification", "ClassificationScheme", "Concept", "EmailAddress", "ExternalIdentifier", "ExternalLink", "ExtrinsicObject", "InternationalString", "Key", "LocalizedString", "Organization", "PersonName", "PostalAddress", "RegistryPackage", "Service", "ServiceBinding", "Slot", "SpecificationLink", "TelephoneNumber", "User"};
    int[] classLevel = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0};
    JAXR_Util util = null;
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
                this.debug.clear();
            }
            super.cleanUpRegistry();
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    boolean verifyObject(Object o, int index) {
        boolean pass = true;
        switch (++index) {
            case 1: {
                if (o instanceof Association) break;
                pass = false;
                break;
            }
            case 2: {
                if (o instanceof AuditableEvent) break;
                pass = false;
                break;
            }
            case 3: {
                if (o instanceof Classification) break;
                pass = false;
                break;
            }
            case 4: {
                if (o instanceof ClassificationScheme) break;
                pass = false;
                break;
            }
            case 5: {
                if (o instanceof Concept) break;
                pass = false;
                break;
            }
            case 6: {
                if (o instanceof EmailAddress) break;
                pass = false;
                break;
            }
            case 7: {
                if (o instanceof ExternalIdentifier) break;
                pass = false;
                break;
            }
            case 8: {
                if (o instanceof ExternalLink) break;
                pass = false;
                break;
            }
            case 9: {
                if (o instanceof ExtrinsicObject) break;
                pass = false;
                break;
            }
            case 10: {
                if (o instanceof InternationalString) break;
                pass = false;
                break;
            }
            case 11: {
                if (o instanceof Key) break;
                pass = false;
                break;
            }
            case 12: {
                if (o instanceof LocalizedString) break;
                pass = false;
                break;
            }
            case 13: {
                if (o instanceof Organization) break;
                pass = false;
                break;
            }
            case 14: {
                if (o instanceof PersonName) break;
                pass = false;
                break;
            }
            case 15: {
                if (o instanceof PostalAddress) break;
                pass = false;
                break;
            }
            case 16: {
                if (o instanceof RegistryPackage) break;
                pass = false;
                break;
            }
            case 17: {
                if (o instanceof Service) break;
                pass = false;
                break;
            }
            case 18: {
                if (o instanceof ServiceBinding) break;
                pass = false;
                break;
            }
            case 19: {
                if (o instanceof Slot) break;
                pass = false;
                break;
            }
            case 20: {
                if (o instanceof SpecificationLink) break;
                pass = false;
                break;
            }
            case 21: {
                if (o instanceof TelephoneNumber) break;
                pass = false;
                break;
            }
            case 22: {
                if (o instanceof User) break;
                pass = false;
                break;
            }
            default: {
                TestUtil.logMsg((String)"Error: createObjectTest did not find infomodel object\n");
                pass = false;
            }
        }
        return pass;
    }

    public void BusinessLifeCycleManagerInvalid_createObjectTest() throws EETest.Fault {
        String testName = "BusinessLifeCycleManagerInvalid_createObjectTest";
        boolean pass = true;
        try {
            RegistryService rs = this.conn.getRegistryService();
            if (!(rs instanceof RegistryService)) {
                pass = false;
                throw new EETest.Fault(testName + "Error failed to get a RegistryService object");
            }
            BusinessLifeCycleManager blcm = rs.getBusinessLifeCycleManager();
            if (!(blcm instanceof BusinessLifeCycleManager)) {
                pass = false;
                throw new EETest.Fault(testName + "Error failed to get a BusinessLifeCycleManager object");
            }
            Object o = blcm.createObject("String");
            pass = false;
            TestUtil.logTrace((String)"Error: InvalidRequestException was not thrown!");
        }
        catch (InvalidRequestException ir) {
            TestUtil.printStackTrace((Throwable)ir);
            TestUtil.logTrace((String)("Caught InvalidRequestException exception: " + ir.getMessage() + " as expected"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.logTrace((String)"Was expecting an InvalidRequestException: ");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void BusinessLifeCycleManagerInvalid2_createObjectTest() throws EETest.Fault {
        String testName = "BusinessLifeCycleManagerInvalid2_createObjectTest";
        boolean pass = true;
        ArrayList<String> debug = null;
        int failcount = 0;
        try {
            RegistryService rs = this.conn.getRegistryService();
            debug = new ArrayList<String>();
            if (!(rs instanceof RegistryService)) {
                throw new EETest.Fault(testName + "Error failed to get a RegistryService object");
            }
            int providerlevel = rs.getCapabilityProfile().getCapabilityLevel();
            debug.add("     The capability level for this JAXR provider is: " + providerlevel + "\n");
            BusinessLifeCycleManager blcm = rs.getBusinessLifeCycleManager();
            if (!(blcm instanceof BusinessLifeCycleManager)) {
                throw new EETest.Fault(testName + "Error failed to get a BusinessLifeCycleManager object");
            }
            Object o = null;
            for (int i = 0; i < this.className.length; ++i) {
                if (this.classLevel[i] <= providerlevel) continue;
                debug.add("\n=== Attempt to create: " + this.className[i] + "\n");
                debug.add(this.className[i] + " exceeds provider capability level\n");
                try {
                    o = blcm.createObject(this.className[i]);
                    debug.add("Error: create did not throw an error as expected!\n");
                    pass = false;
                    ++failcount;
                    continue;
                }
                catch (UnsupportedCapabilityException uce) {
                    TestUtil.printStackTrace((Throwable)uce);
                    debug.add("Pass: UnsupportedCapabilityException was thrown!!\n");
                }
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        finally {
            debug.add("Total Failures for this test:  " + failcount + "\n");
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void BusinessLifeCycleManager_createObjectTest() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_createObjectTest";
        boolean pass = true;
        ArrayList<String> debug = null;
        int failcount = 0;
        try {
            RegistryService rs = this.conn.getRegistryService();
            debug = new ArrayList<String>();
            if (!(rs instanceof RegistryService)) {
                throw new EETest.Fault(testName + "Error failed to get a RegistryService object");
            }
            int providerlevel = rs.getCapabilityProfile().getCapabilityLevel();
            debug.add("     The capability level for this JAXR provider is: " + providerlevel + "\n");
            BusinessLifeCycleManager blcm = rs.getBusinessLifeCycleManager();
            if (!(blcm instanceof BusinessLifeCycleManager)) {
                throw new EETest.Fault(testName + "Error failed to get a BusinessLifeCycleManager object");
            }
            Object o = null;
            for (int i = 0; i < this.className.length; ++i) {
                if (this.classLevel[i] > providerlevel) {
                    debug.add("\n============================\n");
                    debug.add(this.className[i] + " exceeds provider capability level\n");
                    continue;
                }
                try {
                    debug.add("\n=== Creating: " + this.className[i] + "\n");
                    o = blcm.createObject(this.className[i]);
                    debug.add("providerlevel is: " + providerlevel + " |  classLevel is: " + this.classLevel[i] + "\n");
                }
                catch (Exception ue) {
                    debug.add("Error: caught an unexpected exception\n");
                    debug.add(ue.getMessage() + "\n");
                    TestUtil.printStackTrace((Throwable)ue);
                    ++failcount;
                    debug.add("Fail!: \n");
                    continue;
                }
                if (o != null) {
                    debug.add("=============>  createObject returned: " + o.getClass().getName() + "\n");
                }
                debug.add(" o.toString() is:  " + o.toString() + "\n");
                pass = this.verifyObject(o, i);
                if (pass) {
                    debug.add("Pass: \n");
                    continue;
                }
                ++failcount;
                debug.add("Fail!: \n");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        finally {
            debug.add("Total Failures for this test:  " + failcount + "\n");
        }
        if (failcount > 1) {
            if (debug != null) {
                TestUtil.logTrace((String)((Object)debug).toString());
                debug.clear();
            }
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void BusinessLifeCycleManager_SaveConceptsTest1() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_SaveConceptsTest1";
        this.debug.add("JAXRClient.BusinessLifeCycleManager_SaveConceptsTest1\n");
        boolean pass = false;
        BusinessQueryManager bqm = null;
        Object org = null;
        Concept concept = null;
        Collection concepts = null;
        Object orgs = null;
        String name = "TS TEST Name:Test BusinessLifeCycleManager_SaveConceptsTest1";
        String descr = "Description: Test BusinessLifeCycleManager_SaveConceptsTest1";
        BulkResponse br = null;
        Object savedOrgKey = null;
        try {
            bqm = this.rs.getBusinessQueryManager();
            concept = (Concept)this.blm.createObject("Concept");
            concepts = new ArrayList<Concept>();
            concept.setName(this.blm.createInternationalString(this.tsLocale, name));
            concept.setDescription(this.blm.createInternationalString(this.tsLocale, descr));
            concepts.add(concept);
            this.debug.add("Save concepts to registry\n");
            br = this.blm.saveConcepts(concepts);
            if (!JAXR_Util.checkBulkResponse("saveConcepts", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveServices - test did not complete!");
            }
            this.debug.add("Validate the concepts was actually published to the registry\n");
            ArrayList<String> names = new ArrayList<String>();
            names.add(name);
            br = bqm.findConcepts(null, names, null, null, null);
            if (!JAXR_Util.checkBulkResponse("findConcepts", br, this.debug)) {
                this.debug.add("Error reported:  findConcepts failed \n");
                throw new EETest.Fault(testName + " Error from getRegistryObjects- test did not complete!");
            }
            concepts = br.getCollection();
            this.debug.add("Number of concepts found is: " + concepts.size() + "\n");
            if (concepts.size() == 0) {
                this.debug.add("Error: no concepts found in the registry\n");
                throw new EETest.Fault(testName + " due to error test did not complete");
            }
            ArrayList<Key> myKeys = new ArrayList<Key>();
            Iterator iter = concepts.iterator();
            concept = null;
            ArrayList orgKeys = new ArrayList();
            Key key = null;
            while (iter.hasNext()) {
                concept = (Concept)iter.next();
                if (concept.getName().getValue(this.tsLocale).equals(name)) {
                    this.debug.add("Got back expected Concept Name!\n");
                    pass = true;
                } else {
                    this.debug.add("Error: returned name not as expected! \n");
                    this.debug.add("Expected name: " + name + "\n");
                    this.debug.add("Returned name: " + concept.getName().getValue(this.tsLocale) + "\n");
                }
                key = concept.getKey();
                myKeys.add(key);
                JAXR_Util.deleteConcept(myKeys, this.blm, this.debug);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BusinessLifeCycleManager_SaveConceptsTest2() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_SaveConceptsTest2";
        boolean pass = true;
        BusinessQueryManager bqm = null;
        Object org = null;
        Concept concept = null;
        ArrayList<Concept> concepts = null;
        Collection keys = null;
        Object names = null;
        Object key = null;
        Key conceptKey2 = null;
        Key conceptKey12 = null;
        String name = "TS TEST Name:Test BusinessLifeCycleManager_SaveConceptsTest2";
        String descr = "Description: Test BusinessLifeCycleManager_SaveConceptsTest2";
        String replacementDescr = "Description: Test Replaced BusinessLifeCycleManager_SaveConceptsTest2";
        BulkResponse br = null;
        try {
            bqm = this.rs.getBusinessQueryManager();
            concept = (Concept)this.blm.createObject("Concept");
            concepts = new ArrayList<Concept>();
            concept.setName(this.blm.createInternationalString(this.tsLocale, name));
            concept.setDescription(this.blm.createInternationalString(descr));
            concepts.add(concept);
            br = this.blm.saveConcepts(concepts);
            if (!JAXR_Util.checkBulkResponse("saveConcepts", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveConcepts - test did not complete!");
            }
            keys = br.getCollection();
            if (keys.size() == 0) {
                throw new EETest.Fault(testName + "Error: no key was returned from saveConcept\n");
            }
            if (keys.size() > 1) {
                throw new EETest.Fault(testName + "Error: too many keys were returned from saveConcept\n");
            }
            for (Key conceptKey2 : keys) {
            }
            String keyId = conceptKey2.getId();
            this.debug.add("Get it back from the registry - its keyid is: " + keyId + "\n");
            concept = (Concept)bqm.getRegistryObject(keyId, "Concept");
            if (concept.getName().getValue(this.tsLocale).equals(name)) {
                this.debug.add("Got back expected Concept Name!\n");
            } else {
                pass = false;
                this.debug.add("Error: returned name not as expected! \n");
                this.debug.add("Expected name: " + name + "\n");
                this.debug.add("Returned name: " + concept.getName().getValue(this.tsLocale) + "\n");
            }
            if (concept.getDescription().getValue().equals(descr)) {
                this.debug.add("Got back expected Concept Description! \n");
            } else {
                pass = false;
                this.debug.add("Error: returned description not as expected! \n");
                this.debug.add("Expected description: " + descr + "\n");
                this.debug.add("Returned description: " + concept.getDescription().getValue() + "\n");
            }
            concepts.clear();
            concept.setDescription(this.blm.createInternationalString(replacementDescr));
            concepts.add(concept);
            br = this.blm.saveConcepts(concepts);
            if (!JAXR_Util.checkBulkResponse("saveConcepts", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveServices - test did not complete!");
            }
            keys = br.getCollection();
            if (keys.size() == 0) {
                throw new EETest.Fault(testName + "Error: no key was returned from saveConcept\n");
            }
            if (keys.size() > 1) {
                throw new EETest.Fault(testName + "Error: too many keys were returned from saveConcept\n");
            }
            for (Key conceptKey12 : keys) {
            }
            keyId = conceptKey12.getId();
            this.debug.add("Get it back from the registry - its keyid is: " + keyId + "\n");
            concept = (Concept)bqm.getRegistryObject(keyId, "Concept");
            if (concept.getName().getValue(this.tsLocale).equals(name)) {
                this.debug.add("Got back expected Concept Name!\n");
            } else {
                pass = false;
                this.debug.add("Error: returned name not as expected! \n");
                this.debug.add("Expected name: " + name + "\n");
                this.debug.add("Returned name: " + concept.getName().getValue(this.tsLocale) + "\n");
            }
            if (concept.getDescription().getValue().equals(replacementDescr)) {
                this.debug.add("Got back expected Concept Description! \n");
            } else {
                pass = false;
                this.debug.add("Error: returned description not as expected! \n");
                this.debug.add("Expected description: " + replacementDescr + "\n");
                this.debug.add("Returned description: " + concept.getDescription().getValue() + "\n");
            }
            keys.clear();
            keys.add(conceptKey2);
            keys.add(conceptKey12);
            br = this.blm.deleteConcepts(keys);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.debug.add("In finally loop ===== Test is OVER!!!!! \n");
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void BusinessLifeCycleManager_DeleteConcepts() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_DeleteConcepts";
        BusinessQueryManager bqm = null;
        Concept concept = null;
        Collection concepts = null;
        String name = "TS TEST Name:DeleteConcepts";
        String descr = "Description: Test DeleteConcepts";
        BulkResponse br = null;
        Key conceptKey2 = null;
        try {
            bqm = this.rs.getBusinessQueryManager();
            concept = (Concept)this.blm.createObject("Concept");
            concepts = new ArrayList<Concept>();
            concept.setName(this.blm.createInternationalString(this.tsLocale, name));
            concept.setDescription(this.blm.createInternationalString(this.tsLocale, descr));
            concepts.add(concept);
            br = this.blm.saveConcepts(concepts);
            if (!JAXR_Util.checkBulkResponse("saveConcepts", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveServices - test did not complete!");
            }
            Collection conceptKeys = br.getCollection();
            if (conceptKeys.size() != 1) {
                throw new EETest.Fault(testName + "Error: did not get back 1 concept key!\n");
            }
            for (Key conceptKey2 : conceptKeys) {
            }
            String keyId = conceptKey2.getId();
            concept = (Concept)bqm.getRegistryObject(keyId, "Concept");
            if (!concept.getName().getValue(this.tsLocale).equals(name)) {
                throw new EETest.Fault(testName + " Error verifying concept saved - test did not complete!");
            }
            this.debug.add("Got back expected Concept Name!\n");
            if (!concept.getDescription().getValue().equals(descr)) {
                throw new EETest.Fault(testName + " Error verifying concept saved - test did not complete!");
            }
            this.debug.add("Got back expected Concept Description! \n");
            br = this.blm.deleteConcepts(conceptKeys);
            if (!JAXR_Util.checkBulkResponse("deleteConcepts", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from deleteConcepts - test did not complete!");
            }
            ArrayList<String> names = new ArrayList<String>();
            names.add(name);
            br = bqm.findConcepts(null, names, null, null, null);
            if (!JAXR_Util.checkBulkResponse("findConcepts", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from findConcepts - test did not complete!");
            }
            concepts = br.getCollection();
            Concept c2 = null;
            for (Concept c2 : concepts) {
                if (c2.getKey().getId().equals(keyId)) {
                    this.debug.add("Error: Deleted Concept was found ( should have been hidden) \n");
                    throw new EETest.Fault(testName + " failed ");
                }
                this.debug.add("Did not find matching concept - as expected\n");
            }
            if (concepts.size() > 0) {
                this.debug.add("Warning: unexpectedly found some concepts - though not the deleted one \n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void BusinessLifeCycleManager_DeleteServicesTest() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_DeleteServicesTest";
        Object keys = null;
        Object key = null;
        int numOrgs = 3;
        Collection orgs = null;
        BulkResponse br = null;
        Iterator iter = null;
        BusinessQueryManager bqm = null;
        ArrayList<Service> services = null;
        Collection orgKeys = null;
        String myServiceName = "Name:Test Service";
        try {
            Organization org = JAXR_Util.createDefaultOrganization(this.blm);
            bqm = this.rs.getBusinessQueryManager();
            orgs = new ArrayList<Organization>();
            orgs.add(org);
            this.debug.add("Publish the default organization to the registry  - " + org.getName().getValue() + "\n");
            br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveOrganizations - test did not complete!");
            }
            orgKeys = br.getCollection();
            this.debug.add("Expect 1 key returned from saveOrganizations br - got: " + orgKeys.size() + "\n");
            br = bqm.getRegistryObjects(orgKeys, "Organization");
            if (!JAXR_Util.checkBulkResponse("getRegistryObjects", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from getRegistryObjects - test did not complete!");
            }
            this.debug.add("Get the organizations owned by this user \n");
            orgs.clear();
            orgs = br.getCollection();
            this.debug.add("Call to getRegistryObjects(orgKeys, LifeCycleManager.ORGANIZATION) returned count of " + orgs.size() + "\n");
            services = new ArrayList<Service>();
            Service theService = (Service)this.blm.createObject("Service");
            theService.setName(this.blm.createInternationalString(this.tsLocale, myServiceName));
            theService.setDescription(this.blm.createInternationalString("Description: Testservice"));
            this.debug.add("Created the service object = " + theService.getName().getValue(this.tsLocale) + "\n");
            iter = orgs.iterator();
            Organization org2 = null;
            Key orgkey = null;
            while (iter.hasNext()) {
                org2 = (Organization)iter.next();
                orgkey = org2.getKey();
                this.debug.add("got an org from the reg: " + org2.getName().getValue(this.tsLocale) + "\n");
                org2.addService(theService);
                services.add(theService);
            }
            this.debug.add("saving services = " + services.size() + "\n");
            br = this.blm.saveServices(services);
            if (!JAXR_Util.checkBulkResponse("saveServices", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveServices - test did not complete!");
            }
            this.debug.add("Verify that the service was saved \n");
            Collection serviceKeys = br.getCollection();
            this.debug.add("SaveServices returned count of " + serviceKeys.size() + "keys \n");
            Key servicekey2 = null;
            for (Key servicekey2 : serviceKeys) {
            }
            String serviceKeyId = servicekey2.getId();
            this.debug.add("Get it back from the registry - its keyid is: " + serviceKeyId + "\n");
            this.debug.add("request this object from the registry - getRegistryObject(serviceKeyId, LifeCycleManager.SERVICE) \n");
            Service myServ = (Service)bqm.getRegistryObject(serviceKeyId, "Service");
            if (myServ == null) {
                throw new EETest.Fault(testName + " Error: getRegistryObjects returned a null service \n");
            }
            this.debug.add("Service returned from getRegistryObjects is " + myServ.getName().getValue(this.tsLocale) + "\n");
            if (!myServ.getName().getValue(this.tsLocale).equals(myServiceName)) {
                throw new EETest.Fault(testName + " Error: Name of service returned did not match!! \n");
            }
            this.debug.add("Verified service was saved to registry - now will delete it. \n");
            this.debug.add("Verify serviceKeys has 1 key:  " + serviceKeys.size() + "\n");
            br = this.blm.deleteServices(serviceKeys);
            if (!JAXR_Util.checkBulkResponse("deleteServices", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from deleteServices - test did not complete!");
            }
            Collection retKeys = br.getCollection();
            this.debug.add("Deleted the service.  Check count of keys returned, should be 1: " + retKeys.size() + "\n");
            if (retKeys.size() == 0) {
                throw new EETest.Fault(testName + " Error from deleteServices - should have returned deleted key!");
            }
            br = this.blm.deleteOrganizations(orgKeys);
            if (br.getExceptions() != null) {
                TestUtil.logErr((String)"Warning:  error returned on organization cleanup ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BusinessLifeCycleManager_SaveServicesTest() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_SaveServicesTest";
        boolean pass = false;
        Object keys = null;
        Object key = null;
        Key savedOrgKey2 = null;
        int numOrgs = 3;
        ArrayList<Organization> orgs = null;
        BulkResponse br = null;
        Iterator iter = null;
        BusinessQueryManager bqm = null;
        ArrayList<Service> services = null;
        String serviceName = "Name:Test Service";
        Collection orgKeys = null;
        try {
            Organization org = JAXR_Util.createDefaultOrganization(this.blm);
            bqm = this.rs.getBusinessQueryManager();
            orgs = new ArrayList<Organization>();
            orgs.add(org);
            this.debug.add("Saving this organization: " + org.getName().getValue(this.tsLocale) + "\n");
            br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveServices", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveOrganizations - test did not complete!");
            }
            if (br.getExceptions() != null) {
                this.debug.add("Error from saveOrganizations \n");
            }
            orgKeys = br.getCollection();
            this.debug.add("OrgKey count returned from saveOrganization(should be 1) is : " + orgKeys.size() + "\n");
            for (Key savedOrgKey2 : orgKeys) {
            }
            br = bqm.getRegistryObjects(orgKeys, "Organization");
            if (br.getExceptions() != null) {
                this.debug.add("Error from saveOrganizations \n");
            }
            Collection myOrgs = br.getCollection();
            services = new ArrayList<Service>();
            Service theService = (Service)this.blm.createObject("Service");
            iter = myOrgs.iterator();
            Organization myOrg = null;
            theService.setName(this.blm.createInternationalString(this.tsLocale, serviceName));
            theService.setDescription(this.blm.createInternationalString("Description: Testservice"));
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
                myOrg.addService(theService);
                services.add(theService);
            }
            br = this.blm.saveServices(services);
            if (!JAXR_Util.checkBulkResponse("saveServices", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveServices - test did not complete!");
            }
            ArrayList<Organization> updatedOrgs = new ArrayList<Organization>();
            updatedOrgs.add(myOrg);
            br = this.blm.saveOrganizations(updatedOrgs);
            if (!JAXR_Util.checkBulkResponse("saveServices", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveOrganizations - test did not complete!");
            }
            if (br.getExceptions() != null) {
                this.debug.add("Error from saveOrganizations \n");
            }
            ArrayList<String> names = new ArrayList<String>();
            names.add(serviceName);
            br = bqm.findServices(savedOrgKey2, null, names, null, null);
            if (!JAXR_Util.checkBulkResponse("findServices", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from findServices - test did not complete!");
            }
            Service s2 = null;
            Collection ss = br.getCollection();
            this.debug.add("Count returned from findServices should be one \n");
            this.debug.add("Count returned : " + ss.size() + "\n");
            for (Service s2 : ss) {
                this.debug.add("And the service returned is: " + s2.getName().getValue(this.tsLocale) + "\n");
            }
            if (s2.getName().getValue(this.tsLocale).equals(serviceName)) {
                pass = true;
                this.debug.add(testName + "Added Service successfully!!!\n");
            } else {
                this.debug.add(testName + "Failed to add Service successfully!!\n");
            }
            super.cleanUpRegistry(orgKeys, "Organization");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            super.cleanUpRegistry(orgKeys, "Organization");
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void BusinessLifeCycleManager_DeleteOrganizationsTest() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_DeleteOrganizationsTest";
        boolean pass = true;
        String name = "TS TEST Name: DeleteOrganizationsTest";
        String descr = "Description: Test for DeleteOrganizationsTest";
        ArrayList<Organization> orgs = null;
        Collection myKeys = null;
        try {
            orgs = new ArrayList<Organization>();
            Organization org = JAXR_Util.createDefaultOrganization(this.blm);
            org.setName(this.blm.createInternationalString(name));
            org.setDescription(this.blm.createInternationalString(descr));
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveOrganizations - test did not complete!");
            }
            myKeys = br.getCollection();
            this.debug.add("Find the Organizations by Name \n");
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Iterator iter = null;
            Organization o = null;
            ArrayList<Key> orgKeys = new ArrayList<Key>();
            ArrayList<String> names = new ArrayList<String>();
            Collection myOrgs = null;
            Key key = null;
            names.add(name);
            br = bqm.getRegistryObjects(myKeys, "Organization");
            if (!JAXR_Util.checkBulkResponse("findOrganizations", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from findOrganizations - test did not complete!");
            }
            myOrgs = br.getCollection();
            iter = myOrgs.iterator();
            o = null;
            while (iter.hasNext()) {
                o = (Organization)iter.next();
                this.debug.add("This is my orgs key: " + o.getKey().getId() + " \n");
                Collection services = o.getServices();
                o.removeServices(services);
                Collection users = o.getUsers();
                o.removeUsers(users);
                key = o.getKey();
                orgKeys.add(key);
            }
            this.debug.add(" delete the organization \n");
            br = this.blm.deleteOrganizations(myKeys);
            if (!JAXR_Util.checkBulkResponse("deleteOrganizations", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from findOrganizations - test did not complete!");
            }
            names.clear();
            names.add(name);
            this.debug.add("Verify the organizations have been deleted \n");
            RegistryObject ro = null;
            try {
                String orgKeyId = key.getId();
                ro = bqm.getRegistryObject(orgKeyId, "Organization");
            }
            catch (Exception e) {
                this.debug.add("Good - caught exception trying to get a deleted organization \n");
                TestUtil.printStackTrace((Throwable)e);
                pass = true;
            }
            if (ro == null) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BusinessLifeCycleManager_SaveOrganizationsTest() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_SaveOrganizationsTest";
        boolean pass = true;
        String name = "TS Test Name: BusinessLifeCycleManager_SaveOrganizationsTest";
        String descr = "Description: Test for BusinessLifeCycleManager_SaveOrganizationsTest";
        ArrayList<Organization> orgs = null;
        Collection myKeys = null;
        try {
            orgs = new ArrayList<Organization>();
            Organization org = JAXR_Util.createDefaultOrganization(this.blm);
            org.setName(this.blm.createInternationalString(this.tsLocale, name));
            org.setDescription(this.blm.createInternationalString(this.tsLocale, descr));
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from saveOrganizations - test did not complete!");
            }
            this.debug.add("Find the Organizations by Name \n");
            myKeys = br.getCollection();
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Iterator iter = null;
            Organization o = null;
            ArrayList orgKeys = new ArrayList();
            ArrayList<InternationalString> names = new ArrayList<InternationalString>();
            Collection myOrgs = null;
            Object key = null;
            names.add(this.blm.createInternationalString(this.tsLocale, name));
            br = bqm.getRegistryObjects(myKeys, "Organization");
            if (!JAXR_Util.checkBulkResponse("findOrganizations", br, this.debug)) {
                throw new EETest.Fault(testName + " Error from findOrganizations - test did not complete!");
            }
            myOrgs = br.getCollection();
            iter = myOrgs.iterator();
            o = null;
            while (iter.hasNext()) {
                o = (Organization)iter.next();
            }
            if (o.getName().getValue(this.tsLocale).equals(name)) {
                this.debug.add("Got back expected Organization Name!\n");
            } else {
                pass = false;
                this.debug.add("Error: returned name not as expected! \n");
                this.debug.add("Expected name: " + name + "\n");
                this.debug.add("Returned name: " + o.getName().getValue(this.tsLocale) + "\n");
            }
            if (o.getDescription().getValue(this.tsLocale).equals(descr)) {
                this.debug.add("Got back expected Organization Description!\n");
            } else {
                pass = false;
                this.debug.add("Error: returned description not as expected! \n");
                this.debug.add("Expected description: " + descr + "\n");
                this.debug.add("Returned description: " + o.getDescription().getValue() + "\n");
            }
            super.cleanUpRegistry(myKeys, "Organization");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            super.cleanUpRegistry(myKeys, "Organization");
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void saveOrganizationsUnexpectedObjectExceptionTest() throws EETest.Fault {
        String testName = "saveOrganizationsUnexpectedObjectExceptionTest";
        boolean pass = false;
        String notAnOrg = "This is a string object";
        ArrayList<String> debug = null;
        debug = new ArrayList<String>();
        try {
            Organization org = JAXR_Util.createDefaultOrganization(this.blm);
            ArrayList<Object> orgs = new ArrayList<Object>();
            orgs.add(org);
            orgs.add(notAnOrg);
            try {
                BulkResponse br = this.blm.saveOrganizations(orgs);
                pass = false;
                debug.add("Error! UnexpectedObjectException was NOT thrown as expected\n");
            }
            catch (UnexpectedObjectException uo) {
                TestUtil.printStackTrace((Throwable)uo);
                debug.add("Good! UnexpectedObjectException was thrown as expected\n");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrganizationsInitialTest() throws EETest.Fault {
        String testName = "saveOrganizationsInitialTest";
        boolean pass = true;
        Collection myKeys = null;
        try {
            Organization org = JAXR_Util.createDefaultOrganization(this.blm);
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            this.debug.add("Status from saveOrganizations is: " + br.getStatus() + " \n");
            if (br.getExceptions() == null) {
                this.debug.add("Got back bulkresponse from saveOrganization with no errors!\n");
            } else {
                this.debug.add("Exception returned from saveOrganization!!\n");
                this.debug.add("IsPartialResponse returns: " + br.isPartialResponse());
                this.debug.add("Exception returned is: " + br.getExceptions());
            }
            myKeys = br.getCollection();
            this.debug.add("Now do a find on Organization\n");
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ArrayList<String> names = new ArrayList<String>();
            names.add("TS Default Organization");
            br = bqm.getRegistryObjects(myKeys, "Organization");
            this.debug.add("Check for errors \n");
            Collection myOrgs = null;
            if (br.getExceptions() == null) {
                this.debug.add("Got back bulkresponse from findOrganization with no errors!\n");
                myOrgs = br.getCollection();
                Iterator iter = myOrgs.iterator();
                Organization o = null;
                ArrayList<Key> orgKeys = new ArrayList<Key>();
                while (iter.hasNext()) {
                    o = (Organization)iter.next();
                    Collection services = o.getServices();
                    o.removeServices(services);
                    Collection users = o.getUsers();
                    o.removeUsers(users);
                    Key key = o.getKey();
                    orgKeys.add(key);
                    this.debug.add("Got an organization:  == " + o.getName() + "\n");
                }
                this.debug.add("Now delete the organization:  == " + o.getName() + "\n");
                br = this.blm.deleteOrganizations(orgKeys);
                this.debug.add("Now iterate thru again \n");
                while (iter.hasNext()) {
                    o = (Organization)iter.next();
                    this.debug.add("Got an organization:  == " + o.getName() + "\n");
                }
            } else {
                this.debug.add("Exception returned from findOrganization!!\n");
                this.debug.add("IsPartialResponse returns: " + br.isPartialResponse());
                this.debug.add("Exception returned is: " + br.getExceptions());
            }
            super.cleanUpRegistry(myKeys, "Organization");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            super.cleanUpRegistry(myKeys, "Organization");
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

