/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.tx.txbean;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.tx.txbean.AppException;
import com.sun.ts.tests.ejb.ee.tx.txbean.SysException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.sql.DataSource;

public class TxBeanEJB
implements SessionBean {
    private SessionContext sctx = null;
    private TSNamingContext context = null;
    private transient Connection con1;
    private transient Connection con2;
    private transient Statement stmt;
    private transient PreparedStatement pStmt;
    private DataSource ds;
    private String tName1 = null;
    private String tName2 = null;
    private Integer tSize = null;
    public static final int FLAGAPPEXCEPTION = -1;
    public static final int FLAGAPPEXCEPTIONWITHROLLBACK = -2;
    public static final int FLAGSYSEXCEPTION = -3;
    public static final int FLAGEJBEXCEPTION = -5;
    public static final int FLAGERROR = -6;
    public static final int FLAGROLLBACK = -7;

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        try {
            this.sctx = sc;
            this.context = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception setting EJB context", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    private void dbConnect2(String tName) {
        TestUtil.logTrace((String)"dbConnect2");
        this.initSetup();
        try {
            if (tName.equals(this.tName1)) {
                this.conTable1();
            } else if (tName.equals(this.tName2)) {
                this.conTable2();
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            TestUtil.logTrace((String)("Made the JDBC connection to " + tName + " DB"));
        }
        catch (Exception se) {
            TestUtil.logErr((String)("Exception opening db connection for " + tName), (Throwable)se);
            throw new EJBException(se.getMessage());
        }
    }

    private void dbUnConnect2(String tName) {
        TestUtil.logTrace((String)"dbUnConnect2");
        this.initSetup();
        try {
            if (tName.equals(this.tName1)) {
                this.con1.close();
                this.con1 = null;
            } else if (tName.equals(this.tName2)) {
                this.con2.close();
                this.con2 = null;
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            TestUtil.logMsg((String)("Closed " + tName + " connection"));
        }
        catch (SQLException se) {
            TestUtil.logErr((String)("SQLException closing db connection for " + tName), (Throwable)se);
            throw new EJBException(se.getMessage());
        }
    }

    public void createData(String tName) {
        TestUtil.logTrace((String)"createData");
        this.initSetup();
        try {
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                this.createTable1();
            } else if (tName.equals(this.tName2)) {
                this.createTable2();
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            TestUtil.logMsg((String)("Created " + tName));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception creating table " + tName), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                this.dbUnConnect2(tName);
            }
            catch (Exception se) {
                TestUtil.logErr((String)("Exception closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(String tName, int key) {
        TestUtil.logTrace((String)"insert");
        this.initSetup();
        int newKey = key;
        String newName = null;
        float newPrice = 0.0f + (float)newKey;
        this.pStmt = null;
        try {
            String updateString;
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                newName = this.tName1 + "-" + newKey;
                updateString = TestUtil.getProperty((String)"TxBean_insert1");
                this.pStmt = this.con1.prepareStatement(updateString);
            } else if (tName.equals(this.tName2)) {
                newName = this.tName2 + "-" + newKey;
                updateString = TestUtil.getProperty((String)"TxBean_insert2");
                this.pStmt = this.con2.prepareStatement(updateString);
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            this.pStmt.setInt(1, newKey);
            this.pStmt.setString(2, newName);
            this.pStmt.setFloat(3, newPrice);
            this.pStmt.executeUpdate();
            TestUtil.logMsg((String)("Inserted a row into the table " + tName));
            boolean updateString2 = true;
            return updateString2;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception inserting a row into table " + tName), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.dbUnConnect2(tName);
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public void delete(String tName, int fromKey, int toKey) {
        TestUtil.logTrace((String)"delete");
        this.initSetup();
        this.pStmt = null;
        try {
            String updateString;
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                updateString = TestUtil.getProperty((String)"TxBean_delete1");
                this.pStmt = this.con1.prepareStatement(updateString);
            } else if (tName.equals(this.tName2)) {
                updateString = TestUtil.getProperty((String)"TxBean_delete2");
                this.pStmt = this.con2.prepareStatement(updateString);
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            for (int i = fromKey; i <= toKey; ++i) {
                this.pStmt.setInt(1, i);
                this.pStmt.executeUpdate();
            }
            TestUtil.logMsg((String)("Deleted row(s) " + fromKey + " thru " + toKey + " from the table " + tName));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception deleting row(s) " + fromKey + " thru " + toKey + " from the table " + tName), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.dbUnConnect2(tName);
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public boolean delete(String tName, int fromKey, int toKey, int flag) throws AppException {
        TestUtil.logTrace((String)"delete with exception");
        this.initSetup();
        this.pStmt = null;
        boolean isRolledback = false;
        try {
            String updateString;
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                updateString = TestUtil.getProperty((String)"TxBean_delete1");
                this.pStmt = this.con1.prepareStatement(updateString);
            } else if (tName.equals(this.tName2)) {
                updateString = TestUtil.getProperty((String)"TxBean_delete2");
                this.pStmt = this.con2.prepareStatement(updateString);
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            for (int i = fromKey; i <= toKey; ++i) {
                this.pStmt.setInt(1, i);
                this.pStmt.executeUpdate();
            }
            TestUtil.logMsg((String)("Deleted row(s) " + fromKey + " thru " + toKey + " from the table " + tName));
            if (flag == -1) {
                this.throwAppException();
            }
            if (flag == -2) {
                TestUtil.logTrace((String)"calling setRollbackOnly");
                this.sctx.setRollbackOnly();
                TestUtil.logTrace((String)"Calling getRollbackOnly method");
                if (this.sctx.getRollbackOnly()) {
                    isRolledback = true;
                }
                this.throwAppException();
            }
            if (flag == -3) {
                this.throwSysException();
            }
            if (flag == -5) {
                throw new EJBException("EJBException from TxBeanEJB delete with exceptionmethod");
            }
            if (flag == -6) {
                throw new Error("Error from TxBeanEJB delete with exception method");
            }
            if (flag == -7) {
                TestUtil.logTrace((String)"Calling setRollbackOnly method");
                this.sctx.setRollbackOnly();
                TestUtil.logTrace((String)"Calling getRollbackOnly method");
                if (this.sctx.getRollbackOnly()) {
                    isRolledback = true;
                }
            }
        }
        catch (AppException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AppException("AppException from delete");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception deleting row(s) " + fromKey + " thru " + toKey + " from the table " + tName), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.dbUnConnect2(tName);
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
        return isRolledback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String tName, int key, String brandName) {
        TestUtil.logTrace((String)"update for row brandName");
        this.initSetup();
        int newKey = key;
        String newName = brandName;
        this.pStmt = null;
        try {
            String updateString;
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                updateString = TestUtil.getProperty((String)"TxBean_update1");
                this.pStmt = this.con1.prepareStatement(updateString);
            } else if (tName.equals(this.tName2)) {
                updateString = TestUtil.getProperty((String)"TxBean_update2");
                this.pStmt = this.con2.prepareStatement(updateString);
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            this.pStmt.setString(1, newName);
            this.pStmt.setInt(2, newKey);
            this.pStmt.executeUpdate();
            TestUtil.logMsg((String)("Updated a row in the table " + tName));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception updating a row in the table " + tName), (Throwable)e);
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.dbUnConnect2(tName);
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String tName, int key, float price) {
        TestUtil.logTrace((String)"update for row price");
        this.initSetup();
        int newKey = key;
        float newPrice = price;
        this.pStmt = null;
        try {
            String updateString;
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                updateString = TestUtil.getProperty((String)"TxBean_update3");
                this.pStmt = this.con1.prepareStatement(updateString);
            } else if (tName.equals(this.tName2)) {
                updateString = TestUtil.getProperty((String)"TxBean_update4");
                this.pStmt = this.con2.prepareStatement(updateString);
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            this.pStmt.setFloat(1, newPrice);
            this.pStmt.setInt(2, newKey);
            this.pStmt.executeUpdate();
            TestUtil.logMsg((String)("Updated a row in the table " + tName));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception updating a row in the table " + tName), (Throwable)e);
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.dbUnConnect2(tName);
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public void destroyData(String tName) {
        TestUtil.logTrace((String)"destroyData");
        this.initSetup();
        try {
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                this.dropTable1();
            } else if (tName.equals(this.tName2)) {
                this.dropTable2();
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            TestUtil.logMsg((String)("Removed " + tName));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to drop table", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                this.dbUnConnect2(tName);
            }
            catch (Exception se) {
                TestUtil.logErr((String)("Exception closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public int getDefaultTxIsolationLevel(String tName) {
        int iInt;
        block11: {
            TestUtil.logTrace((String)"getDefaultTxIsolationLevel");
            this.initSetup();
            iInt = 0;
            DatabaseMetaData dmd2 = null;
            DatabaseMetaData dmd1 = null;
            try {
                this.dbConnect2(tName);
                if (tName.equals(this.tName1)) {
                    dmd1 = this.con1.getMetaData();
                    iInt = dmd1.getDefaultTransactionIsolation();
                    break block11;
                }
                if (tName.equals(this.tName2)) {
                    dmd2 = this.con2.getMetaData();
                    iInt = dmd2.getDefaultTransactionIsolation();
                    break block11;
                }
                throw new EJBException("Invalid table name: " + tName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception occured getting default Isolation level", (Throwable)e);
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    this.dbUnConnect2(tName);
                }
                catch (Exception se) {
                    TestUtil.logErr((String)("Exception closing db connection for " + tName), (Throwable)se);
                    throw new EJBException(se.getMessage());
                }
            }
        }
        return iInt;
    }

    public Vector getResults(String tName) {
        TestUtil.logTrace((String)"getResults");
        this.initSetup();
        Vector<Object> queryResults = new Vector<Object>();
        this.stmt = null;
        try {
            String name;
            ResultSet rs;
            String query;
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                query = TestUtil.getProperty((String)"TxBean_query1");
                this.stmt = this.con1.createStatement();
                rs = this.stmt.executeQuery(query);
                name = "TABONE_NAME";
            } else if (tName.equals(this.tName2)) {
                query = TestUtil.getProperty((String)"TxBean_query2");
                this.stmt = this.con2.createStatement();
                rs = this.stmt.executeQuery(query);
                name = "TABTWO_NAME";
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            while (rs.next()) {
                int i = rs.getInt("KEY_ID");
                String s = rs.getString(name);
                float f = rs.getFloat("PRICE");
                queryResults.addElement(new Integer(i));
                queryResults.addElement(s);
                queryResults.addElement(new Float(f));
            }
            TestUtil.logMsg((String)("Obtained " + tName + " table ResultSet"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception obtaining " + tName + " table ResultSet"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                this.dbUnConnect2(tName);
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
        return queryResults;
    }

    public Vector getResults(String tName, int key) {
        TestUtil.logTrace((String)"getResults for a single row");
        this.initSetup();
        Vector<Object> queryResults = new Vector<Object>();
        this.pStmt = null;
        try {
            String name;
            ResultSet rs;
            String query;
            this.dbConnect2(tName);
            if (tName.equals(this.tName1)) {
                query = TestUtil.getProperty((String)"TxBean_query3");
                this.pStmt = this.con1.prepareStatement(query);
                this.pStmt.setInt(1, key);
                rs = this.pStmt.executeQuery();
                name = "TABONE_NAME";
            } else if (tName.equals(this.tName2)) {
                query = TestUtil.getProperty((String)"TxBean_query4");
                this.pStmt = this.con1.prepareStatement(query);
                this.pStmt.setInt(1, key);
                rs = this.pStmt.executeQuery();
                name = "TABTWO_NAME";
            } else {
                throw new EJBException("Invalid table name: " + tName);
            }
            while (rs.next()) {
                int i = rs.getInt("KEY_ID");
                String s = rs.getString(name);
                float f = rs.getFloat("PRICE");
                queryResults.addElement(new Integer(i));
                queryResults.addElement(s);
                queryResults.addElement(new Float(f));
            }
            TestUtil.logMsg((String)("Obtained " + tName + " table ResultSet"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception obtaining " + tName + " table ResultSet"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.dbUnConnect2(tName);
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
        return queryResults;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void initLogging() {
    }

    public void throwAppException() throws AppException {
        TestUtil.logTrace((String)"throwAppException");
        throw new AppException("AppException from TxBean");
    }

    public void throwSysException() {
        TestUtil.logTrace((String)"throwSysException");
        throw new SysException("SysException from TxBean");
    }

    public void throwEJBException() {
        TestUtil.logTrace((String)"throwEJBException");
        throw new EJBException("EJBException from TxBean");
    }

    public void throwError() {
        TestUtil.logTrace((String)"throwError");
        throw new Error("Error from TxBean");
    }

    public void listTableData(Vector dbResults) {
        TestUtil.logTrace((String)"listTableData");
        this.initSetup();
        try {
            if (dbResults.isEmpty()) {
                TestUtil.logTrace((String)"Empty vector!!!");
            } else {
                for (int j = 0; j < dbResults.size(); ++j) {
                    TestUtil.logTrace((String)dbResults.elementAt(j).toString());
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to list table data", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void conTable1() {
        TestUtil.logTrace((String)"conTable1");
        this.initSetup();
        try {
            this.con1 = this.ds.getConnection();
            TestUtil.logTrace((String)("con1: " + this.con1.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.tName1 + " DB"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.tName1 + " DB"), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void conTable2() {
        TestUtil.logTrace((String)"conTable2");
        this.initSetup();
        try {
            this.con2 = this.ds.getConnection();
            TestUtil.logTrace((String)("con2: " + this.con2.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.tName2 + " DB"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.tName2 + " DB"), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void createTable1() {
        TestUtil.logTrace((String)"createTable1");
        this.initSetup();
        this.pStmt = null;
        try {
            this.dropTable1();
            TestUtil.logTrace((String)("Deleted all rows from table " + this.tName1));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("SQLException encountered while deleting rows from " + this.tName1 + ":" + e.getMessage()));
        }
        try {
            TestUtil.logTrace((String)("Adding the " + this.tName1 + " table rows"));
            String updateString = TestUtil.getProperty((String)"TxBean_insert1");
            this.pStmt = this.con1.prepareStatement(updateString);
            for (int i = 1; i <= this.tSize; ++i) {
                int newKey = i;
                String newName = this.tName1 + "-" + i;
                float newPrice = (float)i + 0.0f;
                this.pStmt.setInt(1, newKey);
                this.pStmt.setString(2, newName);
                this.pStmt.setFloat(3, newPrice);
                this.pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException creating " + this.tName1 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException pStmt/stmt for " + this.tName1 + ":" + se.getMessage()), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    private void createTable2() {
        TestUtil.logTrace((String)"createTable2");
        this.initSetup();
        this.pStmt = null;
        try {
            this.dropTable2();
            TestUtil.logTrace((String)("Deleted all rows from table " + this.tName2));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("SQLException encountered while deleting rows from " + this.tName2 + ":" + e.getMessage()));
        }
        try {
            TestUtil.logTrace((String)("Adding the " + this.tName2 + " table rows"));
            String updateString = TestUtil.getProperty((String)"TxBean_insert2");
            this.pStmt = this.con2.prepareStatement(updateString);
            for (int i = 1; i <= this.tSize; ++i) {
                int newKey = i;
                String newName = this.tName2 + "-" + i;
                float newPrice = (float)i + 0.0f;
                this.pStmt.setInt(1, newKey);
                this.pStmt.setString(2, newName);
                this.pStmt.setFloat(3, newPrice);
                this.pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException creating " + this.tName2 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException pStmt/stmt for " + this.tName2 + se.getMessage()), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    private void dropTable1() {
        TestUtil.logTrace((String)"dropTable1");
        this.initSetup();
        String removeString = TestUtil.getProperty((String)"TxBean_Tab1_Delete");
        this.stmt = null;
        try {
            this.stmt = this.con1.createStatement();
            this.stmt.executeUpdate(removeString);
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException dropping " + this.tName1 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException stmt for " + this.tName1), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    private void dropTable2() {
        TestUtil.logTrace((String)"dropTable2");
        this.initSetup();
        String removeString = TestUtil.getProperty((String)"TxBean_Tab2_Delete");
        this.stmt = null;
        try {
            this.stmt = this.con2.createStatement();
            this.stmt.executeUpdate(removeString);
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException dropping " + this.tName2 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException stmt for " + this.tName2), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    private void initSetup() {
        try {
            this.ds = (DataSource)this.context.lookup("java:comp/env/jdbc/DB1");
            TestUtil.logTrace((String)("ds: " + this.ds));
            TestUtil.logTrace((String)"DataSource lookup OK!");
            this.tName1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"TxBean_Tab1_Delete"));
            TestUtil.logTrace((String)("tName1: " + this.tName1));
            this.tName2 = TestUtil.getTableName((String)TestUtil.getProperty((String)"TxBean_Tab2_Delete"));
            TestUtil.logTrace((String)("tName2: " + this.tName2));
            this.tSize = (Integer)this.context.lookup("java:comp/env/size");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Create exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }
}

