/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1027;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.ts.tests.jaxrpc.wsi.utils.SOAPUtils;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1027.W2JRLR1027Client;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Properties;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class Client
extends ServiceEETest
implements SOAPRequests {
    private W2JRLR1027Client client;

    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client = (W2JRLR1027Client)ClientFactory.getClient(W2JRLR1027Client.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testNotUnderstoodHeaderInRequest() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?><!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --><env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Header><foo:Bar xmlns:foo='http://foo.org/bar/' env:actor='http://schemas.xmlsoap.org/soap/actor/next' env:mustUnderstand='1'>BAZ</foo:Bar></env:Header><env:Body><ns0:helloWorld/></env:Body></env:Envelope>");
        }
        catch (Exception e) {
            this.client.logMessageInHarness(response);
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.client.logMessageInHarness(response);
            this.validateIsMustUnderstandFault(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
    }

    public void testNotUnderstoodHeaderInResponse() throws EETest.Fault {
        try {
            this.client.helloWorld();
            throw new EETest.Fault("Test didn't throw \"mustUnderstand\" fault (BP-R1027)");
        }
        catch (SOAPFaultException sfe) {
            this.validateIsMustUnderstandFault(sfe);
        }
        catch (ServerException sfe) {
        }
        catch (RemoteException sfe) {
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
    }

    private void validateIsMustUnderstandFault(SOAPMessage response) throws EETest.Fault, SOAPException {
        if (!SOAPUtils.isMustUnderstandFaultcode(response)) {
            throw new EETest.Fault("Invalid response: instances must generate a \"MustUnderstand\" soap:Fault when a request contains a soap header with \"mustUnderstand=1\" that is not understood (BP-R1027)");
        }
    }

    private void validateIsMustUnderstandFault(SOAPFaultException se) throws EETest.Fault {
        if (!SOAPUtils.isMustUnderstandFaultcode(se)) {
            throw new EETest.Fault("Invalid response: instances must generate a \"MustUnderstand\" soap:Fault when a request contains a soap header with \"mustUnderstand=1\" that is not understood (BP-R1027)");
        }
    }
}

