/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonwritertests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonwritertests.Writer;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import com.sun.ts.tests.jsonp.common.MyBufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonWriter;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonWriterTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            this.logMsg("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)sWriter);){
                writer.writeObject(myJsonObject1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String contents = sWriter.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + contents);
            this.logMsg("Read the JsonObject back into 'myJsonObject2' using a JsonReader");
            JsonReader reader = Json.createReader((Reader)new StringReader(contents));
            JsonObject myJsonObject2 = (JsonObject)reader.read();
            this.logMsg("Compare myJsonObject1 and myJsonObject2 for equality");
            pass = JSONP_Util.assertEqualsJsonObjects(myJsonObject1, myJsonObject2);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterTest1 Failed");
        }
    }

    public void jsonWriterTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            this.logMsg("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriter((OutputStream)baos);
            writer.writeObject(myJsonObject1);
            this.logMsg("Close JsonWriter");
            baos.close();
            writer.close();
            this.logMsg("Save contents of the JsonWriter as a String");
            String actJsonObjectText = baos.toString("UTF-8");
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + actJsonObjectText);
            this.logMsg("Compare expected JsonObject text with actual JsonObject text for equality");
            pass = JSONP_Util.assertEqualsJsonText("{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}", actJsonObjectText);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterTest2 Failed");
        }
    }

    public void jsonWriterTest3() throws EETest.Fault {
        boolean pass = true;
        try {
            JsonArray myJsonArray2;
            this.logMsg("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            this.logMsg("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)sWriter);){
                writer.writeArray(myJsonArray1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String contents = sWriter.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + contents);
            this.logMsg("Read the JsonArray back into 'myJsonArray2' using a JsonReader");
            try (JsonReader reader = Json.createReader((Reader)new StringReader(contents));){
                myJsonArray2 = (JsonArray)reader.read();
                this.logMsg("Close JsonReader");
            }
            this.logMsg("Compare myJsonArray1 and myJsonArray2 for equality");
            pass = JSONP_Util.assertEqualsJsonArrays(myJsonArray1, myJsonArray2);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterTest3 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterTest3 Failed");
        }
    }

    public void jsonWriterTest4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            this.logMsg("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriter((OutputStream)baos);
            writer.writeArray(myJsonArray1);
            this.logMsg("Close JsonWriter");
            baos.close();
            writer.close();
            this.logMsg("Save contents of the JsonWriter as a String");
            String actJsonArrayText = baos.toString("UTF-8");
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + actJsonArrayText);
            this.logMsg("Compare expected JsonArray text with actual JsonArray text for equality");
            pass = JSONP_Util.assertEqualsJsonText("[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]", actJsonArrayText);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterTest4 Failed");
        }
    }

    public void jsonWriterTest5() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            this.logMsg("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriterFactory(JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_16BE);
            writer.writeObject(myJsonObject1);
            this.logMsg("Close JsonWriter");
            baos.close();
            writer.close();
            this.logMsg("Save contents of the JsonWriter as a String");
            String actJsonObjectText = JSONP_Util.removeWhitespace(baos.toString("UTF-16BE"));
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + actJsonObjectText);
            this.logMsg("Compare expected JsonObject text with actual JsonObject text for equality");
            pass = JSONP_Util.assertEqualsJsonText("{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}", actJsonObjectText);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterTest5 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterTest5 Failed");
        }
    }

    public void jsonWriterTest6() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create a configuration with PRETT_PRINTING enabled.");
            Map<String, ?> config = JSONP_Util.getPrettyPrintingConfig();
            this.logMsg("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            this.logMsg("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriterFactory(config).createWriter((OutputStream)baos, JSONP_Util.UTF_8);
            writer.writeArray(myJsonArray1);
            this.logMsg("Close JsonWriter");
            baos.close();
            writer.close();
            this.logMsg("Save contents of the JsonWriter as a String");
            String actJsonArrayText = JSONP_Util.removeWhitespace(baos.toString("UTF-8"));
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + actJsonArrayText);
            this.logMsg("Compare expected JsonArray text with actual JsonArray text for equality");
            pass = JSONP_Util.assertEqualsJsonText("[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]", actJsonArrayText);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterTest6 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterTest6 Failed");
        }
    }

    public void jsonWriterTest7() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            this.logMsg("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)sWriter);){
                writer.write((JsonStructure)myJsonObject1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String contents = sWriter.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + contents);
            this.logMsg("Read the JsonObject back into 'myJsonObject2' using a JsonReader");
            JsonReader reader = Json.createReader((Reader)new StringReader(contents));
            JsonObject myJsonObject2 = (JsonObject)reader.read();
            this.logMsg("Compare myJsonObject1 and myJsonObject2 for equality");
            pass = JSONP_Util.assertEqualsJsonObjects(myJsonObject1, myJsonObject2);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterTest7 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterTest7 Failed");
        }
    }

    public void jsonWriterTest8() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            this.logMsg("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)sWriter);){
                writer.write((JsonStructure)myJsonArray1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String contents = sWriter.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + contents);
            this.logMsg("Read the JsonArray back into 'myJsonArray2' using a JsonReader");
            JsonReader reader = Json.createReader((Reader)new StringReader(contents));
            JsonArray myJsonArray2 = (JsonArray)reader.read();
            this.logMsg("Compare myJsonArray1 and myJsonArray2 for equality");
            pass = JSONP_Util.assertEqualsJsonArrays(myJsonArray1, myJsonArray2);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterTest8 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterTest8 Failed");
        }
    }

    public void jsonWriterUTFEncodedTests() throws EETest.Fault {
        String actJson;
        JsonWriter writer;
        ByteArrayOutputStream baos;
        boolean pass = true;
        this.logMsg("Create expected JSON text with no whitespace for use in comparsion");
        String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
        try {
            this.logMsg("-----------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-8]");
            this.logMsg("-----------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonWriter using UTF-8 encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory(JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_8);
            JSONP_Util.writeJsonObjectFromString(writer, expJson);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-8")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-8 encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-8 encoding: " + e);
        }
        try {
            this.logMsg("------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-16]");
            this.logMsg("------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonWriter using UTF-16 encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory(JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_16);
            JSONP_Util.writeJsonObjectFromString(writer, expJson);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-16")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-16 encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-16 encoding: " + e);
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-16LE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonWriter using UTF-16LE encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory(JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_16LE);
            JSONP_Util.writeJsonObjectFromString(writer, expJson);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-16LE")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-16LE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16LE"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-16LE encoding: " + e);
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-16BE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonWriter using UTF-16BE encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory(JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_16BE);
            JSONP_Util.writeJsonObjectFromString(writer, expJson);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-16BE")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-16BE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16BE"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-16BE encoding: " + e);
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-32LE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonWriter using UTF-32LE encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory(JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_32LE);
            JSONP_Util.writeJsonObjectFromString(writer, expJson);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-32LE")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-32LE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-32LE"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-32LE encoding: " + e);
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-32BE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonWriter using UTF-32BE encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory(JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_32BE);
            JSONP_Util.writeJsonObjectFromString(writer, expJson);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-32BE")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-32BE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-32BE"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-32BE encoding: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterUTFEncodedTests Failed");
        }
    }

    public void jsonWriterWithConfigTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create a configuration with PRETT_PRINTING enabled.");
            Map<String, ?> config = JSONP_Util.getPrettyPrintingConfig();
            this.logMsg("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            this.logMsg("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter swriter = new StringWriter();
            try (JsonWriter writer = Json.createWriterFactory(config).createWriter((java.io.Writer)swriter);){
                writer.writeObject(myJsonObject1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String actJsonObjectText = JSONP_Util.removeWhitespace(swriter.toString());
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + actJsonObjectText);
            this.logMsg("Compare expected JsonObject text with actual JsonObject text for equality");
            pass = JSONP_Util.assertEqualsJsonText("{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}", actJsonObjectText);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterWithConfigTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterWithConfigTest1 Failed");
        }
    }

    public void jsonWriterWithConfigTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create a configuration with PRETT_PRINTING enabled.");
            Map<String, ?> config = JSONP_Util.getPrettyPrintingConfig();
            this.logMsg("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            this.logMsg("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriterFactory(config).createWriter((OutputStream)baos);
            writer.writeArray(myJsonArray1);
            this.logMsg("Close JsonWriter");
            baos.close();
            writer.close();
            this.logMsg("Save contents of the JsonWriter as a String");
            String actJsonArrayText = JSONP_Util.removeWhitespace(baos.toString("UTF-8"));
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + actJsonArrayText);
            this.logMsg("Compare expected JsonArray text with actual JsonArray text for equality");
            pass = JSONP_Util.assertEqualsJsonText("[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]", actJsonArrayText);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonWriterWithConfigTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterWithConfigTest2 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jsonWriterExceptionTests() throws EETest.Fault {
        JsonObject jsonObject;
        StringWriter sWriter;
        JsonObject jsonObject2;
        StringWriter sWriter2;
        JsonArray jsonArray;
        boolean pass = true;
        JsonWriter writer = null;
        try {
            this.logMsg("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create JsonWriter, write something and close it");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeArray(jsonArray);
            writer.close();
            this.logMsg("IllegalStateException if writer.close() already called before writer.writeArray(JsonArray)");
            writer.writeArray(jsonArray);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create JsonWriter and write out array");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeArray(jsonArray);
            this.logMsg("IllegalStateException if writer.writeArray(JsonArray) called after writer.writeArray(JsonArray)");
            writer.writeArray(jsonArray);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            this.logMsg("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create sample JsonObject for testing");
            jsonObject2 = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create JsonWriter and write out array");
            sWriter = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter);
            writer.writeArray(jsonArray);
            this.logMsg("IllegalStateException if writer.writeObject(JsonObject) called after writer.writeArray(JsonArray)");
            writer.writeObject(jsonObject2);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            this.logMsg("Create sample JsonObject for testing");
            jsonObject = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create JsonWriter, write something and close it");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeObject(jsonObject);
            writer.close();
            this.logMsg("IllegalStateException if writer.close() already called before writer.writeObject(JsonObject)");
            writer.writeObject(jsonObject);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Create sample JsonObject for testing");
            jsonObject = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create JsonWriter and write out object");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeObject(jsonObject);
            this.logMsg("IllegalStateException if writer.writeObject(JsonObject) called after writer.writeObject(JsonObject)");
            writer.writeObject(jsonObject);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            this.logMsg("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create sample JsonObject for testing");
            jsonObject2 = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create JsonWriter and write out object");
            sWriter = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter);
            writer.writeObject(jsonObject2);
            this.logMsg("IllegalStateException if writer.writeArray(JsonArray) called after writer.writeObject(JsonObject)");
            writer.writeArray(jsonArray);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            this.logMsg("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create JsonWriter, write something and close it");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.write((JsonStructure)jsonArray);
            writer.close();
            this.logMsg("IllegalStateException if writer.close() already called before writer.write(JsonArray)");
            writer.write((JsonStructure)jsonArray);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create JsonWriter and write out array");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeArray(jsonArray);
            this.logMsg("IllegalStateException if writer.write(JsonArray) called after writer.writeArray(JsonArray)");
            writer.write((JsonStructure)jsonArray);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            this.logMsg("Create sample JsonObject for testing");
            jsonObject = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create JsonWriter and write out object");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeObject(jsonObject);
            this.logMsg("IllegalStateException if writer.write(JsonObject) called after writer.writeObject(JsonObject)");
            writer.write((JsonStructure)jsonObject);
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterExceptionTests Failed");
        }
    }

    public void jsonWriterIOErrorTests() throws EETest.Fault {
        Throwable throwable;
        JsonWriter writer;
        MyBufferedWriter mbw;
        JsonObject myJsonObject;
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonObject for testing");
            myJsonObject = JSONP_Util.createSampleJsonObject();
            this.logMsg("Trip JsonException if there is an i/o error on JsonWriter.close().");
            mbw = new MyBufferedWriter(new StringWriter());
            writer = Json.createWriter((java.io.Writer)mbw);
            throwable = null;
            try {
                writer.writeObject(myJsonObject);
                mbw.setThrowIOException(true);
                this.logMsg("Calling JsonWriter.close()");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Create sample JsonObject for testing");
            myJsonObject = JSONP_Util.createSampleJsonObject();
            this.logMsg("Trip JsonException if there is an i/o error on JsonWriter.writeObject(JsonObject).");
            mbw = new MyBufferedWriter(new StringWriter());
            writer = Json.createWriter((java.io.Writer)mbw);
            throwable = null;
            try {
                mbw.setThrowIOException(true);
                this.logMsg("Calling JsonWriter.writeObject(JsonObject)");
                writer.writeObject(myJsonObject);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Create sample JsonArray for testing");
            JsonArray myJsonArray = JSONP_Util.createSampleJsonArray();
            this.logMsg("Trip JsonException if there is an i/o error on JsonWriter.writeArray(JsonArray).");
            mbw = new MyBufferedWriter(new StringWriter());
            writer = Json.createWriter((java.io.Writer)mbw);
            throwable = null;
            try {
                mbw.setThrowIOException(true);
                this.logMsg("Calling JsonWriter.writeArray(JsonArray)");
                writer.writeArray(myJsonArray);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Create sample JsonObject for testing");
            myJsonObject = JSONP_Util.createSampleJsonObject();
            this.logMsg("Trip JsonException if there is an i/o error on JsonWriter.write(JsonStructure).");
            mbw = new MyBufferedWriter(new StringWriter());
            writer = Json.createWriter((java.io.Writer)mbw);
            throwable = null;
            try {
                mbw.setThrowIOException(true);
                this.logMsg("Calling JsonWriter.write(JsonStructure)");
                writer.write((JsonStructure)myJsonObject);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonWriterIOErrorTests Failed");
        }
    }

    public void jsonWriter11Test() throws EETest.Fault {
        Writer writerTest = new Writer();
        TestResult result = writerTest.test();
        result.eval();
    }
}

