/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ITAbsent;
import com.sun.ts.tests.interop.csiv2.common.parser.ITAnonymous;
import com.sun.ts.tests.interop.csiv2.common.parser.ITCertificateChain;
import com.sun.ts.tests.interop.csiv2.common.parser.ITDistinguishedName;
import com.sun.ts.tests.interop.csiv2.common.parser.ITPrincipalName;
import com.sun.ts.tests.interop.csiv2.common.parser.ITUnknownType;
import com.sun.ts.tests.interop.csiv2.common.parser.IdentityToken;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdentityTokenEntry
extends Entry {
    private IdentityToken identityToken;

    public IdentityTokenEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("identity-token")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("absent")) {
                this.identityToken = new ITAbsent();
                continue;
            }
            if (node.getNodeName().equals("anonymous")) {
                this.identityToken = new ITAnonymous();
                continue;
            }
            if (node.getNodeName().equals("principal-name")) {
                this.identityToken = new ITPrincipalName(IdentityTokenEntry.parseBinHex(this.getText(node)));
                continue;
            }
            if (node.getNodeName().equals("certificate-chain")) {
                this.identityToken = new ITCertificateChain(IdentityTokenEntry.parseBinHex(this.getText(node)));
                continue;
            }
            if (node.getNodeName().equals("distinguished-name")) {
                this.identityToken = new ITDistinguishedName(IdentityTokenEntry.parseBinHex(this.getText(node)));
                continue;
            }
            if (!node.getNodeName().equals("unknown-type")) continue;
            this.identityToken = new ITUnknownType(((Element)node).getAttribute("details"));
        }
    }

    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public String toString() {
        String result = "<identity-token>\n";
        result = result + this.identityToken.toString();
        result = result + "</identity-token>\n";
        return result;
    }
}

