/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.ew_ssl_sslr_upn_upid.reverse;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.lib.util.WebUtil;
import com.sun.ts.tests.interop.csiv2.common.CSIv2AppClient;
import com.sun.ts.tests.interop.csiv2.common.CSIv2Log;
import com.sun.ts.tests.interop.csiv2.common.validation.CSIv2LogValidator;
import com.sun.ts.tests.interop.csiv2.common.validation.IOR7ValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ResponseValidationStrategy;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;

public class Client
extends EETest {
    private Properties props = null;
    private TSURL ctsurl = new TSURL();
    private URL url = null;
    private URLConnection urlConn = null;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private String SERVLET = "/interop_csiv2_ew_ssl_sslr_upn_upid_r_web/CSIv2ServletTest";
    private String webServerHost = "unknown";
    private int webServerPort = 8000;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private TSLoginContext lc = null;
    private WebUtil.Response response = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"Setup");
        boolean pass = true;
        this.props = p;
        try {
            this.webServerHost = p.getProperty(WEBSERVERHOSTPROP);
            if (this.webServerHost == null) {
                pass = false;
            } else if (this.webServerHost.equals("")) {
                pass = false;
            }
            try {
                this.webServerPort = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)("webServerHost = " + this.webServerHost));
            TestUtil.logMsg((String)("webServerPort = " + this.webServerPort));
            if (!pass) {
                TestUtil.logErr((String)"Please specify host & port of web server in ts.jte file: webServerHost, webServerPort");
                throw new EETest.Fault("Setup failed:");
            }
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void ew_ssl_sslr_upn_upid_wb_sb_testid7_reverse_setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"Setup");
        boolean pass = true;
        this.props = p;
        try {
            this.webServerHost = p.getProperty(WEBSERVERHOSTPROP);
            if (this.webServerHost == null) {
                pass = false;
            } else if (this.webServerHost.equals("")) {
                pass = false;
            }
            try {
                this.webServerPort = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)("webServerHost = " + this.webServerHost));
            TestUtil.logMsg((String)("webServerPort = " + this.webServerPort));
            if (!pass) {
                TestUtil.logErr((String)"Please specify host & port of web server in ts.jte file: webServerHost, webServerPort");
                throw new EETest.Fault("Setup failed:");
            }
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void ew_ssl_sslr_upn_upid_sb_sb_testid7() throws EETest.Fault {
        boolean pass = true;
        String testName = "ew_ssl_sslr_upn_upid_sb_sb_testid7_reverse";
        TestUtil.logMsg((String)testName);
        CSIv2Log log = CSIv2Log.getLog();
        log.purge();
        log.enableLoggingInterceptor(true, true);
        log.startLog();
        log.logStartAssertion(testName);
        ArrayList<String> chain = new ArrayList<String>();
        chain.add("java:comp/env/ejb/LocalSession");
        chain.add("java:comp/env/ejb/RemoteSession");
        TestUtil.logMsg((String)"Client initiated.");
        CSIv2AppClient appClient = new CSIv2AppClient();
        TestUtil.logMsg((String)"LocalSessionBean (RI) ====> RemoteSessionBean (VI).");
        appClient.invoke(chain, this.props);
        TestUtil.logMsg((String)"Client completed.");
        log.logEndAssertion();
        log.endLog();
        log.enableLoggingInterceptor(false, false);
        String logContents = log.getLogContents();
        TestUtil.logMsg((String)"Log contents:");
        TestUtil.logMsg((String)logContents);
        log.purge();
        pass = CSIv2LogValidator.validate(testName, logContents, new IOR7ValidationStrategy(false, 2), null, new ResponseValidationStrategy(true, false));
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void ew_ssl_sslr_upn_upid_wb_sb_testid7() throws EETest.Fault {
        boolean pass = true;
        String testName = "ew_ssl_sslr_upn_upid_wb_sb_testid7_reverse";
        TestUtil.logMsg((String)testName);
        CSIv2Log log = CSIv2Log.getLog();
        log.purge();
        log.enableLoggingInterceptor(true, true);
        log.startLog();
        log.logStartAssertion(testName);
        TestUtil.logMsg((String)"Client initiated.");
        TestUtil.logMsg((String)"WebClient (RI) ====> RemoteSessionBean (VI).");
        try {
            TestUtil.logMsg((String)("Sending request \"" + this.SERVLET + "\" with BASIC authentication."));
            this.props.setProperty("CHAIN", "java:comp/env/ejb/RemoteSession");
            this.response = WebUtil.sendAuthenticatedRequest((String)"POST", (InetAddress)InetAddress.getByName(this.webServerHost), (int)this.webServerPort, (String)this.ctsurl.getRequest(this.SERVLET), (Properties)this.props, null, (String)this.username, (String)this.password);
            if (this.response.isError()) {
                TestUtil.logErr((String)("Could not access: " + this.SERVLET));
                TestUtil.logErr((String)("Response content = " + this.response.content));
                throw new EETest.Fault(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed");
        }
        TestUtil.logMsg((String)"Client completed.");
        log.logEndAssertion();
        log.endLog();
        log.enableLoggingInterceptor(false, false);
        String logContents = log.getLogContents();
        TestUtil.logMsg((String)"Log contents:");
        TestUtil.logMsg((String)logContents);
        log.purge();
        pass = CSIv2LogValidator.validate(testName, logContents, new IOR7ValidationStrategy(false, 2), null, new ResponseValidationStrategy(true, false));
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup ok");
    }
}

