/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.nativequery;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.nativequery.Item;
import com.sun.ts.tests.jpa.core.annotations.nativequery.Order1;
import com.sun.ts.tests.jpa.core.annotations.nativequery.Order2;
import com.sun.ts.tests.jpa.core.annotations.nativequery.PurchaseOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.persistence.TransactionRequiredException;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void nativeQueryTest1() throws EETest.Fault {
        boolean pass = false;
        int passCounter = 0;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(4, "WaterShoes");
            Item i2 = new Item(5, "FlipFlops");
            Item i3 = new Item(6, "Sandals");
            TestUtil.logTrace((String)"Create Order1s");
            Order1 o4 = new Order1(4, 25.0);
            o4.setItem(i1);
            this.getEntityManager().persist((Object)o4);
            Order1 o5 = new Order1(5, 125.0);
            o5.setItem(i2);
            this.getEntityManager().persist((Object)o5);
            Order1 o6 = new Order1(6, 150.0);
            o6.setItem(i3);
            this.getEntityManager().persist((Object)o6);
            TestUtil.logTrace((String)"Execute Query ");
            List q = this.getEntityManager().createNativeQuery("Select o.\"ID\", o.\"TOTALPRICE\",  o.\"FK1_FOR_ITEM\", i.\"ID\", i.\"ITEMNAME\" from \"ORDER1\" o, \"ITEM\" i WHERE (o.\"TOTALPRICE\" > 140) AND (o.\"FK1_FOR_ITEM\" = i.\"ID\")", "Order1ItemResults").getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)(" Did not get expected results.  Expected: 1, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                for (Object obj : q) {
                    Object[] objectArray = (Object[])obj;
                    if (objectArray.length != 2) {
                        TestUtil.logErr((String)("Expecting the object array have 2 elements, but the object array is " + Arrays.toString(objectArray)));
                    }
                    for (Object o : objectArray) {
                        if (o instanceof Order1) {
                            Order1 orderReturned = (Order1)o;
                            if (!orderReturned.equals((Object)o6)) {
                                TestUtil.logErr((String)("Expected:" + o6 + ", actual:" + orderReturned));
                                continue;
                            }
                            TestUtil.logTrace((String)"Received expected order");
                            ++passCounter;
                            continue;
                        }
                        if (o instanceof Item) {
                            Item itemReturned = (Item)o;
                            if (!itemReturned.equals((Object)i3)) {
                                TestUtil.logErr((String)("Expected:" + i3 + ", actual:" + itemReturned));
                                continue;
                            }
                            TestUtil.logTrace((String)"Received expected item");
                            ++passCounter;
                            continue;
                        }
                        TestUtil.logErr((String)("Received unexpected object:" + o));
                    }
                }
            }
            if (passCounter == 2) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("nativeQueryTest1 failed");
        }
    }

    public void nativeQueryTest2() throws EETest.Fault {
        boolean pass = false;
        int passCounter = 0;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(7, "Loafers");
            Item i2 = new Item(8, "High Heels");
            Item i3 = new Item(9, "Socks");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o7 = new Order1(7, 25.0);
            o7.setItem(i1);
            this.getEntityManager().persist((Object)o7);
            Order1 o8 = new Order1(8, 125.0);
            o8.setItem(i2);
            this.getEntityManager().persist((Object)o8);
            Order1 o9 = new Order1(9, 150.0);
            o9.setItem(i3);
            this.getEntityManager().persist((Object)o9);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.\"ID\" AS \"OID\", o.\"TOTALPRICE\" AS \"OPRICE\", o.\"FK1_FOR_ITEM\" AS \"OITEM\", i.\"ITEMNAME\" AS \"INAME\" from \"ORDER1\" o, \"ITEM\" i WHERE (o.\"TOTALPRICE\" < 100) AND (o.\"FK1_FOR_ITEM\" = i.\"ID\")", "Order2ItemResults").getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)(" Did not get expected results.  Expected: 1, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                for (Object obj : q) {
                    Object[] objectArray;
                    if (!(obj instanceof Object[])) continue;
                    for (Object o : objectArray = (Object[])obj) {
                        if (o instanceof Order1) {
                            Order1 orderReturned = (Order1)o;
                            if (!orderReturned.equals((Object)o7)) {
                                TestUtil.logErr((String)("Expected:" + o7 + ", actual:" + orderReturned));
                            } else {
                                TestUtil.logTrace((String)"Received expected order");
                                ++passCounter;
                            }
                            if (orderReturned.getItem() != i1) {
                                TestUtil.logErr((String)("Expected:" + i1 + ", actual:" + orderReturned.getItem()));
                                continue;
                            }
                            TestUtil.logTrace((String)"Received expected item");
                            ++passCounter;
                            continue;
                        }
                        if (o instanceof String) {
                            String itemName = (String)o;
                            if (!itemName.equals(i1.getItemName())) {
                                TestUtil.logErr((String)("Expected:" + i1.getItemName() + ", actual:" + itemName));
                                continue;
                            }
                            TestUtil.logTrace((String)"Received expected itemName");
                            ++passCounter;
                            continue;
                        }
                        TestUtil.logErr((String)("Received unexpected object:" + o));
                    }
                }
            }
            if (passCounter == 3) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("nativeQueryTest2 failed");
        }
    }

    public void nativeQueryTest3() throws EETest.Fault {
        boolean pass = false;
        int passCounter = 0;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.\"ID\" AS \"THISID\", o.\"TOTALPRICE\" AS \"THISPRICE\", o.\"FK1_FOR_ITEM\" AS \"THISITEM\", i.\"ID\", i.\"ITEMNAME\" from \"ORDER1\" o, \"ITEM\" i WHERE (o.\"TOTALPRICE\" > 140) AND (o.\"FK1_FOR_ITEM\" = i.\"ID\")", "Order3ItemResults").getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)(" Did not get expected results.  Expected: 1, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                for (Object obj : q) {
                    Object[] objectArray;
                    if (!(obj instanceof Object[])) continue;
                    for (Object o : objectArray = (Object[])obj) {
                        if (o instanceof Order1) {
                            Order1 orderReturned = (Order1)o;
                            if (!orderReturned.equals((Object)o3)) {
                                TestUtil.logErr((String)("Expected:" + o3 + ", actual:" + orderReturned));
                            } else {
                                TestUtil.logTrace((String)"Received expected order");
                                ++passCounter;
                            }
                            if (orderReturned.getItem() != i3) {
                                TestUtil.logErr((String)("Expected:" + i3 + ", actual:" + orderReturned.getItem()));
                                continue;
                            }
                            TestUtil.logTrace((String)"Received expected item");
                            ++passCounter;
                            continue;
                        }
                        if (o instanceof Item) {
                            Item item = (Item)o;
                            if (item != i3) {
                                TestUtil.logErr((String)("Expected:" + i3 + ", actual:" + item));
                                continue;
                            }
                            TestUtil.logTrace((String)"Received expected item");
                            ++passCounter;
                            continue;
                        }
                        TestUtil.logErr((String)("Received unexpected object:" + o));
                    }
                }
            }
            if (passCounter == 3) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("nativeQueryTest3 failed");
        }
    }

    public void nativeQueryColumnResultTypeTest() throws EETest.Fault {
        boolean pass = false;
        int passCounter = 0;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(7, "Loafers");
            Item i2 = new Item(8, "High Heels");
            Item i3 = new Item(9, "Socks");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o7 = new Order1(7, 25.0);
            o7.setItem(i1);
            this.getEntityManager().persist((Object)o7);
            Order1 o8 = new Order1(8, 125.0);
            o8.setItem(i2);
            this.getEntityManager().persist((Object)o8);
            Order1 o9 = new Order1(9, 150.0);
            o9.setItem(i3);
            this.getEntityManager().persist((Object)o9);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.\"ID\" AS \"OID\", o.\"TOTALPRICE\" AS \"OPRICE\", o.\"FK1_FOR_ITEM\" AS \"OITEM\", i.\"ITEMNAME\" AS \"INAME\" from \"ORDER1\" o, \"ITEM\" i WHERE (o.\"TOTALPRICE\" < 100) AND (o.\"FK1_FOR_ITEM\" = i.\"ID\")", "Order4ItemResults").getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)(" Did not get expected results.  Expected: 1, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                for (Object obj : q) {
                    Object[] objectArray;
                    if (!(obj instanceof Object[])) continue;
                    for (Object o : objectArray = (Object[])obj) {
                        if (o instanceof Order1) {
                            Order1 orderReturned = (Order1)o;
                            if (!orderReturned.equals((Object)o7)) {
                                TestUtil.logErr((String)("Expected:" + o7 + ", actual:" + orderReturned));
                            } else {
                                TestUtil.logTrace((String)"Received expected order");
                                ++passCounter;
                            }
                            if (orderReturned.getItem() != i1) {
                                TestUtil.logErr((String)("Expected:" + i1 + ", actual:" + orderReturned.getItem()));
                                continue;
                            }
                            TestUtil.logTrace((String)"Received expected item");
                            ++passCounter;
                            continue;
                        }
                        if (o instanceof String) {
                            String itemName = (String)o;
                            if (!itemName.equals(i1.getItemName())) {
                                TestUtil.logErr((String)("Expected:" + i1.getItemName() + ", actual:" + itemName));
                                continue;
                            }
                            TestUtil.logTrace((String)"Received expected itemName");
                            ++passCounter;
                            continue;
                        }
                        TestUtil.logErr((String)("Received unexpected object:" + o));
                    }
                }
            }
            if (passCounter == 3) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("nativeQueryColumnResultTypeTest failed");
        }
    }

    public void nativeQueryTestConstructorResult() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(7, "Loafers");
            Item i2 = new Item(8, "High Heels");
            Item i3 = new Item(9, "Socks");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o7 = new Order1(7, 25.0);
            o7.setItem(i1);
            this.getEntityManager().persist((Object)o7);
            Order1 o8 = new Order1(8, 125.0);
            o8.setItem(i2);
            this.getEntityManager().persist((Object)o8);
            Order1 o9 = new Order1(9, 150.0);
            o9.setItem(i3);
            this.getEntityManager().persist((Object)o9);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.\"ID\" AS \"OID\", o.\"TOTALPRICE\" AS \"OPRICE\", i.\"ITEMNAME\" AS \"OITEMNAME\" from \"ORDER1\" o, \"ITEM\" i WHERE (o.\"TOTALPRICE\" < 100) AND (o.\"FK1_FOR_ITEM\" = i.\"ID\")", "Order5ItemResults").getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                Order2 o = (Order2)q.get(0);
                if (o.getId() == o7.getId()) {
                    if (o.getTotalPrice() == o7.getTotalPrice()) {
                        if (o.getItemName().equals(o7.getItem().getItemName())) {
                            pass = true;
                        } else {
                            TestUtil.logErr((String)("Expected:" + o7.getItem().getItemName() + ", actual:" + o.getItemName()));
                        }
                    } else {
                        TestUtil.logErr((String)("Expected:" + o7.getTotalPrice() + ", actual:" + o.getTotalPrice()));
                    }
                } else {
                    TestUtil.logErr((String)("Expected:" + o7.getId() + ", actual:" + o.getId()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("nativeQueryTestConstructorResult failed");
        }
    }

    public void nativeQueryTestConstructorResultWithId() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Purchase Orders");
            PurchaseOrder p1 = new PurchaseOrder(7, 25);
            this.getEntityManager().persist((Object)p1);
            PurchaseOrder p2 = new PurchaseOrder(8, 50);
            this.getEntityManager().persist((Object)p2);
            PurchaseOrder p3 = new PurchaseOrder(9, 75);
            this.getEntityManager().persist((Object)p3);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.\"ID\" AS \"OID\", o.\"TOTAL\" AS \"PTOTAL\" from \"PURCHASE_ORDER\" o WHERE (o.\"TOTAL\" < 50)", "PurchaseOrder1Results").getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                PurchaseOrder p = (PurchaseOrder)q.get(0);
                if (p.getId() == p1.getId()) {
                    if (p.getTotal() == p1.getTotal()) {
                        pass1 = true;
                    } else {
                        TestUtil.logErr((String)("Expected:" + p1.getTotal() + ", actual:" + p.getTotal()));
                    }
                } else {
                    TestUtil.logErr((String)("Expected: " + p1.getId() + ", actual:" + p.getId()));
                }
                if (!this.getEntityManager().contains((Object)p)) {
                    TestUtil.logMsg((String)"Entity contains id and is managed.");
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)"Entity contains an id and is not managed.");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("nativeQueryTestConstructorResultWithId failed");
        }
    }

    public void nativeQueryTestConstructorResultNoId() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Purchase Orders");
            PurchaseOrder p1 = new PurchaseOrder(7, 25);
            this.getEntityManager().persist((Object)p1);
            PurchaseOrder p2 = new PurchaseOrder(8, 50);
            this.getEntityManager().persist((Object)p2);
            PurchaseOrder p3 = new PurchaseOrder(9, 75);
            this.getEntityManager().persist((Object)p3);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.\"TOTAL\" AS \"PTOTAL\" from \"PURCHASE_ORDER\" o WHERE (o.\"TOTAL\" < 50)", "PurchaseOrder2Results").getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                PurchaseOrder p = (PurchaseOrder)q.get(0);
                if (p.getId() == 0) {
                    if (p.getTotal() == p1.getTotal()) {
                        pass1 = true;
                    } else {
                        TestUtil.logErr((String)("Expected:" + p1.getTotal() + ", actual:" + p.getTotal()));
                    }
                } else {
                    TestUtil.logErr((String)("Expected: 0, actual:" + p.getId()));
                }
                if (!this.getEntityManager().contains((Object)p)) {
                    TestUtil.logMsg((String)"Entity does not contain id and is detached.");
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)"Entity does not contain an id and is not detached.");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("nativeQueryTestConstructorResultNoId failed");
        }
    }

    public void createNativeQueryStringTest() throws EETest.Fault {
        boolean pass = false;
        List q = null;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(2);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            TestUtil.logTrace((String)"Execute Query");
            q = this.getEntityManager().createNativeQuery("Select o.\"ID\" from \"ORDER1\" o WHERE o.\"ID\" = 2 ").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Object o : q) {
                actual.add(this.convertToInt(o));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results");
                for (Integer i : expected) {
                    TestUtil.logErr((String)("expected:" + i));
                }
                for (Integer i : actual) {
                    TestUtil.logErr((String)("actual:" + i));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("createNativeQueryStringTest failed");
        }
    }

    public void createNativeQueryResultClassTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select * from \"ORDER1\" o WHERE o.\"ID\" = 2 ", Order1.class).getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)(" Did not get expected results.  Expected: 1, got: " + q.size()));
            } else {
                int id = ((Order1)q.get(0)).getId();
                if (id != 2) {
                    TestUtil.logErr((String)("id expected:2, actual:" + id));
                } else {
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("createNativeQueryResultClassTest failed");
        }
    }

    public void createNativeQueryResultClassTQTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select * from \"ORDER1\" o WHERE o.\"ID\" = 2 ", Order1.class).getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)(" Did not get expected results.  Expected: 1, got: " + q.size()));
            } else {
                int id = ((Order1)q.get(0)).getId();
                if (id != 2) {
                    TestUtil.logErr((String)("id expected:2, actual:" + id));
                } else {
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("createNativeQueryResultClassTQTest failed");
        }
    }

    public void executeUpdateTransactionRequiredExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityManager().createNativeQuery("Delete from \"ORDER1\"").executeUpdate();
            TestUtil.logErr((String)"TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException ise) {
            TestUtil.logTrace((String)"Received expected TransactionRequiredException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("executeUpdateTransactionRequiredExceptionTest failed");
        }
    }

    public void setParameterTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            TestUtil.logTrace((String)"Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select * from \"ORDER1\" o WHERE o.\"ID\" = ? ", Order1.class).setParameter(1, (Object)2).getResultList();
            if (q.size() != 1) {
                TestUtil.logErr((String)(" Did not get expected results.  Expected: 1, got: " + q.size()));
            } else {
                int id = ((Order1)q.get(0)).getId();
                if (id != 2) {
                    TestUtil.logErr((String)("id expected:2, actual:" + id));
                } else {
                    TestUtil.logTrace((String)"Received expected result");
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("setParameterTest failed");
        }
    }

    public void getSingleResultTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            TestUtil.logTrace((String)"Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            TestUtil.logTrace((String)"Execute Query");
            Object q = this.getEntityManager().createNativeQuery("Select COUNT(*) from \"ORDER1\" o").getSingleResult();
            int i = 0;
            i = this.convertToInt(q);
            if (i == 3) {
                TestUtil.logTrace((String)("Received expected result:" + i));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected: 3, actual:" + i));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getSingleResultTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete FROM ORDER2").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete FROM \"ORDER1\"").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete FROM \"ITEM\"").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete FROM \"PURCHASE_ORDER\"").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

