/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.parameter;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.criteriaapi.parameter.Employee;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class Client
extends PMClientBase {
    Employee[] empRef = new Employee[5];
    final Date d1 = this.getSQLDate("2000-02-14");

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupEmployee(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void parameterTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Starting parameterTest1");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        boolean pass8 = false;
        boolean pass9 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
        if (cquery != null) {
            String sExpected;
            Parameter p1;
            String sActual;
            Root employee = cquery.from(Employee.class);
            cquery.select((Selection)employee);
            ArrayList<Predicate> criteria = new ArrayList<Predicate>();
            ParameterExpression pe = qbuilder.parameter(String.class, "first");
            Class c = pe.getParameterType();
            if (c.isAssignableFrom(String.class)) {
                TestUtil.logTrace((String)"Received expected type from getParameterType()");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected type String from getParameterType(), instead got:" + c));
            }
            String name = pe.getName();
            if (name != null) {
                if (!name.equals("first")) {
                    TestUtil.logErr((String)("getName() returned wrong name, expected: first, actual:" + name));
                } else {
                    pass2 = true;
                }
            } else {
                TestUtil.logErr((String)"getName() returned null");
            }
            Integer position = pe.getPosition();
            if (position != null) {
                TestUtil.logErr((String)("getPosition() returned:" + position + ", instead of null"));
            } else {
                pass3 = true;
            }
            ParameterExpression pe2 = qbuilder.parameter(String.class, "last");
            criteria.add(qbuilder.equal((Expression)employee.get("firstName"), (Expression)pe));
            criteria.add(qbuilder.equal((Expression)employee.get("lastName"), (Expression)pe2));
            cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            if (TestUtil.traceflag) {
                ArrayList list = new ArrayList(q.getParameters());
                for (int i = 0; i < list.size(); ++i) {
                    Parameter p = (Parameter)list.get(i);
                    TestUtil.logTrace((String)("parameter name = " + p.getName()));
                    TestUtil.logTrace((String)("parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("parameter type =" + p.getParameterType()));
                }
            }
            if (!(sActual = (p1 = q.getParameter(sExpected = "first")).getName()).equals(sExpected)) {
                TestUtil.logErr((String)("p1.getName() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass4 = true;
            }
            sExpected = null;
            Integer iActual = p1.getPosition();
            if (iActual != null) {
                TestUtil.logErr((String)("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
            } else {
                pass5 = true;
            }
            sExpected = "java.lang.String";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass6 = true;
            }
            sExpected = "last";
            Parameter p2 = q.getParameter(sExpected);
            sActual = p2.getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p2.getName() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass7 = true;
            }
            sExpected = null;
            iActual = p2.getPosition();
            if (iActual != null) {
                TestUtil.logErr((String)("p2.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
            } else {
                pass8 = true;
            }
            sExpected = "java.lang.String";
            sActual = p2.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p2.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass9 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8 && pass9)) {
            throw new EETest.Fault("parameterTest1 test failed");
        }
    }

    public void parameterTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Starting parameterTest2");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
        if (cquery != null) {
            String sExpected;
            Parameter p1;
            String sActual;
            Root employee = cquery.from(Employee.class);
            cquery.select((Selection)employee);
            ArrayList<Predicate> criteria = new ArrayList<Predicate>();
            ParameterExpression pe = qbuilder.parameter(Float.class, "salary");
            criteria.add(qbuilder.equal((Expression)employee.get("salary"), (Expression)pe));
            cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            if (TestUtil.traceflag) {
                ArrayList list = new ArrayList(q.getParameters());
                for (int i = 0; i < list.size(); ++i) {
                    Parameter p = (Parameter)list.get(i);
                    TestUtil.logTrace((String)("parameter name = " + p.getName()));
                    TestUtil.logTrace((String)("parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("parameter type =" + p.getParameterType()));
                }
            }
            if (!(sActual = (p1 = q.getParameter(sExpected = "salary")).getName()).equals(sExpected)) {
                TestUtil.logErr((String)("p1.getName() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass1 = true;
            }
            sExpected = null;
            Integer iActual = p1.getPosition();
            if (iActual != null) {
                TestUtil.logErr((String)("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
            } else {
                pass2 = true;
            }
            sExpected = "java.lang.Float";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass3 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("parameterTest2 test failed");
        }
    }

    public void parameterTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Starting parameterTest3");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
        if (cquery != null) {
            String sExpected;
            Parameter p1;
            String sActual;
            Root employee = cquery.from(Employee.class);
            cquery.select((Selection)employee);
            ArrayList<Predicate> criteria = new ArrayList<Predicate>();
            ParameterExpression pe = qbuilder.parameter(Date.class, "hdate");
            criteria.add(qbuilder.equal((Expression)employee.get("hireDate"), (Expression)pe));
            cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            if (TestUtil.traceflag) {
                ArrayList list = new ArrayList(q.getParameters());
                for (int i = 0; i < list.size(); ++i) {
                    Parameter p = (Parameter)list.get(i);
                    TestUtil.logTrace((String)("parameter name = " + p.getName()));
                    TestUtil.logTrace((String)("parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("parameter type =" + p.getParameterType()));
                }
            }
            if (!(sActual = (p1 = q.getParameter(sExpected = "hdate")).getName()).equals(sExpected)) {
                TestUtil.logErr((String)("p1.getName() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass1 = true;
            }
            sExpected = null;
            Integer iActual = p1.getPosition();
            if (iActual != null) {
                TestUtil.logErr((String)("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
            } else {
                pass2 = true;
            }
            sExpected = "java.sql.Date";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass3 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("parameterTest3 test failed");
        }
    }

    public void parameterTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Starting parameterTest4");
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
        if (cquery != null) {
            Parameter p;
            int i;
            Root employee = cquery.from(Employee.class);
            cquery.select((Selection)employee);
            ArrayList<Predicate> criteria = new ArrayList<Predicate>();
            ParameterExpression pe = qbuilder.parameter(String.class);
            criteria.add(qbuilder.equal((Expression)employee.get("firstName"), (Expression)pe));
            cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            ArrayList list = new ArrayList(q.getParameters());
            if (TestUtil.traceflag) {
                for (i = 0; i < list.size(); ++i) {
                    p = (Parameter)list.get(i);
                    TestUtil.logTrace((String)("parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("parameter type =" + p.getParameterType()));
                }
            }
            for (i = 0; i < list.size(); ++i) {
                p = (Parameter)list.get(i);
                pass1 = true;
                String sExpected = null;
                Integer iActual = p.getPosition();
                if (iActual != null) {
                    TestUtil.logErr((String)("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
                }
                sExpected = "java.lang.String";
                String sActual = p.getParameterType().getName();
                if (sActual.equals(sExpected)) continue;
                TestUtil.logErr((String)("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("parameterTest4 test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupEmployee")
    public void parameterExpressionInObjectArrayTest() throws EETest.Fault {
        boolean pass = false;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[3].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            if (cquery != null) {
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee);
                ArrayList<Predicate> criteria = new ArrayList<Predicate>();
                ParameterExpression pe = qbuilder.parameter(Integer.class, "num");
                Object[] o = new Object[]{1, 2};
                criteria.add(pe.in(o));
                cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                q.setParameter("num", (Object)1);
                List result = q.getResultList();
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee e : result) {
                    actual.add(e.getId());
                }
                Collections.sort(actual);
                TestUtil.logTrace((String)("actual" + actual));
                if (expected.equals(actual)) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("expected: " + expected + ", actual: " + actual));
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        finally {
            this.removeTestData();
        }
        if (!pass) {
            throw new EETest.Fault("parameterExpressionInObjectArrayTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupEmployee")
    public void parameterExpressionInExpressionArrayTest() throws EETest.Fault {
        boolean pass = false;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[3].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            if (cquery != null) {
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee);
                ArrayList<Predicate> criteria = new ArrayList<Predicate>();
                ParameterExpression pe = qbuilder.parameter(String.class, "sid");
                Expression[] exp = new Expression[]{qbuilder.literal((Object)"1"), qbuilder.literal((Object)"2")};
                criteria.add(pe.in(exp));
                cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                q.setParameter("sid", (Object)"1");
                List result = q.getResultList();
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee e : result) {
                    actual.add(e.getId());
                }
                Collections.sort(actual);
                TestUtil.logTrace((String)("actual" + actual));
                if (expected.equals(actual)) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("expected: " + expected + ", actual: " + actual));
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        finally {
            this.removeTestData();
        }
        if (!pass) {
            throw new EETest.Fault("parameterExpressionInExpressionArrayTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupEmployee")
    public void parameterExpressionInCollectionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[3].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            if (cquery != null) {
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee);
                ArrayList<Predicate> criteria = new ArrayList<Predicate>();
                ParameterExpression pe = qbuilder.parameter(String.class, "sid");
                ArrayList<String> col = new ArrayList<String>();
                col.add("1");
                col.add("2");
                criteria.add(pe.in(col));
                cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                q.setParameter("sid", (Object)"1");
                List result = q.getResultList();
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee e : result) {
                    actual.add(e.getId());
                }
                Collections.sort(actual);
                TestUtil.logTrace((String)("actual" + actual));
                if (expected.equals(actual)) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("expected: " + expected + ", actual: " + actual));
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        finally {
            this.removeTestData();
        }
        if (!pass) {
            throw new EETest.Fault("parameterExpressionInCollectionTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupEmployee")
    public void parameterExpressionInExpressionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[3].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            if (cquery != null) {
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee);
                ArrayList<Predicate> criteria = new ArrayList<Predicate>();
                ParameterExpression pe = qbuilder.parameter(String.class, "sid");
                Expression exp = qbuilder.literal((Object)"1");
                criteria.add(pe.in(exp));
                cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                q.setParameter("sid", (Object)"1");
                List result = q.getResultList();
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee e : result) {
                    actual.add(e.getId());
                }
                Collections.sort(actual);
                TestUtil.logTrace((String)("actual" + actual));
                if (expected.equals(actual)) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("expected: " + expected + ", actual: " + actual));
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        finally {
            this.removeTestData();
        }
        if (!pass) {
            throw new EETest.Fault("parameterExpressionInExpressionTest test failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"calling super.cleanup");
        this.removeTestData();
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Employees");
            Date d2 = this.getSQLDate("2001-06-27");
            Date d3 = this.getSQLDate("2002-07-07");
            Date d4 = this.getSQLDate("2003-03-03");
            Date d5 = this.getSQLDate();
            this.empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                TestUtil.logTrace((String)("persisted employee:" + e));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

