/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IORASContextEntry
extends Entry {
    private int targetSupports;
    private int targetRequires;
    private byte[] clientAuthenticationMech;
    private byte[] targetName;

    public IORASContextEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("ior-as-context")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("target-supports")) {
                this.targetSupports = Integer.parseInt(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("target-requires")) {
                this.targetRequires = Integer.parseInt(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("client-authentication-mech")) {
                this.clientAuthenticationMech = IORASContextEntry.parseBinHex(this.getText(node));
                continue;
            }
            if (!node.getNodeName().equals("target-name")) continue;
            this.targetName = IORASContextEntry.parseBinHex(this.getText(node));
        }
    }

    public int getTargetSupports() {
        return this.targetSupports;
    }

    public int getTargetRequires() {
        return this.targetRequires;
    }

    public byte[] getTargetName() {
        return this.targetName;
    }

    public byte[] getClientAuthenticationMech() {
        return this.clientAuthenticationMech;
    }

    public String toString() {
        String result = "<ior-as-context>\n";
        result = result + "<target-supports>" + this.targetSupports + "</target-supports>\n";
        result = result + "<target-requires>" + this.targetRequires + "</target-requires>\n";
        result = result + "<client-authentication-mech>" + IORASContextEntry.binHex(this.clientAuthenticationMech) + "</client-authentication-mech>\n";
        result = result + "<target-name>" + IORASContextEntry.binHex(this.targetName) + "</target-name>\n";
        result = result + "</ior-as-context>\n";
        return result;
    }
}

