/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.instantiation;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.instantiation.model.CreatorPlusFactoryContainer;
import com.sun.ts.tests.jsonb.customizedmapping.instantiation.model.IllegalInstanceFactoryCreatorContainer;
import com.sun.ts.tests.jsonb.customizedmapping.instantiation.model.MultipleCreatorsContainer;
import com.sun.ts.tests.jsonb.customizedmapping.instantiation.model.MultipleFactoryCreatorsContainer;
import com.sun.ts.tests.jsonb.customizedmapping.instantiation.model.SimpleCreatorContainer;
import com.sun.ts.tests.jsonb.customizedmapping.instantiation.model.SimpleCreatorPlusFieldsContainer;
import com.sun.ts.tests.jsonb.customizedmapping.instantiation.model.SimpleCreatorRenameContainer;
import com.sun.ts.tests.jsonb.customizedmapping.instantiation.model.SimpleFactoryCreatorContainer;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;

public class InstantiationCustomizationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        InstantiationCustomizationTest t = new InstantiationCustomizationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void testCustomConstructor() throws EETest.Fault {
        SimpleCreatorContainer unmarshalledObject = (SimpleCreatorContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", SimpleCreatorContainer.class);
        if (!"Constructor String".equals(unmarshalledObject.getStringInstance()) || unmarshalledObject.getIntegerInstance() != 2 || unmarshalledObject.getFloatInstance() != 2.0f) {
            throw new EETest.Fault("Failed to instantiate type using JsonbCreator annotated constructor during unmarshalling.");
        }
    }

    public void testCustomConstructorPlusFields() throws EETest.Fault {
        SimpleCreatorPlusFieldsContainer unmarshalledObject = (SimpleCreatorPlusFieldsContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", SimpleCreatorPlusFieldsContainer.class);
        if (!"Constructor String".equals(unmarshalledObject.getStringInstance()) || unmarshalledObject.getIntegerInstance() != 2 || unmarshalledObject.getFloatInstance() != 1.0f) {
            throw new EETest.Fault("Failed to instantiate type using JsonbCreator annotated constructor and set remaining fields as normally during unmarshalling.");
        }
    }

    public void testFactoryMethod() throws EETest.Fault {
        SimpleFactoryCreatorContainer unmarshalledObject = (SimpleFactoryCreatorContainer)this.jsonb.fromJson("{ \"constructorString\" : \"Test String\" }", SimpleFactoryCreatorContainer.class);
        if (!"Factory String".equals(unmarshalledObject.getStringInstance()) || unmarshalledObject.getIntegerInstance() != 2 || unmarshalledObject.getFloatInstance() != 3.0f) {
            throw new EETest.Fault("Failed to instantiate type using JsonbCreator annotated method during unmarshalling.");
        }
    }

    public void testMultipleConstructors() throws EETest.Fault {
        try {
            this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", MultipleCreatorsContainer.class);
        }
        catch (JsonbException x) {
            return;
        }
        throw new EETest.Fault("A JsonbException is expected when unmarshalling to a class with multiple constructors annotated with JsonbCreator.");
    }

    public void testMultipleFactories() throws EETest.Fault {
        try {
            this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", MultipleFactoryCreatorsContainer.class);
        }
        catch (JsonbException x) {
            return;
        }
        throw new EETest.Fault("A JsonbException is expected when unmarshalling to a class with multiple methods annotated with JsonbCreator.");
    }

    public void testConstructorPlusFactory() throws EETest.Fault {
        try {
            this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", CreatorPlusFactoryContainer.class);
        }
        catch (JsonbException x) {
            return;
        }
        throw new EETest.Fault("A JsonbException is expected when unmarshalling to a class with multiple JsonbCreator annotation instances.");
    }

    public void testIllegalFactoryType() throws EETest.Fault {
        try {
            this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", IllegalInstanceFactoryCreatorContainer.class);
        }
        catch (JsonbException x) {
            return;
        }
        throw new EETest.Fault("A JsonbException is expected when unmarshalling to a class with a method annotated with JsonbCreator returning a type different than the class type.");
    }

    public void testRenamedProperty() throws EETest.Fault {
        SimpleCreatorRenameContainer unmarshalledObject = (SimpleCreatorRenameContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"intInstance\" : 1, \"floatInstance\" : 1.0 }", SimpleCreatorRenameContainer.class);
        if (!"Constructor String".equals(unmarshalledObject.getStringInstance()) || unmarshalledObject.getIntegerInstance() != 1 || unmarshalledObject.getFloatInstance() != 2.0f) {
            throw new EETest.Fault("Failed to instantiate type using JsonbCreator annotated constructor having a JsonbProperty annotated argument during unmarshalling.");
        }
    }

    public void testUnmappablePropertyName() throws EETest.Fault {
        try {
            SimpleCreatorContainer c = (SimpleCreatorContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", SimpleCreatorContainer.class);
            System.out.println(c);
        }
        catch (JsonbException x) {
            return;
        }
        throw new EETest.Fault("A JsonbException is expected when unmarshalling to a class with a constructor annotated with JsonbCreator and there exists an unmappable property name.");
    }
}

