/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.CallBack;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.TestBeanNoTx;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.TestBeanNoTxHome;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.TestBeanTx;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest.TestBeanTxHome;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.UserTransaction;

public class TestBeanEJB
implements SessionBean {
    private static final String txRequired = "java:comp/env/ejb/TxRequired";
    private static final String txRequiresNew = "java:comp/env/ejb/TxRequiresNew";
    private static final String txSupports = "java:comp/env/ejb/TxSupports";
    private static final String txMandatory = "java:comp/env/ejb/TxMandatory";
    private static final String txNotSupported = "java:comp/env/ejb/TxNotSupported";
    private static final String txNever = "java:comp/env/ejb/TxNever";
    private SessionContext sctx = null;
    private Properties harnessProps = null;
    private CallBack ref = null;
    private TSNamingContext nctx = null;
    private boolean ejbNewInstanceFlag = false;
    private boolean ejbSessionContextFlag = false;
    private boolean ejbCreateFlag = false;
    private boolean createLifeCycleFlag = true;
    private int createMethodCalled;
    private boolean beanManagedTransaction = false;
    private UserTransaction ut = null;

    public TestBeanEJB() {
        TestUtil.logTrace((String)"newInstance => default constructor called");
        this.ejbNewInstanceFlag = true;
        if (this.ejbSessionContextFlag || this.ejbCreateFlag) {
            this.createLifeCycleFlag = false;
        }
        if (this.ejbSessionContextFlag) {
            TestUtil.logErr((String)"newInstance() not called before setSessionContext()");
        }
        if (this.ejbCreateFlag) {
            TestUtil.logErr((String)"newInstance() not called before ejbCreate()");
        }
    }

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.ejbCreateFlag = true;
        if (!this.ejbNewInstanceFlag || !this.ejbSessionContextFlag) {
            this.createLifeCycleFlag = false;
        }
        if (!this.ejbNewInstanceFlag) {
            TestUtil.logErr((String)"newInstance() not called before ejbCreate()");
        }
        if (!this.ejbSessionContextFlag) {
            TestUtil.logErr((String)"setSessionContext() not called before ejbCreate()");
        }
        this.createMethodCalled = 1;
    }

    public void ejbCreate(CallBack r) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.ref = r;
        this.ejbCreateFlag = true;
        if (!this.ejbNewInstanceFlag || !this.ejbSessionContextFlag) {
            this.createLifeCycleFlag = false;
        }
        if (!this.ejbNewInstanceFlag) {
            TestUtil.logErr((String)"newInstance() not called before ejbCreate()");
        }
        if (!this.ejbSessionContextFlag) {
            TestUtil.logErr((String)"setSessionContext() not called before ejbCreate()");
        }
        this.createMethodCalled = 2;
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
        this.ejbSessionContextFlag = true;
        if (!this.ejbNewInstanceFlag || this.ejbCreateFlag) {
            this.createLifeCycleFlag = false;
        }
        if (!this.ejbNewInstanceFlag) {
            TestUtil.logErr((String)"newInstance() not called before setSessionContext()");
        }
        if (this.ejbCreateFlag) {
            TestUtil.logErr((String)"ejbCreate() called before setSessionContext()");
        }
        this.initNaming();
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (this.ref != null) {
                this.ref.setRemove(true);
            }
            this.reset();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ping() {
        TestUtil.logTrace((String)"ping");
    }

    public void setCallBack(CallBack r) {
        TestUtil.logTrace((String)"setCallBack");
        this.ref = r;
    }

    public boolean isCreateLifeCycle1() {
        TestUtil.logTrace((String)"isCreateLifeCycle1");
        boolean status = this.createLifeCycleFlag && this.createMethodCalled == 1;
        this.reset();
        return status;
    }

    public boolean isCreateLifeCycle2() {
        TestUtil.logTrace((String)"isCreateLifeCycle2");
        boolean status = this.createLifeCycleFlag && this.createMethodCalled == 2;
        this.reset();
        return status;
    }

    public boolean isSyncLifeCycle1(String tx) {
        TestUtil.logTrace((String)"isSyncLifeCycle1");
        String jndiName = this.getJndiName(tx);
        try {
            TestUtil.logMsg((String)("Looking up home interface for EJB: " + jndiName));
            TestBeanTxHome beanHome = (TestBeanTxHome)this.nctx.lookup(jndiName, TestBeanTxHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            TestBeanTx beanRef = beanHome.create(this.harnessProps);
            beanRef.syncTest(false);
            boolean result = beanRef.isSyncLifeCycle1(this.beanManagedTransaction);
            return result;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean isSyncLifeCycle2(String tx, boolean openConn, boolean b) {
        TestUtil.logTrace((String)"isSyncLifeCycle2");
        String jndiName = this.getJndiName(tx);
        try {
            TestUtil.logMsg((String)("Looking up home interface for EJB: " + jndiName));
            TestBeanTxHome beanHome = (TestBeanTxHome)this.nctx.lookup(jndiName, TestBeanTxHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            TestBeanTx beanRef = beanHome.create(this.harnessProps);
            if (!openConn) {
                beanRef.syncTest(true);
            } else {
                try {
                    beanRef.syncTestWithDbConnection(true, b);
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            boolean result = beanRef.isSyncLifeCycle2();
            if (openConn) {
                beanRef.dbUnConnect();
            }
            return result;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean isSyncLifeCycle3(String tx, boolean openConn, boolean b) {
        TestUtil.logTrace((String)"isSyncLifeCycle3");
        String jndiName = this.getJndiName(tx);
        try {
            TestUtil.logMsg((String)("Looking up home interface for EJB: " + jndiName));
            TestBeanTxHome beanHome = (TestBeanTxHome)this.nctx.lookup(jndiName, TestBeanTxHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            TestBeanTx beanRef = beanHome.create(this.harnessProps);
            if (!openConn) {
                beanRef.syncTest(true);
            } else {
                try {
                    beanRef.syncTestWithDbConnection(true, b);
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            boolean result = beanRef.isSyncLifeCycle3();
            if (openConn) {
                beanRef.dbUnConnect();
            }
            return result;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean noSyncLifeCycle(String tx) {
        TestUtil.logTrace((String)"noSyncLifeCycle");
        String jndiName = this.getJndiName(tx);
        try {
            TestUtil.logMsg((String)("Looking up home interface for EJB: " + jndiName));
            TestBeanTxHome beanHome = (TestBeanTxHome)this.nctx.lookup(jndiName, TestBeanTxHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            TestBeanTx beanRef = beanHome.create(this.harnessProps);
            return beanRef.noSyncLifeCycle();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean okay(String tx) {
        TestUtil.logTrace((String)"noSyncLifeCycle");
        String jndiName = this.getJndiName(tx);
        try {
            TestUtil.logMsg((String)("Looking up home interface for EJB: " + jndiName));
            TestBeanNoTxHome beanHome = (TestBeanNoTxHome)this.nctx.lookup(jndiName, TestBeanNoTxHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            TestBeanNoTx beanRef = beanHome.create(this.harnessProps);
            beanRef.okay();
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean not_okay(String tx) {
        TestUtil.logTrace((String)"noSyncLifeCycle");
        String jndiName = this.getJndiName(tx);
        try {
            TestUtil.logMsg((String)("Looking up home interface for EJB: " + jndiName));
            TestBeanNoTxHome beanHome = (TestBeanNoTxHome)this.nctx.lookup(jndiName, TestBeanNoTxHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            TestBeanNoTx beanRef = beanHome.create(this.harnessProps);
            try {
                beanRef.not_okay();
            }
            catch (TransactionRolledbackException e) {
                TestUtil.logMsg((String)"TransactionRolledbackException received as expected");
                return true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Unexpected exception: " + e), (Throwable)e);
                return false;
            }
            TestUtil.logErr((String)"No Exception");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean beginTransaction() {
        TestUtil.logTrace((String)"beginTransaction");
        try {
            this.ut = this.sctx.getUserTransaction();
            this.ut.begin();
            this.beanManagedTransaction = true;
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean commitTransaction() {
        TestUtil.logTrace((String)"commitTransaction");
        try {
            this.ut.commit();
            this.beanManagedTransaction = false;
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    private String getJndiName(String tx) {
        if (tx.equals("TxRequired")) {
            return txRequired;
        }
        if (tx.equals("TxRequiresNew")) {
            return txRequiresNew;
        }
        if (tx.equals("TxSupports")) {
            return txSupports;
        }
        if (tx.equals("TxNotSupported")) {
            return txNotSupported;
        }
        if (tx.equals("TxMandatory")) {
            return txMandatory;
        }
        if (tx.equals("TxNever")) {
            return txNever;
        }
        return null;
    }

    private void reset() {
        this.ejbSessionContextFlag = false;
        this.ejbCreateFlag = false;
        this.createLifeCycleFlag = true;
        this.createMethodCalled = 0;
    }

    private void initNaming() {
        try {
            TestUtil.logMsg((String)"obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
    }
}

