/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.objectMsgTopic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class ObjectMsgTopicTest
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.objectMsgTopic.ObjectMsgTopicTest";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        ObjectMsgTopicTest theTests = new ObjectMsgTopicTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void messageObjectCopyTopicTest() throws EETest.Fault {
        boolean pass = true;
        try {
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            StringBuffer sBuff = new StringBuffer("This is");
            String initial = "This is";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)sBuff);
            sBuff.append("a test ");
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageObjectCopyTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logMsg("Ensure that changing the object did not change the message");
            StringBuffer s = (StringBuffer)messageReceivedObjectMsg.getObject();
            this.logTrace("s is " + s);
            if (s.toString().equals(initial)) {
                this.logTrace("Pass: msg was not changed");
            } else {
                this.logTrace("Fail: msg was changed!");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("messageObjectCopyTopicTest");
        }
    }
}

