/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.ac_ssl_sslr_upn_noid.forward;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.CSIv2AppClient;
import com.sun.ts.tests.interop.csiv2.common.CSIv2Log;
import com.sun.ts.tests.interop.csiv2.common.validation.CSIv2LogValidator;
import com.sun.ts.tests.interop.csiv2.common.validation.RequestValidationStrategy;
import java.util.ArrayList;
import java.util.Properties;

public class Client
extends EETest {
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"setup...");
        this.props = p;
    }

    public void ac_ssl_sslr_upn_noid_sb_testid0() throws EETest.Fault {
        boolean pass = true;
        String testName = "ac_ssl_sslr_upn_noid_sb_testid0";
        TestUtil.logMsg((String)testName);
        try {
            TSLoginContext clc = new TSLoginContext();
            clc.login(this.props.getProperty("certLoginUserAlias"), System.getProperty("javax.net.ssl.keyStore"), System.getProperty("javax.net.ssl.keyStorePassword"));
        }
        catch (Exception e) {
            TestUtil.logMsg((String)e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " TSCertLogin failed");
        }
        CSIv2Log log = CSIv2Log.getLog();
        log.purge();
        log.enableLoggingInterceptor(false, true);
        log.startLog();
        log.logStartAssertion(testName);
        ArrayList<String> chain = new ArrayList<String>();
        chain.add("java:comp/env/ejb/RemoteSession");
        TestUtil.logMsg((String)"Client initiated.");
        CSIv2AppClient appClient = new CSIv2AppClient();
        TestUtil.logMsg((String)"AppClient (VI) ====> RemoteSessionBean (RI).");
        appClient.invoke(chain, this.props);
        TestUtil.logMsg((String)"Client completed.");
        log.logEndAssertion();
        log.endLog();
        log.enableLoggingInterceptor(false, false);
        String logContents = log.getLogContents();
        TestUtil.logMsg((String)"Log contents:");
        TestUtil.logMsg((String)logContents);
        log.purge();
        pass = CSIv2LogValidator.validate(testName, logContents, null, new RequestValidationStrategy(true, false, false, 1), null);
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup...");
    }
}

