/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.FloatWrapperHolder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.xml.rpc.holders.FloatWrapperHolder;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private static final Float myFloat1 = new Float(Float.MIN_VALUE);
    private static final Float myFloat2 = new Float(Float.MAX_VALUE);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void FloatWrapperHolderConstructorTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"FloatWrapperHolderConstructorTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via FloatWrapperHolder() ...");
            FloatWrapperHolder n = new FloatWrapperHolder();
            if (n != null) {
                TestUtil.logMsg((String)"FloatWrapperHolder object created successfully");
            } else {
                TestUtil.logErr((String)"FloatWrapperHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("FloatWrapperHolderConstructorTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("FloatWrapperHolderConstructorTest1 failed");
        }
    }

    public void FloatWrapperHolderConstructorTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"FloatWrapperHolderConstructorTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via FloatWrapperHolder(Float) ...");
            FloatWrapperHolder n = new FloatWrapperHolder(myFloat1);
            if (n != null) {
                TestUtil.logMsg((String)"FloatWrapperHolder object created successfully");
            } else {
                TestUtil.logErr((String)"FloatWrapperHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("FloatWrapperHolderConstructorTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("FloatWrapperHolderConstructorTest2 failed");
        }
    }

    public void getValueTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest");
        boolean pass = true;
        if (!this.getValueTest1()) {
            pass = false;
        }
        if (!this.getValueTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getValueTest failed");
        }
    }

    private boolean getValueTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via FloatWrapperHolder() ...");
            FloatWrapperHolder n = new FloatWrapperHolder();
            if (n != null) {
                Float v = n.value;
                if (v == null) {
                    TestUtil.logMsg((String)"Value set to null as expected");
                } else {
                    TestUtil.logErr((String)("Value: expected - null, received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"FloatWrapperHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean getValueTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via FloatWrapperHolder(Float) ...");
            FloatWrapperHolder n = new FloatWrapperHolder(myFloat1);
            if (n != null) {
                Float v = n.value;
                if (v.equals(myFloat1)) {
                    TestUtil.logMsg((String)("Value set as expected to " + myFloat1));
                } else {
                    TestUtil.logErr((String)("Value: expected - " + myFloat1 + ", received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"FloatWrapperHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

