/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonobjecttests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class CreateObjectBuilder {
    CreateObjectBuilder() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonObjectBuilder API factory methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonObjectBuilder API factory methods added in JSON-P 1.1.");
        this.testCreateFromMap(result);
        this.testCreateFromJsonObject(result);
        return result;
    }

    private void testCreateFromMap(TestResult result) {
        TestUtil.logMsg((String)" - Json#createObjectBuilder(Map<String,Object>)");
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        HashMap<String, String> values = new HashMap<String, String>(2);
        values.put("name", "John Smith");
        values.put("address", "In a galaxy far far away");
        JsonObjectBuilder builder = Json.createObjectBuilder(values);
        JsonObject out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("createObjectBuilder(Map<String,Object>)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void testCreateFromJsonObject(TestResult result) {
        TestUtil.logMsg((String)" - Json#createObjectBuilder(JsonObject)");
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        JsonObjectBuilder builder = Json.createObjectBuilder((JsonObject)check);
        JsonObject out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("reateObjectBuilder(JsonObject)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

