/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.webservice.wscontext;

import java.security.Principal;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;

@WebService(name="Hello", serviceName="HelloService")
@Stateless
@DeclareRoles(value={"Administrator"})
public class HelloImpl {
    @Resource
    private WebServiceContext wsContext;

    @RolesAllowed(value={"Administrator"})
    public String sayHelloProtected(String param) throws WebServiceException {
        String output = "";
        MessageContext msgContext = this.wsContext.getMessageContext();
        if (!(msgContext instanceof MessageContext)) {
            throw new WebServiceException("MessageContext not an instance of javax.xml.ws.handler.MessageContext");
        }
        output = output + " 1. MessageContext is an instance of javax.xml.ws.handler.MessageContext ";
        Principal invocationPrincipal = this.wsContext.getUserPrincipal();
        String principalName = invocationPrincipal.getName();
        if (invocationPrincipal == null) {
            throw new WebServiceException("UnExpected user principal");
        }
        output = output + " 2. Web Service invoked by user " + principalName;
        if (!this.wsContext.isUserInRole("Administrator")) {
            throw new WebServiceException("User not in role Administrator");
        }
        output = output + " 3. User j2ee is in role Administrator ";
        return "Hello " + param + output;
    }
}

