/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.sec.ejb.basicSSL;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices.sec.ejb.basicSSL.HelloBasic;
import com.sun.ts.tests.webservices.sec.ejb.basicSSL.HelloUnprotected;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private TSURL ctsurl = new TSURL();
    private String hostname = "localhost";
    private String PROTOCOLSECURE = "https";
    private String PROTOCOL = "http";
    private String urlString = null;
    private int portnumSecure = 1044;
    private int portnum = 8000;
    private static final String ENDPOINTURL = "HelloBasic/ejb";
    private static final String ENDPOINTURLUNPROTECTED = "HelloUnprotected/ejb";
    Service unprotectedService;
    HelloUnprotected unprotectedPort;
    Service basicNoIdService;
    HelloBasic basicNoIdPort;
    Service basicAuthorizedIdService;
    HelloBasic basicAuthorizedIdPort;
    Service basicUnauthorizedIdService;
    HelloBasic basicUnauthorizedIdPort;
    Service basicInvalidIdService;
    HelloBasic basicInvalidIdPort;
    InitialContext ctx;
    String vehicle = null;

    private void getStub() throws Exception {
        this.ctx = new InitialContext();
        TestUtil.logMsg((String)"JNDI lookup for Unprotected Service");
        this.unprotectedService = (Service)this.ctx.lookup("java:comp/env/service/secEjb/unprotected");
        TestUtil.logMsg((String)"Get port from unprotected Service");
        this.unprotectedPort = (HelloUnprotected)this.unprotectedService.getPort(HelloUnprotected.class);
        TestUtil.logMsg((String)"unprotected port obtained");
        Stub stub = (Stub)this.unprotectedPort;
        this.urlString = this.ctsurl.getURLString(this.PROTOCOL, this.hostname, this.portnum, ENDPOINTURLUNPROTECTED);
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.urlString);
        TestUtil.logMsg((String)"JNDI lookup for basicNoIdService");
        this.basicNoIdService = (Service)this.ctx.lookup("java:comp/env/service/secEjb/basicNoId");
        TestUtil.logMsg((String)"Get basicNoIdPort");
        this.basicNoIdPort = (HelloBasic)this.basicNoIdService.getPort(HelloBasic.class);
        TestUtil.logMsg((String)"basicNoIdPort obtained");
        TestUtil.logMsg((String)"JNDI lookup for basicNoIdService");
        stub = (Stub)this.basicNoIdPort;
        this.urlString = this.ctsurl.getURLString(this.PROTOCOLSECURE, this.hostname, this.portnumSecure, ENDPOINTURL);
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.urlString);
        TestUtil.logMsg((String)"JNDI lookup for basicAuthorizedIdService");
        this.basicAuthorizedIdService = (Service)this.ctx.lookup("java:comp/env/service/secEjb/basicAuthorizedId");
        TestUtil.logMsg((String)"Get basicAuthorizedIdPort");
        this.basicAuthorizedIdPort = (HelloBasic)this.basicAuthorizedIdService.getPort(HelloBasic.class);
        TestUtil.logMsg((String)"basicAuthorizedIdPort obtained");
        stub = (Stub)this.basicAuthorizedIdPort;
        this.urlString = this.ctsurl.getURLString(this.PROTOCOLSECURE, this.hostname, this.portnumSecure, ENDPOINTURL);
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.urlString);
        TestUtil.logMsg((String)"JNDI lookup for basicUnauthorizedIdService");
        this.basicUnauthorizedIdService = (Service)this.ctx.lookup("java:comp/env/service/secEjb/basicUnauthorizedId");
        TestUtil.logMsg((String)"Get basicUnauthorizedIdPort");
        this.basicUnauthorizedIdPort = (HelloBasic)this.basicUnauthorizedIdService.getPort(HelloBasic.class);
        TestUtil.logMsg((String)"basicUnauthorizedIdPort obtained");
        stub = (Stub)this.basicUnauthorizedIdPort;
        this.urlString = this.ctsurl.getURLString(this.PROTOCOLSECURE, this.hostname, this.portnumSecure, ENDPOINTURL);
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.urlString);
        TestUtil.logMsg((String)"JNDI lookup for basicInvalidIdService");
        this.basicInvalidIdService = (Service)this.ctx.lookup("java:comp/env/service/secEjb/basicInvalidId");
        TestUtil.logMsg((String)"Get basicInvalidIdPort");
        this.basicInvalidIdPort = (HelloBasic)this.basicInvalidIdService.getPort(HelloBasic.class);
        TestUtil.logMsg((String)"basicInvalidIdPort obtained");
        stub = (Stub)this.basicInvalidIdPort;
        this.urlString = this.ctsurl.getURLString(this.PROTOCOLSECURE, this.hostname, this.portnumSecure, ENDPOINTURL);
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.urlString);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnumSecure = Integer.parseInt(p.getProperty("securedWebServicePort"));
            this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            this.getStub();
            this.vehicle = p.getProperty("vehicle");
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void printSeperationLine() {
        TestUtil.logMsg((String)"---------------------------");
    }

    public void secEjbUnprotected() throws EETest.Fault {
        TestUtil.logMsg((String)"SecEjbUnprotected");
        try {
            String ret1 = this.unprotectedPort.sayHelloUnprotected("secEjbUnprotected");
            if (!ret1.equals("'secEjbUnprotected' from HelloUnprotected!")) {
                TestUtil.logMsg((String)("test SecEjbUnprotected failed: return value from first implementationis: " + ret1));
                throw new EETest.Fault("SecEjbUnprotected failed");
            }
            TestUtil.logMsg((String)"SecEjbUnprotected passed");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecEjbUnprotected failed: got exception " + t.toString()));
            throw new EETest.Fault("SecEjbUnprotected failed");
        }
    }

    public void secEjbBasicNoId() throws EETest.Fault {
        TestUtil.logMsg((String)"SecEjbBasicNoId");
        try {
            if (this.vehicle.equals("appclient")) {
                TestUtil.logMsg((String)"Skipping secEjbBasicNoId test for appclient vehicle");
                return;
            }
            String ret1 = this.basicNoIdPort.sayHelloBasic("secEjbBasicNoId");
            TestUtil.logMsg((String)("SecEjbBasicNoId failed: unexpected return value " + ret1));
            throw new EETest.Fault("SecEjbBasicNoId failed");
        }
        catch (RemoteException ex) {
            TestUtil.logMsg((String)"SecEjbBasicNoId success: got RemoteException");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecEjbBasicNoId failed: got exception " + t.toString()));
            throw new EETest.Fault("SecEjbBasicNoId failed");
        }
    }

    public void secEjbBasicUnauthorizedId() throws EETest.Fault {
        TestUtil.logMsg((String)"SecEjbBasicUnauthorizedId");
        try {
            String ret1 = this.basicUnauthorizedIdPort.sayHelloBasic("secEjbBasicUnauthorizedId");
            TestUtil.logMsg((String)("SecEjbBasicUnauthorizedId failed: unexpected return value " + ret1));
            throw new EETest.Fault("SecEjbBasicUnauthorizedId failed");
        }
        catch (RemoteException ex) {
            TestUtil.logMsg((String)"SecEjbBasicUnauthorizedId success: got RemoteException");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecEjbBasicUnauthorizedId failed: got exception " + t.toString()));
            throw new EETest.Fault("SecEjbBasicUnauthorizedId failed");
        }
    }

    public void secEjbBasicInvalidId() throws EETest.Fault {
        TestUtil.logMsg((String)"SecEjbBasicInvalidId");
        try {
            if (this.vehicle.equals("appclient")) {
                TestUtil.logMsg((String)"Skipping secEjbBasicInvalidId test for appclient vehicle");
                return;
            }
            String ret1 = this.basicInvalidIdPort.sayHelloBasic("secEjbBasicInvalidId");
            TestUtil.logMsg((String)("SecEjbBasicInvalidId failed: unexpected return value " + ret1));
            throw new EETest.Fault("SecEjbBasicInvalidId failed");
        }
        catch (RemoteException ex) {
            TestUtil.logMsg((String)"SecEjbBasicInvalidId success: got RemoteException");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecEjbBasicInvalidId failed: got exception " + t.toString()));
            throw new EETest.Fault("SecEjbBasicInvalidId failed");
        }
    }

    public void secEjbBasicAuthorizedId() throws EETest.Fault {
        TestUtil.logMsg((String)"SecEjbBasicAuthorizedId");
        try {
            String ret1 = this.basicAuthorizedIdPort.sayHelloBasic("secEjbBasicAuthorizedId");
            if (!ret1.equals("'secEjbBasicAuthorizedId' from HelloBasic!")) {
                TestUtil.logMsg((String)("test secEjbBasicAuthorized failed: return value: " + ret1));
                throw new EETest.Fault("SecEjbBasicAuthorized failed");
            }
            TestUtil.logMsg((String)"SecEjbBasicAuthorizedId passed");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecEjbBasicAuthorizedId failed: got exception " + t.toString()));
            throw new EETest.Fault("SecEjbBasicAuthorizedId failed");
        }
    }
}

