/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import javax.batch.api.listener.AbstractStepListener;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ThreadTrackingStepListener
extends AbstractStepListener {
    @Inject
    private JobContext jobCtx = null;

    public void beforeStep() throws Exception {
        Thread t = (Thread)this.jobCtx.getTransientUserData();
        if (t == null) {
            throw new IllegalStateException("In beforeStep() expected job listener to have already set this.  Are we not on the same thread?");
        }
        if (!t.equals(Thread.currentThread())) {
            throw new IllegalStateException("Current thread = " + Thread.currentThread().toString() + ", but in transient data found " + t);
        }
    }

    public void afterStep() throws Exception {
        Thread t = (Thread)this.jobCtx.getTransientUserData();
        if (t == null) {
            throw new IllegalStateException("In afterStep() expected job listener to have already set this.  Are we not on the same thread?");
        }
        if (!t.equals(Thread.currentThread())) {
            throw new IllegalStateException("Current thread = " + Thread.currentThread().toString() + ", but in transient data found " + t);
        }
        this.jobCtx.setTransientUserData(null);
    }
}

