/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.ContextService;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.ContextService.TestRunnableWork;
import com.sun.ts.tests.concurrency.api.ContextService.TestWorkInterface;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.concurrent.ContextService;
import javax.enterprise.concurrent.ManagedTaskListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Client
extends ServiceEETest
implements Serializable {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
    }

    public void ContextServiceWithIntf() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            Runnable proxy = (Runnable)cs.createContextualProxy((Object)new TestRunnableWork(), Runnable.class);
            pass = true;
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithIntf failed");
        }
    }

    public void ContextServiceWithIntfAndIntfNoImplemented() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            Object object = cs.createContextualProxy(new Object(), new Class[]{Runnable.class});
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithIntfAndIntfNoImplemented failed");
        }
    }

    public void ContextServiceWithIntfAndInstanceIsNull() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            Object proxy = cs.createContextualProxy(null, Runnable.class);
            TestUtil.logTrace((String)proxy.toString());
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithIntfAndInstanceIsNull failed");
        }
    }

    public void ContextServiceWithMultiIntfs() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            Object proxy = cs.createContextualProxy((Object)new TestRunnableWork(), new Class[]{Runnable.class, TestWorkInterface.class});
            pass = proxy instanceof Runnable && proxy instanceof TestWorkInterface;
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithMultiIntfs failed");
        }
    }

    public void ContextServiceWithMultiIntfsAndIntfNoImplemented() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            Object object = cs.createContextualProxy((Object)new TestRunnableWork(), new Class[]{Runnable.class, TestWorkInterface.class, ManagedTaskListener.class});
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithMultiIntfsAndIntfNoImplemented failed");
        }
    }

    public void ContextServiceWithMultiIntfsAndInstanceIsNull() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            Object proxy = cs.createContextualProxy(null, new Class[]{Runnable.class, TestWorkInterface.class});
            TestUtil.logTrace((String)proxy.toString());
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithMultiIntfsAndInstanceIsNull failed");
        }
    }

    public void ContextServiceWithIntfAndProperties() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Runnable proxy = (Runnable)cs.createContextualProxy((Object)new TestRunnableWork(), execProps, Runnable.class);
            pass = true;
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithIntfAndProperties failed");
        }
    }

    public void ContextServiceWithMultiIntfsAndProperties() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = cs.createContextualProxy((Object)new TestRunnableWork(), execProps, new Class[]{Runnable.class, TestWorkInterface.class});
            pass = proxy instanceof Runnable && proxy instanceof TestWorkInterface;
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithMultiIntfsAndProperties failed");
        }
    }

    public void ContextServiceWithIntfAndPropertiesAndIntfNoImplemented() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object object = cs.createContextualProxy((Object)new TestRunnableWork(), execProps, new Class[]{Runnable.class, ManagedTaskListener.class});
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithIntfAndPropertiesAndIntfNoImplemented failed");
        }
    }

    public void ContextServiceWithIntfsAndPropertiesAndInstanceIsNull() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = cs.createContextualProxy(null, execProps, Runnable.class);
            TestUtil.logTrace((String)proxy.toString());
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithIntfsAndPropertiesAndInstanceIsNull failed");
        }
    }

    public void ContextServiceWithMultiIntfsAndPropertiesAndIntfNoImplemented() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object object = cs.createContextualProxy((Object)new TestRunnableWork(), execProps, new Class[]{Runnable.class, TestWorkInterface.class, ManagedTaskListener.class});
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithMultiIntfsAndPropertiesAndIntfNoImplemented failed");
        }
    }

    public void ContextServiceWithMultiIntfsAndPropertiesAndInstanceIsNull() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = cs.createContextualProxy(null, execProps, new Class[]{Runnable.class, TestWorkInterface.class});
            TestUtil.logTrace((String)proxy.toString());
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ContextServiceWithMultiIntfsAndPropertiesAndInstanceIsNull failed");
        }
    }

    public void GetExecutionProperties() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = cs.createContextualProxy((Object)new TestRunnableWork(), execProps, new Class[]{Runnable.class, TestWorkInterface.class});
            Map returnedExecProps = cs.getExecutionProperties(proxy);
            if (!"true".equals(returnedExecProps.get("USE_PARENT_TRANSACTION"))) {
                TestUtil.logErr((String)("Expected:true, actual message=" + (String)returnedExecProps.get("USE_PARENT_TRANSACTION")));
            } else {
                pass = true;
            }
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("GetExecutionProperties failed");
        }
    }

    public void GetExecutionPropertiesNoProxy() throws EETest.Fault {
        boolean pass = false;
        try {
            InitialContext ctx = new InitialContext();
            ContextService cs = (ContextService)ctx.lookup("java:comp/DefaultContextService");
            Map returnedExecProps = cs.getExecutionProperties(new Object());
            pass = true;
        }
        catch (NamingException ne) {
            TestUtil.logErr((String)("Failed to lookup default ContextService" + ne));
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("GetExecutionPropertiesNoProxy failed");
        }
    }
}

