/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.EstablishContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.InvalidMessageEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestServiceContextEntry
extends Entry {
    private boolean present;
    private InvalidMessageEntry invalidMessage;
    private EstablishContextEntry establishContext;

    public boolean isPresent() {
        return this.present;
    }

    public InvalidMessageEntry getInvalidMessage() {
        return this.invalidMessage;
    }

    public RequestServiceContextEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("req-svc-context")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        this.present = element.getAttribute("present").equals("true");
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("establish-context")) {
                this.establishContext = new EstablishContextEntry((Element)node);
                continue;
            }
            if (!node.getNodeName().equals("invalid-message")) continue;
            this.invalidMessage = new InvalidMessageEntry((Element)node);
        }
    }

    public EstablishContextEntry getEstablishContext() {
        return this.establishContext;
    }

    public String toString() {
        String result;
        if (this.present) {
            result = "<req-svc-context present=\"true\">\n";
            if (this.establishContext != null) {
                result = result + this.establishContext.toString();
            } else if (this.invalidMessage != null) {
                result = result + this.invalidMessage.toString();
            }
            result = result + "</req-svc-context>\n";
        } else {
            result = "<req-svc-context present=\"false\"/>\n";
        }
        return result;
    }
}

