/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.packaging.ejb.resource_local;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.ee.common.A;
import com.sun.ts.tests.jpa.ee.packaging.ejb.resource_local.Stateless3IF;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;

@Stateless(name="Stateless3Bean")
@Remote(value={Stateless3IF.class})
public class Stateless3Bean
implements Stateless3IF {
    public SessionContext sessionContext;
    private EntityManagerFactory emf;
    private EntityManager entityManager;
    private EntityTransaction entityTransaction;
    private Map thisMap = new HashMap();
    private static final String thisEMF = "java:comp/env/persistence/ThisPersistenceUnit";

    public void cleanupEM() {
        try {
            if (this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)("IllegalStateException caught during entityManager.close()" + ise));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected exception caught during cleanupEM method" + e));
        }
    }

    @Override
    public void removeTestData() {
        try {
            this.getEntityTransaction().begin();
            this.entityManager.createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught while cleaning up:", (Throwable)e);
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        finally {
            this.cleanupEM();
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.emf.getCache().evictAll();
        TestUtil.logTrace((String)"cleanup complete");
    }

    @Override
    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @PostConstruct
    public void prepareEnvironment() {
        try {
            TestUtil.logTrace((String)"In PostContruct");
            TestUtil.logTrace((String)"Obtain naming context");
            TSNamingContext nctx = new TSNamingContext();
            if (this.emf == null) {
                this.emf = (EntityManagerFactory)nctx.lookup(thisEMF);
            }
            if (this.emf != null) {
                TestUtil.logTrace((String)"EMF is not null, create Entity Manager");
                this.entityManager = this.emf.createEntityManager(this.thisMap);
                if (this.entityManager == null) {
                    TestUtil.logErr((String)"EntityManager is null!");
                }
            } else {
                TestUtil.logErr((String)"EntityManagerFactory is null!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"In PostConstruct: Exception caught during init", (Throwable)e);
        }
    }

    protected EntityTransaction getEntityTransaction() {
        if (!this.entityManager.isOpen()) {
            this.entityManager = this.emf.createEntityManager(this.thisMap);
        }
        return this.entityManager.getTransaction();
    }

    @Override
    public boolean test1() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            pass = this.entityTransaction.isActive();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test2() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            if (this.entityTransaction.isActive()) {
                this.entityTransaction.begin();
            }
        }
        catch (IllegalStateException iae) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught:", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test3() {
        boolean pass = false;
        try {
            A newA = new A("3", "test3", 3);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.entityManager.persist((Object)newA);
            this.entityTransaction.commit();
            this.entityTransaction.begin();
            A modifiedA = (A)this.entityManager.find(A.class, (Object)"3");
            if (null != modifiedA && modifiedA.getName().equals("test3")) {
                modifiedA.setName("test3Modified");
            }
            this.entityManager.merge((Object)modifiedA);
            this.entityTransaction.commit();
            A committedA = (A)this.entityManager.find(A.class, (Object)"3");
            if (committedA.getName().equals("test3Modified")) {
                pass = true;
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test4() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            if (!this.entityTransaction.isActive()) {
                this.entityTransaction.commit();
            }
        }
        catch (IllegalStateException iae) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected in test4");
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test5() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            A newA = new A("5", "test5", 5);
            this.entityTransaction.begin();
            this.entityManager.persist((Object)newA);
            this.entityTransaction.setRollbackOnly();
            this.entityTransaction.commit();
        }
        catch (RollbackException re) {
            TestUtil.logTrace((String)"RollbackException Caught as Expected");
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test6() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            A newA = new A("6", "test6", 6);
            this.entityTransaction.begin();
            this.entityManager.persist((Object)newA);
            this.entityTransaction.commit();
            this.entityTransaction.begin();
            A modifiedA = (A)this.entityManager.find(A.class, (Object)"6");
            if (null != modifiedA && modifiedA.getName().equals("test6")) {
                modifiedA.setName("test6Modified");
            }
            this.entityManager.merge((Object)modifiedA);
            this.entityTransaction.rollback();
            A rolledBackA = (A)this.entityManager.find(A.class, (Object)"6");
            if (rolledBackA.getName().equals("test6")) {
                pass = true;
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test7() {
        boolean pass = false;
        try {
            A newA = new A("7", "test7", 7);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.entityManager.persist((Object)newA);
            this.entityTransaction.setRollbackOnly();
            if (this.entityTransaction.isActive() && this.entityTransaction.getRollbackOnly()) {
                pass = true;
            }
            this.entityTransaction.rollback();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test8() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            if (!this.entityTransaction.isActive()) {
                this.entityTransaction.setRollbackOnly();
                pass = true;
            }
        }
        catch (IllegalStateException iae) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test9() {
        boolean pass = false;
        try {
            A newA = new A("9", "test9", 9);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.entityManager.persist((Object)newA);
            this.entityTransaction.setRollbackOnly();
            if (this.entityTransaction.isActive() && this.entityTransaction.getRollbackOnly()) {
                pass = true;
            }
            this.entityTransaction.rollback();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test10() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            if (!this.entityTransaction.isActive()) {
                this.entityTransaction.getRollbackOnly();
            }
        }
        catch (IllegalStateException iae) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught in test10", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test11() {
        boolean pass = false;
        try {
            A newA = new A("11", "test11", 11);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.entityManager.persist((Object)newA);
            if (this.entityTransaction.isActive() && !this.entityTransaction.getRollbackOnly()) {
                pass = true;
            }
            this.entityTransaction.rollback();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test12() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            pass = this.entityTransaction.isActive();
            this.entityTransaction.rollback();
        }
        catch (PersistenceException e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected PersistenceException Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected PersistenceException rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    @Override
    public boolean test13() {
        boolean pass = false;
        try {
            this.entityTransaction = this.getEntityTransaction();
            pass = !this.entityTransaction.isActive();
        }
        catch (PersistenceException e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected PersistenceException Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected PersistenceException rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test14() {
        boolean pass = false;
        try {
            A newA = new A("14", "test14", 14);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            this.entityManager.persist((Object)newA);
            this.entityTransaction.commit();
            A newA2 = new A("14", "test14_2", 14);
            this.entityTransaction = this.getEntityTransaction();
            this.entityTransaction.begin();
            try {
                this.entityManager.persist((Object)newA2);
                this.entityManager.flush();
            }
            catch (Exception ex) {
                TestUtil.logTrace((String)"newA2 has the same PK as newA");
                pass = this.entityTransaction.getRollbackOnly();
            }
            this.entityTransaction.rollback();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        finally {
            try {
                if (this.entityTransaction.isActive()) {
                    this.entityTransaction.rollback();
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected PersistenceException rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test15() {
        boolean pass = false;
        EntityTransaction et = null;
        if (!this.entityManager.isOpen()) {
            this.entityManager = this.emf.createEntityManager(this.thisMap);
        }
        try {
            this.entityManager.close();
            if (!this.entityManager.isOpen()) {
                et = this.entityManager.getTransaction();
            }
            if (et != null) {
                pass = true;
            }
        }
        catch (IllegalStateException ise) {
            pass = false;
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)ise);
        }
        finally {
            try {
                if (et != null) {
                    if (et.isActive()) {
                        et.rollback();
                    }
                } else {
                    TestUtil.logTrace((String)"EntityTransaction never got assigned and is null");
                    pass = false;
                }
            }
            catch (PersistenceException e) {
                TestUtil.logErr((String)"Unexpected PersistenceException rolling back TX", (Throwable)e);
            }
        }
        return pass;
    }
}

