/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.CriteriaDelete;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Product;
import com.sun.ts.tests.jpa.common.schema30.SoftwareProduct;
import com.sun.ts.tests.jpa.common.schema30.Util;
import java.util.ArrayList;
import java.util.Properties;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createProductData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
    }

    public void fromClassTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                TestUtil.logTrace((String)("Received expected number deleted:" + actual));
                this.clearCache();
                TestUtil.logMsg((String)"Make sure items were deleted by looking up the Products id");
                for (Product p : this.productRef) {
                    pass1 = true;
                    if (this.getEntityManager().find(Product.class, (Object)p.getId()) == null) continue;
                    TestUtil.logErr((String)("Expected product:" + p.getId() + " to have been deleted"));
                    pass2 = false;
                }
            } else {
                TestUtil.logErr((String)("Expected:" + this.productRef.length + ", actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("fromClassTest failed");
        }
    }

    public void fromEntityTypeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Metamodel mm = this.getEntityManager().getMetamodel();
        EntityType Product_ = mm.entity(Product.class);
        Root root = cd.from(Product_);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                TestUtil.logTrace((String)("Received expected number deleted:" + actual));
                this.clearCache();
                TestUtil.logMsg((String)"Make sure items were deleted by looking up the Products id");
                for (Product p : this.productRef) {
                    pass1 = true;
                    if (this.getEntityManager().find(Product.class, (Object)p.getId()) == null) continue;
                    TestUtil.logErr((String)("Expected product:" + p.getId() + " to have been deleted"));
                    pass2 = false;
                }
            } else {
                TestUtil.logErr((String)("Expected:" + this.productRef.length + ", actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("fromEntityTypeTest failed");
        }
    }

    public void getRootTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                TestUtil.logTrace((String)"Obtained expected root");
                pass = true;
            } else {
                TestUtil.logErr((String)"Failed to get expected root");
                TestUtil.logErr((String)("Expected:" + cd.getRoot() + ", actual:" + root));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        if (!pass) {
            throw new EETest.Fault("getRootTest failed");
        }
    }

    public void whereExpressionTest() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass3 = true;
        boolean pass4 = true;
        boolean pass5 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            Path exp = root.get("id");
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            col.add("2");
            col.add("3");
            cd.where((Expression)exp.in(col));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == col.size()) {
                Product pp;
                TestUtil.logTrace((String)("Received expected number deleted:" + actual));
                this.clearCache();
                pass2 = true;
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (product.getId().equals("1") || product.getId().equals("2") || product.getId().equals("3")) {
                        if (pp != null) {
                            TestUtil.logErr((String)("Expected product:" + product.getId() + " to have been deleted"));
                            pass3 = false;
                            continue;
                        }
                        TestUtil.logTrace((String)("Product:" + product.getId() + " was successfully deleted"));
                        continue;
                    }
                    if (pp == null) {
                        TestUtil.logErr((String)("Product:" + product.getId() + " was incorrectly deleted"));
                        pass3 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Found Product:" + pp.getId()));
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp == null) {
                        TestUtil.logErr((String)("Software Product:" + product.getId() + " was incorrectly deleted"));
                        pass4 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Found Software Product:" + pp.getId()));
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp == null) {
                        TestUtil.logErr((String)("Harware Product:" + product.getId() + " was incorrectly deleted"));
                        pass5 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Found Harware Product:" + pp.getId()));
                }
            } else {
                TestUtil.logErr((String)("Expected:" + col.size() + ", actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("whereExpressionTest failed");
        }
    }

    public void wherePredicateArrayTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            Product pp;
            TestUtil.logTrace((String)"Obtained Non-null root");
            Predicate[] predArray = new Predicate[]{cbuilder.equal((Expression)root.get("id"), (Object)"2")};
            cd.where(predArray);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == predArray.length) {
                TestUtil.logTrace((String)("Received expected number deleted:" + actual));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected deleted:" + predArray.length + ", actual:" + actual));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            for (Product product : this.productRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (product.getId().equals("2")) {
                    if (pp != null) {
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have been deleted"));
                        pass2 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Product:" + product.getId() + " was successfully deleted"));
                    continue;
                }
                if (pp == null) {
                    TestUtil.logErr((String)("Product:" + product.getId() + " was incorrectly deleted"));
                    pass2 = false;
                    continue;
                }
                TestUtil.logTrace((String)("Found Product:" + pp.getId()));
            }
            for (Product product : this.softwareRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (pp != null) continue;
                TestUtil.logErr((String)("Software product:" + product.getId() + " should not have been deleted"));
                pass3 = false;
            }
            for (Product product : this.hardwareRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (pp != null) continue;
                TestUtil.logErr((String)("Hardware product:" + product.getId() + " should not have been deleted"));
                pass4 = false;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("wherePredicateArrayTest failed");
        }
    }

    public void subquery() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(19);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        if (cd != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root product = cd.from(Product.class);
            EntityType Product_ = product.getModel();
            Subquery sq = cd.subquery(Product.class);
            Root hardProd = sq.from(Product.class);
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1")).select((Expression)hardProd);
            cd.where((Expression)cbuilder.exists(sq));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == 1) {
                TestUtil.logTrace((String)("Received expected number deleted:" + actual));
                this.clearCache();
                for (Product p : this.productRef) {
                    pass1 = true;
                    Product pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    if (p.getId().equals("1")) {
                        if (pp != null) {
                            TestUtil.logErr((String)("Expected product:" + p.getId() + " to have been deleted:" + p.toString()));
                            pass2 = false;
                            continue;
                        }
                        TestUtil.logTrace((String)("Product:" + p.getId() + " was successfully deleted"));
                        continue;
                    }
                    if (pp == null) {
                        TestUtil.logErr((String)("Product:" + p.getId() + " was incorrectly deleted"));
                        pass2 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Found product:" + pp.getId()));
                }
            } else {
                TestUtil.logErr((String)("Expected:1, actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("exists test failed");
        }
    }

    public void modifiedQueryTest() throws EETest.Fault {
        int passDeletedCount1 = 0;
        int passUnDeletedCount1 = 0;
        int passDeletedCount2 = 0;
        int passUnDeletedCount2 = 0;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        TestUtil.logMsg((String)"Testing initial query");
        CriteriaDelete cd = cbuilder.createCriteriaDelete(SoftwareProduct.class);
        Root softwareproduct = cd.from(SoftwareProduct.class);
        if (softwareproduct != null) {
            Product pp;
            EntityType softwareproduct_ = softwareproduct.getModel();
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)35));
            Query q = this.getEntityManager().createQuery(cd);
            TestUtil.logMsg((String)"Modify CriteriaDelete object");
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)500));
            int actual = q.executeUpdate();
            if (actual == 4) {
                TestUtil.logTrace((String)("Received expected number of deletes:" + actual));
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp != null) {
                            TestUtil.logErr((String)("Expected product:" + p.getId() + " to have been deleted"));
                            continue;
                        }
                        TestUtil.logTrace((String)("id:" + p.getId() + " was successfully deleted"));
                        ++passDeletedCount1;
                        continue;
                    }
                    if (pp == null) {
                        TestUtil.logErr((String)("id:" + p.getId() + " was incorrectly deleted"));
                        continue;
                    }
                    TestUtil.logTrace((String)("Found product:" + pp.getId()));
                    ++passUnDeletedCount1;
                }
            } else {
                TestUtil.logErr((String)("Expected: 4 deletes [30,31,36,37], actual:" + actual));
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    if (pp != null) {
                        TestUtil.logErr((String)("id:" + p.getId() + ", quantity:" + pp.getQuantity() + " exists"));
                        continue;
                    }
                    TestUtil.logErr((String)("id:" + p.getId() + " was deleted"));
                }
            }
            TestUtil.logMsg((String)"Testing modified CriteriaQuery");
            cd.where((Expression)cbuilder.gt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)100));
            actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == 3) {
                TestUtil.logTrace((String)("Received expected number of deletes:" + actual));
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("29") || p.getId().equals("34") || p.getId().equals("38") || p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp != null) {
                            TestUtil.logErr((String)("Expected product:" + p.getId() + " to have been deleted"));
                            continue;
                        }
                        TestUtil.logTrace((String)("id:" + p.getId() + " was successfully deleted"));
                        ++passDeletedCount2;
                        continue;
                    }
                    if (pp == null) {
                        TestUtil.logErr((String)("id:" + p.getId() + " was incorrectly deleted"));
                        continue;
                    }
                    TestUtil.logTrace((String)("Found id:" + pp.getId()));
                    ++passUnDeletedCount2;
                }
            } else {
                TestUtil.logErr((String)("Expected: 3 additional deletes [29,34,38] total deletes [29,30,31,34,36,37,38], actual:" + actual));
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    TestUtil.logErr((String)("id:" + p.getId() + ", quantity:" + pp.getQuantity()));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (passDeletedCount1 != 4 || passUnDeletedCount1 != 6 || passDeletedCount2 != 7 || passUnDeletedCount2 != 3) {
            throw new EETest.Fault("modifiedQueryTest failed");
        }
    }

    @Override
    public void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

