/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.commonee;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class Client
extends EETest {
    protected TSNamingContextInterface context = null;
    protected Properties props = null;
    protected Queue rcvrQueue;
    protected QueueConnection qConnect;
    protected QueueSession session;
    protected QueueConnectionFactory qFactory;
    protected QueueSender qSender;
    protected TopicConnection tConnect;
    protected TopicSession tSession;
    protected TopicConnectionFactory tFactory;
    protected TopicPublisher tPub;
    protected String jmsUser = null;
    protected String jmsPassword = null;
    protected String hostname = null;
    protected String traceFlag = null;
    protected String logPort = null;
    protected TextMessage msg = null;
    protected long timeout = 0L;

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.jmsUser = p.getProperty("user");
            if (this.jmsUser == null) {
                TestUtil.logTrace((String)"user is null");
                throw new EETest.Fault("Error getting user");
            }
            this.jmsPassword = p.getProperty("password");
            if (this.jmsPassword == null) {
                TestUtil.logTrace((String)"password is null");
                throw new EETest.Fault("Error getting password");
            }
            String time = p.getProperty("jms_timeout");
            if (time == null) {
                TestUtil.logTrace((String)"jms_timeout is null");
                throw new EETest.Fault("Error getting jms_timeout");
            }
            this.hostname = p.getProperty("harness.host");
            if (this.hostname == null) {
                TestUtil.logTrace((String)"harness.host is null");
                throw new EETest.Fault("Error getting harness.host");
            }
            this.traceFlag = p.getProperty("harness.log.traceflag");
            if (this.traceFlag == null) {
                TestUtil.logTrace((String)"harness.log.traceflag is null");
                throw new EETest.Fault("Error getting harness.log.traceflag");
            }
            this.logPort = p.getProperty("harness.log.port");
            if (this.logPort == null) {
                TestUtil.logTrace((String)"harness.log.port is null");
                throw new EETest.Fault("Error getting harness.log.port");
            }
            this.timeout = Long.parseLong(time);
            TestUtil.logTrace((String)"in client setup");
            this.context = new TSNamingContext();
            TestUtil.logTrace((String)"Client: Do lookups!");
            this.rcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            this.session = this.qConnect.createQueueSession(false, 1);
            this.qConnect.start();
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            this.tConnect = this.tFactory.createTopicConnection(this.jmsUser, this.jmsPassword);
            this.tSession = this.tConnect.createTopicSession(false, 1);
            this.tConnect.start();
            TestUtil.logTrace((String)"get the connection and starter up");
            TestUtil.logTrace((String)"Client: connection started, now send initialization msg!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup Failed!", e);
        }
    }

    protected void createTestMessage(String TestCase, int num) {
        String myMessage = "MDB deploy tests";
        String key = null;
        String notValid = ".";
        try {
            this.msg = this.session.createTextMessage();
            Enumeration<?> e = this.props.propertyNames();
            this.msg.setStringProperty("user", this.jmsUser);
            this.msg.setStringProperty("password", this.jmsPassword);
            this.msg.setStringProperty("harnesshost", this.hostname);
            this.msg.setStringProperty("harnesslogtraceflag", this.traceFlag);
            this.msg.setStringProperty("harnesslogport", this.logPort);
            e = this.props.propertyNames();
            key = null;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.indexOf(notValid) != -1 || key.indexOf("***") != -1) continue;
                this.msg.setStringProperty(key, this.props.getProperty(key));
            }
            this.msg.setText(myMessage);
            this.msg.setIntProperty("TestCaseNum", num);
            this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", TestCase);
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logMsg((String)("key was: " + key));
            TestUtil.logMsg((String)("props was: " + this.props.getProperty(key)));
            TestUtil.logMsg((String)"Error setting properties");
        }
    }

    public boolean checkOnResponse(String TestCase) {
        boolean status = false;
        try {
            TestUtil.logMsg((String)"@checkOnResponse");
            status = this.recvMessageInternal(this.session, TestCase);
            TestUtil.logMsg((String)"Close the session");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return status;
    }

    protected boolean recvMessageInternal(QueueSession session, String TestCase) throws JMSException {
        boolean retcode = false;
        TestUtil.logMsg((String)"@recvMessageInternal");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            TestUtil.logMsg((String)("@recvMessageInternal trying to receive the message: " + i));
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            if (msgRec instanceof TextMessage) {
                TestUtil.logMsg((String)("**** Received msg text = " + ((TextMessage)msgRec).getText() + " ****"));
            }
            TestUtil.logMsg((String)("**** Received msg getStringProperty('TestCase') = " + msgRec.getStringProperty("TestCase")));
            TestUtil.logMsg((String)("**** Received msg getStringProperty('Status') = " + msgRec.getStringProperty("Status")));
            if (msgRec.getStringProperty("TestCase") == null || msgRec.getStringProperty("Status") == null) {
                TestUtil.logMsg((String)("Fail: unexpected message received from MDB_QUEUE_REPLY msgRec=" + msgRec));
            } else if (msgRec.getStringProperty("TestCase").equals(TestCase) && msgRec.getStringProperty("Status").equals("Pass")) {
                TestUtil.logMsg((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                TestUtil.logMsg((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                TestUtil.logMsg((String)"Pass: we got the expected msg back! ");
                retcode = true;
            } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                TestUtil.logMsg((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                TestUtil.logMsg((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                TestUtil.logMsg((String)"Fail: Error(s) occurred! ");
            } else {
                TestUtil.logMsg((String)"Fail: we didnt get the expected msg back! ");
                TestUtil.logMsg((String)("TestCase:  " + msgRec.getStringProperty("TestCase")));
            }
        } else if (msgRec == null) {
            TestUtil.logMsg((String)"Fail: we didnt get any msg back! ");
        }
        return retcode;
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.closeDefaultConnections();
            this.flushQueue();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueue() throws Exception {
        QueueConnection qc = null;
        QueueReceiver qr = null;
        QueueSession qs = null;
        int numMsgsFlushed = 0;
        try {
            qc = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            qs = qc.createQueueSession(false, 1);
            qc.start();
            qr = qs.createReceiver(this.rcvrQueue);
            Message msg = qr.receive(this.timeout);
            while (msg != null) {
                if (msg instanceof TextMessage) {
                    TestUtil.logMsg((String)("**** Flushed TextMessage =" + ((TextMessage)msg).getText() + " ****"));
                } else {
                    String msgType = "Message";
                    if (msg instanceof BytesMessage) {
                        msgType = "BytesMessage";
                    } else if (msg instanceof MapMessage) {
                        msgType = "MapMessage";
                    } else if (msg instanceof ObjectMessage) {
                        msgType = "ObjectMessage";
                    } else if (msg instanceof StreamMessage) {
                        msgType = "StreamMessage";
                    }
                    TestUtil.logMsg((String)("**** Flushed Message of type " + msgType + " ****"));
                }
                ++numMsgsFlushed;
                msg = qr.receiveNoWait();
            }
            if (numMsgsFlushed > 0) {
                TestUtil.logMsg((String)("flushed " + numMsgsFlushed + " messages"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error attempting to flush Queue: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            qc.close();
        }
    }

    public void closeDefaultConnections() throws Exception {
        try {
            if (this.qConnect != null) {
                TestUtil.logMsg((String)"Client: Closing QueueConnection");
                this.qConnect.close();
            }
            if (this.tConnect != null) {
                TestUtil.logMsg((String)"Client: Closing TopicConnection");
                this.tConnect.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }
}

