/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex3a;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.derivedid.ex3a.DID3Dependent;
import com.sun.ts.tests.jpa.core.derivedid.ex3a.DID3DependentId;
import com.sun.ts.tests.jpa.core.derivedid.ex3a.DID3Employee;
import com.sun.ts.tests.jpa.core.derivedid.ex3a.DID3EmployeeId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void DIDTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID3EmployeeId eId1 = new DID3EmployeeId("Java", "Duke");
            DID3EmployeeId eId2 = new DID3EmployeeId("C", "foo");
            DID3Employee employee1 = new DID3Employee(eId1);
            DID3Employee employee2 = new DID3Employee(eId2);
            DID3DependentId depId1 = new DID3DependentId("Obama", eId1);
            DID3DependentId depId2 = new DID3DependentId("Michelle", eId1);
            DID3DependentId depId3 = new DID3DependentId("John", eId2);
            DID3Dependent dep1 = new DID3Dependent(depId1, employee1);
            DID3Dependent dep2 = new DID3Dependent(depId2, employee1);
            DID3Dependent dep3 = new DID3Dependent(depId3, employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"persisted Employees and Dependents");
            DID3Dependent newDependent = (DID3Dependent)this.getEntityManager().find(DID3Dependent.class, (Object)depId1);
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID3Dependent d where d.name2='Obama' and d.emp.empId.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID3Dependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    TestUtil.logTrace((String)"Received Expected Dependent");
                } else {
                    TestUtil.logErr((String)"Searched Dependent not found");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new EETest.Fault("DTDTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3DEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

