/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.RetryConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersRecord;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.batch.api.chunk.AbstractItemWriter;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Named(value="retryInitWriter")
public class RetryInitWriter
extends AbstractItemWriter {
    protected DataSource dataSource = null;

    public void open(Serializable cpd) throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("java:module/env/jdbc/orderDB");
    }

    public void writeItems(List<Object> records) throws SQLException {
        int item = -1;
        int quantity = -1;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            for (Object record : records) {
                item = ((NumbersRecord)record).getItem();
                quantity = ((NumbersRecord)record).getQuantity();
                connection = RetryConnectionHelper.getConnection(this.dataSource);
                statement = connection.prepareStatement("update numbers set quantity = ? where item = ?");
                statement.setInt(2, item);
                statement.setInt(1, quantity);
                int n = statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            RetryConnectionHelper.cleanupConnection(connection, null, statement);
        }
    }
}

