/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;

public class JobExecutableSequenceTests
extends ServiceEETest {
    private JobOperatorBridge jobOp = null;

    public void testJobExecutableSequenceToUnknown() throws EETest.Fault {
        String METHOD = "testJobExecutableSequenceToUnknown";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"starting job");
            TCKJobExecutionWrapper jobExec = null;
            boolean seenException = false;
            try {
                jobExec = this.jobOp.startJobAndWaitForResult("job_executable_sequence_invalid", null);
            }
            catch (JobStartException e) {
                TestUtil.logMsg((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                TestUtil.logMsg((String)("Didn't catch JobStartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of out of scope execution elements.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
            TestUtil.logMsg((String)"job failed");
        }
        catch (Exception e) {
            JobExecutableSequenceTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            JobExecutableSequenceTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    public void afterTest() {
        this.jobOp = null;
    }
}

