/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.j2w.marshalltest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Data;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.j2w.marshalltest.JavaBean;
import com.sun.ts.tests.jaxrpc.ee.j2w.marshalltest.MarshallTest;
import com.sun.ts.tests.jaxrpc.ee.j2w.marshalltest.MyServiceException;
import com.sun.ts.tests.jaxrpc.ee.j2w.marshalltest.ValueType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.j2w.marshalltest.";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "j2wmarshalltest.endpoint.1";
    private static final String WSDLLOC_URL = "j2wmarshalltest.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    private static final String SERVICE_NAME = "j2wmarshalltest.servicename.1";
    private static final String PORT_NAME = "j2wmarshalltest.portname.1";
    private String serviceName = null;
    private String portName = null;
    String modeProperty = null;
    MarshallTest port = null;
    Stub stub = null;
    private JavaBean[] JavaBean_data = null;
    private JavaBean[][] JavaBean_multi_data = null;
    private ValueType[] ValueType_data = null;
    private ValueType[][] ValueType_multi_data = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getStubStandalone() throws Exception {
        this.serviceName = PKG_NAME + JAXRPC_Util.getURLFromProp(SERVICE_NAME);
        this.portName = JAXRPC_Util.getURLFromProp(PORT_NAME);
        this.port = (MarshallTest)JAXRPC_Util.getStub(this.serviceName, "get" + this.portName);
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service svc = (Service)ic.lookup("java:comp/env/service/j2wmarshalltest");
            this.port = (MarshallTest)svc.getPort(MarshallTest.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubStandalone();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            } else {
                this.getStub();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.JavaBean_data = new JavaBean[2];
        this.JavaBean_data[0] = new JavaBean();
        this.JavaBean_data[1] = new JavaBean();
        this.JavaBean_multi_data = new JavaBean[2][];
        this.JavaBean_multi_data[0] = this.JavaBean_data;
        this.JavaBean_multi_data[1] = this.JavaBean_data;
        this.ValueType_data = new ValueType[2];
        this.ValueType_data[0] = new ValueType();
        this.ValueType_data[1] = new ValueType();
        this.ValueType_multi_data = new ValueType[2][];
        this.ValueType_multi_data[0] = this.ValueType_data;
        this.ValueType_multi_data[1] = this.ValueType_data;
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void MarshallPrimitiveTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MarshallPrimitiveTest");
        boolean pass = true;
        if (!this.booleanTest()) {
            pass = false;
        }
        if (!this.BooleanTest()) {
            pass = false;
        }
        if (!this.byteTest()) {
            pass = false;
        }
        if (!this.ByteTest()) {
            pass = false;
        }
        if (!this.shortTest()) {
            pass = false;
        }
        if (!this.ShortTest()) {
            pass = false;
        }
        if (!this.intTest()) {
            pass = false;
        }
        if (!this.IntegerTest()) {
            pass = false;
        }
        if (!this.longTest()) {
            pass = false;
        }
        if (!this.LongTest()) {
            pass = false;
        }
        if (!this.floatTest()) {
            pass = false;
        }
        if (!this.FloatTest()) {
            pass = false;
        }
        if (!this.doubleTest()) {
            pass = false;
        }
        if (!this.DoubleTest()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MarshallPrimitiveTest failed");
        }
    }

    public void MarshallStandardJavaClassesTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MarshallStandardJavaClassesTest");
        boolean pass = true;
        if (!this.StringTest()) {
            pass = false;
        }
        if (!this.CalendarTest()) {
            pass = false;
        }
        if (!this.BigIntegerTest()) {
            pass = false;
        }
        if (!this.BigDecimalTest()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MarshallStandardJavaClassesTest failed");
        }
    }

    public void MarshallJavaBeanTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MarshallJavaBeanTest");
        boolean pass = true;
        this.init_JavaBean_Data();
        JavaBean[] values = this.JavaBean_data;
        TestUtil.logMsg((String)"Passing/Returning JavaBean JavaBean class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                JavaBean response = this.port.javaBeanTest(values[i]);
                if (this.compareJavaBeans(values[i], response)) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MarshallJavaBeanTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("MarshallJavaBeanTest failed");
        }
    }

    public void MarshallJavaArrayTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MarshallJavaArrayTest");
        boolean pass = true;
        if (!this.booleanArrayTest()) {
            pass = false;
        }
        if (!this.byteArrayTest()) {
            pass = false;
        }
        if (!this.shortArrayTest()) {
            pass = false;
        }
        if (!this.intArrayTest()) {
            pass = false;
        }
        if (!this.longArrayTest()) {
            pass = false;
        }
        if (!this.floatArrayTest()) {
            pass = false;
        }
        if (!this.doubleArrayTest()) {
            pass = false;
        }
        if (!this.StringArrayTest()) {
            pass = false;
        }
        if (!this.CalendarArrayTest()) {
            pass = false;
        }
        if (!this.BigIntegerArrayTest()) {
            pass = false;
        }
        if (!this.BigDecimalArrayTest()) {
            pass = false;
        }
        if (!this.JavaBeanArrayTest()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MarshallJavaArrayTest failed");
        }
    }

    public void MarshallJavaMultiArrayTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest");
        boolean pass = true;
        if (!this.booleanMultiArrayTest()) {
            pass = false;
        }
        if (!this.byteMultiArrayTest()) {
            pass = false;
        }
        if (!this.shortMultiArrayTest()) {
            pass = false;
        }
        if (!this.intMultiArrayTest()) {
            pass = false;
        }
        if (!this.longMultiArrayTest()) {
            pass = false;
        }
        if (!this.floatMultiArrayTest()) {
            pass = false;
        }
        if (!this.doubleMultiArrayTest()) {
            pass = false;
        }
        if (!this.StringMultiArrayTest()) {
            pass = false;
        }
        if (!this.CalendarMultiArrayTest()) {
            pass = false;
        }
        if (!this.BigIntegerMultiArrayTest()) {
            pass = false;
        }
        if (!this.BigDecimalMultiArrayTest()) {
            pass = false;
        }
        if (!this.JavaBeanMultiArrayTest()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("MarshallJavaMultiArrayTest failed");
        }
    }

    public void MarshallServiceExceptionTest() throws EETest.Fault {
        boolean pass;
        block6: {
            TestUtil.logMsg((String)"MarshallServiceExceptionTest");
            pass = true;
            TestUtil.logMsg((String)"Throwing a ServiceException from JAXRPC Service");
            try {
                try {
                    this.port.myServiceExceptionTest();
                    TestUtil.logErr((String)"no fault occurred");
                    pass = false;
                }
                catch (Exception response) {
                    TestUtil.logMsg((String)("a fault occurred: " + response));
                    TestUtil.logMsg((String)("response=" + response));
                    if (response instanceof MyServiceException) {
                        TestUtil.logMsg((String)"Is an instance of MyServiceException");
                        break block6;
                    }
                    TestUtil.logErr((String)"Not an instance of MyServiceException", (Throwable)response);
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("MarshallServiceExceptionTest failed", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("MarshallServiceExceptionTest failed");
        }
    }

    public void MarshallVoidTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MarshallVoidTest");
        boolean pass = true;
        TestUtil.logMsg((String)"Handling a void type to/from JAXRPC Service");
        try {
            this.port.voidTest();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("MarshallVoidTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("MarshallVoidTest failed");
        }
    }

    private boolean printTestStatus(boolean pass, String test) {
        if (pass) {
            TestUtil.logMsg((String)("" + test + " ... PASSED"));
        } else {
            TestUtil.logErr((String)("" + test + " ... FAILED"));
        }
        return pass;
    }

    private boolean booleanTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(booleanTest)");
        boolean pass = true;
        boolean[] values = JAXRPC_Data.boolean_data;
        TestUtil.logMsg((String)"Passing/Returning boolean data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                boolean response = this.port.booleanTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response)) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(booleanTest)");
        return pass;
    }

    private boolean BooleanTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(BooleanTest)");
        boolean pass = true;
        Boolean[] values = JAXRPC_Data.Boolean_data;
        try {
            TestUtil.logMsg((String)"Passing/Returning Boolean class to/from JAXRPC Service");
            for (int i = 0; i < values.length; ++i) {
                Boolean response = this.port.wrapperBooleanTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Boolean")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(BooleanTest)");
        return pass;
    }

    private boolean byteTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(byteTest)");
        boolean pass = true;
        byte[] values = JAXRPC_Data.byte_data;
        TestUtil.logMsg((String)"Passing/Returning byte data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                byte response = this.port.byteTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response)) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(byteTest)");
        return pass;
    }

    private boolean ByteTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(ByteTest)");
        boolean pass = true;
        Byte[] values = JAXRPC_Data.Byte_data;
        TestUtil.logMsg((String)"Passing/Returning Byte class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                Byte response = this.port.wrapperByteTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Byte")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(ByteTest)");
        return pass;
    }

    private boolean shortTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(shortTest)");
        boolean pass = true;
        short[] values = JAXRPC_Data.short_data;
        TestUtil.logMsg((String)"Passing/Returning short data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                short response = this.port.shortTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response)) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(shortTest)");
        return pass;
    }

    private boolean ShortTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(ShortTest)");
        boolean pass = true;
        Short[] values = JAXRPC_Data.Short_data;
        TestUtil.logMsg((String)"Passing/Returning Short class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                Short response = this.port.wrapperShortTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Short")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(ShortTest)");
        return pass;
    }

    private boolean intTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(intTest)");
        boolean pass = true;
        int[] values = JAXRPC_Data.int_data;
        TestUtil.logMsg((String)"Passing/Returning int data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                int response = this.port.intTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response)) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(intTest)");
        return pass;
    }

    private boolean IntegerTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(IntegerTest)");
        boolean pass = true;
        Integer[] values = JAXRPC_Data.Integer_data;
        TestUtil.logMsg((String)"Passing/Returning Integer class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                Integer response = this.port.wrapperIntegerTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Integer")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(IntegerTest)");
        return pass;
    }

    private boolean longTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(longTest)");
        boolean pass = true;
        long[] values = JAXRPC_Data.long_data;
        TestUtil.logMsg((String)"Passing/Returning long data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                long response = this.port.longTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response)) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(longTest)");
        return pass;
    }

    private boolean LongTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(LongTest)");
        boolean pass = true;
        Long[] values = JAXRPC_Data.Long_data;
        TestUtil.logMsg((String)"Passing/Returning Long class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                Long response = this.port.wrapperLongTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Long")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(LongTest)");
        return pass;
    }

    private boolean floatTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(floatTest)");
        boolean pass = true;
        float[] values = JAXRPC_Data.float_data;
        TestUtil.logMsg((String)"Passing/Returning float data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                float response = this.port.floatTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response)) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(floatTest)");
        return pass;
    }

    private boolean FloatTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(FloatTest)");
        boolean pass = true;
        Float[] values = JAXRPC_Data.Float_data;
        TestUtil.logMsg((String)"Passing/Returning Float class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                Float response = this.port.wrapperFloatTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Float")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(FloatTest)");
        return pass;
    }

    private boolean doubleTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(doubleTest)");
        boolean pass = true;
        double[] values = JAXRPC_Data.double_data;
        TestUtil.logMsg((String)"Passing/Returning double data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                double response = this.port.doubleTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response)) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(doubleTest)");
        return pass;
    }

    private boolean DoubleTest() {
        TestUtil.logMsg((String)"MarshallPrimitiveTest:(DoubleTest)");
        boolean pass = true;
        Double[] values = JAXRPC_Data.Double_data;
        TestUtil.logMsg((String)"Passing/Returning Double class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                Double response = this.port.wrapperDoubleTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Double")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallPrimitiveTest:(DoubleTest)");
        return pass;
    }

    private boolean StringTest() {
        TestUtil.logMsg((String)"MarshallStandardJavaClassesTest:(StringTest)");
        boolean pass = true;
        String[] values = JAXRPC_Data.String_data;
        try {
            TestUtil.logMsg((String)"Passing/Returning String class to/from JAXRPC Service");
            for (int i = 0; i < values.length; ++i) {
                String response = this.port.stringTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "String")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallStandardJavaClassesTest:(StringTest)");
        return pass;
    }

    private boolean CalendarTest() {
        TestUtil.logMsg((String)"MarshallStandardJavaClassesTest:(CalendarTest)");
        boolean pass = true;
        GregorianCalendar[] values = JAXRPC_Data.GregorianCalendar_data;
        TestUtil.logMsg((String)"Passing/Returning Calendar class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                Calendar response = this.port.calendarTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Calendar")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallStandardJavaClassesTest:(CalendarTest)");
        return pass;
    }

    private boolean BigIntegerTest() {
        TestUtil.logMsg((String)"MarshallStandardJavaClassesTest:(BigIntegerTest)");
        boolean pass = true;
        BigInteger[] values = JAXRPC_Data.BigInteger_data;
        TestUtil.logMsg((String)"Passing/Returning BigInteger class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                BigInteger response = this.port.bigIntegerTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "BigInteger")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallStandardJavaClassesTest:(BigIntegerTest)");
        return pass;
    }

    private boolean BigDecimalTest() {
        TestUtil.logMsg((String)"MarshallStandardJavaClassesTest:(BigDecimalTest)");
        boolean pass = true;
        BigDecimal[] values = JAXRPC_Data.BigDecimal_data;
        TestUtil.logMsg((String)"Passing/Returning BigDecimal class to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                BigDecimal response = this.port.bigDecimalTest(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "BigDecimal")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallStandardJavaClassesTest:(BigDecimalTest)");
        return pass;
    }

    private boolean booleanArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(booleanArrayTest)");
        boolean pass = true;
        boolean[] values = JAXRPC_Data.boolean_data;
        TestUtil.logMsg((String)"Passing/Returning boolean array to/from JAXRPC Service");
        try {
            boolean[] response = this.port.booleanArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "boolean");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(booleanArrayTest)");
        return pass;
    }

    private boolean byteArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(byteArrayTest)");
        boolean pass = true;
        byte[] values = JAXRPC_Data.byte_data;
        try {
            byte[] response = this.port.byteArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "byte");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(byteArrayTest)");
        return pass;
    }

    private boolean shortArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(shortArrayTest)");
        boolean pass = true;
        short[] values = JAXRPC_Data.short_data;
        try {
            short[] response = this.port.shortArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "short");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(shortArrayTest)");
        return pass;
    }

    private boolean intArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(intArrayTest)");
        boolean pass = true;
        int[] values = JAXRPC_Data.int_data;
        try {
            int[] response = this.port.intArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "int");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(intArrayTest)");
        return pass;
    }

    private boolean longArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(longArrayTest)");
        boolean pass = true;
        long[] values = JAXRPC_Data.long_data;
        try {
            long[] response = this.port.longArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "long");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(longArrayTest)");
        return pass;
    }

    private boolean floatArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(floatArrayTest)");
        boolean pass = true;
        float[] values = JAXRPC_Data.float_data;
        try {
            float[] response = this.port.floatArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "float");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(floatArrayTest)");
        return pass;
    }

    private boolean doubleArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(doubleArrayTest)");
        boolean pass = true;
        double[] values = JAXRPC_Data.double_data;
        try {
            double[] response = this.port.doubleArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "double");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(doubleArrayTest)");
        return pass;
    }

    private boolean StringArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(StringArrayTest)");
        boolean pass = true;
        String[] values = JAXRPC_Data.String_data;
        try {
            String[] response = this.port.stringArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "String");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(StringArrayTest)");
        return pass;
    }

    private boolean CalendarArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(CalendarArrayTest)");
        boolean pass = true;
        Calendar[] values = JAXRPC_Data.GregorianCalendar_data;
        try {
            Calendar[] response = this.port.calendarArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "Calendar");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(CalendarArrayTest)");
        return pass;
    }

    private boolean BigIntegerArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(BigIntegerArrayTest)");
        boolean pass = true;
        BigInteger[] values = JAXRPC_Data.BigInteger_data;
        try {
            BigInteger[] response = this.port.bigIntegerArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "BigInteger");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(BigIntegerArrayTest)");
        return pass;
    }

    private boolean BigDecimalArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(BigDecimalArrayTest)");
        boolean pass = true;
        BigDecimal[] values = JAXRPC_Data.BigDecimal_data;
        try {
            BigDecimal[] response = this.port.bigDecimalArrayTest(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "BigDecimal");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(BigDecimalArrayTest)");
        return pass;
    }

    private boolean JavaBeanArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaArrayTest:(JavaBeanArrayTest)");
        boolean pass = true;
        this.init_JavaBean_Data();
        JavaBean[] values = this.JavaBean_data;
        try {
            JavaBean[] response = this.port.javaBeanArrayTest(values);
            pass = this.compareArrayValues(values, response, "JavaBean");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaArrayTest:(JavaBeanArrayTest)");
        return pass;
    }

    private boolean booleanMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(booleanMultiArrayTest)");
        boolean pass = true;
        boolean[][] values = JAXRPC_Data.boolean_multi_data;
        TestUtil.logMsg((String)"Passing/Returning boolean multi array to/from JAXRPC Service");
        try {
            boolean[][] response = this.port.booleanMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "boolean");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(booleanMultiArrayTest)");
        return pass;
    }

    private boolean byteMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(byteMultiArrayTest)");
        boolean pass = true;
        byte[][] values = JAXRPC_Data.byte_multi_data;
        TestUtil.logMsg((String)"Passing/Returning byte multi array to/from JAXRPC Service");
        try {
            byte[][] response = this.port.byteMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "byte");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(byteMultiArrayTest)");
        return pass;
    }

    private boolean shortMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(shortMultiArrayTest)");
        boolean pass = true;
        short[][] values = JAXRPC_Data.short_multi_data;
        TestUtil.logMsg((String)"Passing/Returning short multi array to/from JAXRPC Service");
        try {
            short[][] response = this.port.shortMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "short");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(shortMultiArrayTest)");
        return pass;
    }

    private boolean intMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(intMultiArrayTest)");
        boolean pass = true;
        int[][] values = JAXRPC_Data.int_multi_data;
        TestUtil.logMsg((String)"Passing/Returning int multi array to/from JAXRPC Service");
        try {
            int[][] response = this.port.intMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "int");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(intMultiArrayTest)");
        return pass;
    }

    private boolean longMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(longMultiArrayTest)");
        boolean pass = true;
        long[][] values = JAXRPC_Data.long_multi_data;
        TestUtil.logMsg((String)"Passing/Returning long multi array to/from JAXRPC Service");
        try {
            long[][] response = this.port.longMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "long");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(longMultiArrayTest)");
        return pass;
    }

    private boolean floatMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(floatMultiArrayTest)");
        boolean pass = true;
        float[][] values = JAXRPC_Data.float_multi_data;
        TestUtil.logMsg((String)"Passing/Returning float multi array to/from JAXRPC Service");
        try {
            float[][] response = this.port.floatMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "float");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(floatMultiArrayTest)");
        return pass;
    }

    private boolean doubleMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(doubleMultiArrayTest)");
        boolean pass = true;
        double[][] values = JAXRPC_Data.double_multi_data;
        TestUtil.logMsg((String)"Passing/Returning double multi array to/from JAXRPC Service");
        try {
            double[][] response = this.port.doubleMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "double");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(doubleMultiArrayTest)");
        return pass;
    }

    private boolean StringMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(StringMultiArrayTest)");
        boolean pass = true;
        String[][] values = JAXRPC_Data.String_multi_data;
        TestUtil.logMsg((String)"Passing/Returning String multi array to/from JAXRPC Service");
        try {
            String[][] response = this.port.stringMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "String");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(StringMultiArrayTest)");
        return pass;
    }

    private boolean CalendarMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(CalendarMultiArrayTest)");
        boolean pass = true;
        Calendar[][] values = JAXRPC_Data.GregorianCalendar_multi_data;
        TestUtil.logMsg((String)"Passing/Returning Calendar multi array to/from JAXRPC Service");
        try {
            Calendar[][] response = this.port.calendarMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "Calendar");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(CalendarMultiArrayTest)");
        return pass;
    }

    private boolean BigIntegerMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(BigIntegerMultiArrayTest)");
        boolean pass = true;
        BigInteger[][] values = JAXRPC_Data.BigInteger_multi_data;
        TestUtil.logMsg((String)"Passing/Returning BigInteger multi array to/from JAXRPC Service");
        try {
            BigInteger[][] response = this.port.bigIntegerMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "BigInteger");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(BigIntegerMultiArrayTest)");
        return pass;
    }

    private boolean BigDecimalMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(BigDecimalMultiArrayTest)");
        boolean pass = true;
        BigDecimal[][] values = JAXRPC_Data.BigDecimal_multi_data;
        TestUtil.logMsg((String)"Passing/Returning BigDecimal multi array to/from JAXRPC Service");
        try {
            BigDecimal[][] response = this.port.bigDecimalMultiArrayTest(values);
            pass = JAXRPC_Data.compareMultiArrayValues(values, response, "BigDecimal");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(BigDecimalMultiArrayTest)");
        return pass;
    }

    private boolean JavaBeanMultiArrayTest() {
        TestUtil.logMsg((String)"MarshallJavaMultiArrayTest:(JavaBeanMultiArrayTest)");
        boolean pass = true;
        this.init_JavaBean_Data();
        JavaBean[][] values = this.JavaBean_multi_data;
        TestUtil.logMsg((String)"Passing/Returning JavaBean multi array to/from JAXRPC Service");
        try {
            JavaBean[][] response = this.port.javaBeanMultiArrayTest(values);
            pass = this.compareMultiArrayValues(values, response, "JavaBean");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "MarshallJavaMultiArrayTest:(JavaBeanMultiArrayTest)");
        return pass;
    }

    private void init_JavaBean_Data() {
        this.JavaBean_data[0].setMyBoolean(false);
        this.JavaBean_data[0].setMyByte((byte)-128);
        this.JavaBean_data[0].setMyShort((short)Short.MIN_VALUE);
        this.JavaBean_data[0].setMyInt(Integer.MIN_VALUE);
        this.JavaBean_data[0].setMyLong(Long.MIN_VALUE);
        this.JavaBean_data[0].setMyFloat(Float.MIN_VALUE);
        this.JavaBean_data[0].setMyDouble(Double.MIN_VALUE);
        this.JavaBean_data[0].setMyBoolean1(new Boolean("false"));
        this.JavaBean_data[0].setMyByte1(new Byte(-128));
        this.JavaBean_data[0].setMyShort1(new Short(Short.MIN_VALUE));
        this.JavaBean_data[0].setMyInt1(new Integer(Integer.MIN_VALUE));
        this.JavaBean_data[0].setMyLong1(new Long(Long.MIN_VALUE));
        this.JavaBean_data[0].setMyFloat1(new Float(Float.MIN_VALUE));
        this.JavaBean_data[0].setMyDouble1(new Double(Double.MIN_VALUE));
        this.JavaBean_data[0].setMyString("");
        this.JavaBean_data[0].setMyBigInteger(JAXRPC_Data.BigInteger_data[0]);
        this.JavaBean_data[0].setMyBigDecimal(JAXRPC_Data.BigDecimal_data[0]);
        this.JavaBean_data[0].setMyCalendar(JAXRPC_Data.GregorianCalendar_data[0]);
        this.JavaBean_data[0].setMyBooleanArray(JAXRPC_Data.boolean_data);
        this.JavaBean_data[0].setMyByteArray(JAXRPC_Data.byte_data);
        this.JavaBean_data[0].setMyShortArray(JAXRPC_Data.short_data);
        this.JavaBean_data[0].setMyIntArray(JAXRPC_Data.int_data);
        this.JavaBean_data[0].setMyLongArray(JAXRPC_Data.long_data);
        this.JavaBean_data[0].setMyFloatArray(JAXRPC_Data.float_data);
        this.JavaBean_data[0].setMyDoubleArray(JAXRPC_Data.double_data);
        this.JavaBean_data[0].setMyBoolean1Array(JAXRPC_Data.Boolean_data);
        this.JavaBean_data[0].setMyShort1Array(JAXRPC_Data.Short_data);
        this.JavaBean_data[0].setMyInt1Array(JAXRPC_Data.Integer_data);
        this.JavaBean_data[0].setMyLong1Array(JAXRPC_Data.Long_data);
        this.JavaBean_data[0].setMyFloat1Array(JAXRPC_Data.Float_data);
        this.JavaBean_data[0].setMyDouble1Array(JAXRPC_Data.Double_data);
        this.JavaBean_data[0].setMyStringArray(JAXRPC_Data.String_data);
        this.JavaBean_data[0].setMyStringArray(JAXRPC_Data.String_data);
        this.JavaBean_data[0].setMyBigIntegerArray(JAXRPC_Data.BigInteger_data);
        this.JavaBean_data[0].setMyBigDecimalArray(JAXRPC_Data.BigDecimal_data);
        this.JavaBean_data[0].setMyCalendarArray(JAXRPC_Data.GregorianCalendar_data);
        this.JavaBean_data[1].setMyBoolean(true);
        this.JavaBean_data[1].setMyByte((byte)127);
        this.JavaBean_data[1].setMyShort((short)Short.MAX_VALUE);
        this.JavaBean_data[1].setMyInt(Integer.MAX_VALUE);
        this.JavaBean_data[1].setMyLong(Long.MAX_VALUE);
        this.JavaBean_data[1].setMyFloat(Float.MAX_VALUE);
        this.JavaBean_data[1].setMyDouble(Double.MAX_VALUE);
        this.JavaBean_data[1].setMyBoolean1(new Boolean("true"));
        this.JavaBean_data[1].setMyByte1(new Byte(127));
        this.JavaBean_data[1].setMyShort1(new Short(Short.MAX_VALUE));
        this.JavaBean_data[1].setMyInt1(new Integer(Integer.MAX_VALUE));
        this.JavaBean_data[1].setMyLong1(new Long(Long.MAX_VALUE));
        this.JavaBean_data[1].setMyFloat1(new Float(Float.MAX_VALUE));
        this.JavaBean_data[1].setMyDouble1(new Double(Double.MAX_VALUE));
        this.JavaBean_data[1].setMyString("");
        this.JavaBean_data[1].setMyBigInteger(JAXRPC_Data.BigInteger_data[1]);
        this.JavaBean_data[1].setMyBigDecimal(JAXRPC_Data.BigDecimal_data[1]);
        this.JavaBean_data[1].setMyCalendar(JAXRPC_Data.GregorianCalendar_data[1]);
        this.JavaBean_data[1].setMyBooleanArray(JAXRPC_Data.boolean_data);
        this.JavaBean_data[1].setMyByteArray(JAXRPC_Data.byte_data);
        this.JavaBean_data[1].setMyShortArray(JAXRPC_Data.short_data);
        this.JavaBean_data[1].setMyIntArray(JAXRPC_Data.int_data);
        this.JavaBean_data[1].setMyLongArray(JAXRPC_Data.long_data);
        this.JavaBean_data[1].setMyFloatArray(JAXRPC_Data.float_data);
        this.JavaBean_data[1].setMyDoubleArray(JAXRPC_Data.double_data);
        this.JavaBean_data[1].setMyBoolean1Array(JAXRPC_Data.Boolean_data);
        this.JavaBean_data[1].setMyShort1Array(JAXRPC_Data.Short_data);
        this.JavaBean_data[1].setMyInt1Array(JAXRPC_Data.Integer_data);
        this.JavaBean_data[1].setMyLong1Array(JAXRPC_Data.Long_data);
        this.JavaBean_data[1].setMyFloat1Array(JAXRPC_Data.Float_data);
        this.JavaBean_data[1].setMyDouble1Array(JAXRPC_Data.Double_data);
        this.JavaBean_data[1].setMyStringArray(JAXRPC_Data.String_data);
        this.JavaBean_data[1].setMyStringArray(JAXRPC_Data.String_data);
        this.JavaBean_data[1].setMyBigIntegerArray(JAXRPC_Data.BigInteger_data);
        this.JavaBean_data[1].setMyBigDecimalArray(JAXRPC_Data.BigDecimal_data);
        this.JavaBean_data[1].setMyCalendarArray(JAXRPC_Data.GregorianCalendar_data);
    }

    public String toStringJavaBean(JavaBean v) {
        return "myBoolean: " + v.isMyBoolean() + ", myByte: " + v.getMyByte() + ", myShort: " + v.getMyShort() + ", myInt: " + v.getMyInt() + ", myLong: " + v.getMyLong() + ", myFloat: " + v.getMyFloat() + ", myDouble: " + v.getMyDouble() + ", myBoolean1: " + v.getMyBoolean1() + ", myByte1: " + v.getMyByte1() + ", myShort1: " + v.getMyShort1() + ", myInt1: " + v.getMyInt1() + ", myLong1: " + v.getMyLong1() + ", myFloat1: " + v.getMyFloat1() + ", myDouble1: " + v.getMyDouble1() + ", myString: " + v.getMyString() + ", myBigInteger: " + v.getMyBigInteger() + ", myBigDecimal: " + v.getMyBigDecimal() + ", myCalendar: " + v.getMyCalendar() + ", myBooleanArray: " + v.getMyBooleanArray() + ", myByteArray: " + v.getMyByteArray() + ", myShortArray: " + v.getMyShortArray() + ", myIntArray: " + v.getMyIntArray() + ", myLongArray: " + v.getMyLongArray() + ", myFloatArray: " + v.getMyFloatArray() + ", myDoubleArray: " + v.getMyDoubleArray() + ", myBoolean1Array: " + v.getMyBoolean1Array() + ", myShort1Array: " + v.getMyShort1Array() + ", myInt1Array: " + v.getMyInt1Array() + ", myLong1Array: " + v.getMyLong1Array() + ", myFloat1Array: " + v.getMyFloat1Array() + ", myDouble1Array: " + v.getMyDouble1Array() + ", myStringArray: " + v.getMyStringArray() + ", myBigIntegerArray: " + v.getMyBigIntegerArray() + ", myBigDecimalArray: " + v.getMyBigDecimalArray() + ", myCalendarArray: " + v.getMyCalendarArray();
    }

    public boolean compareJavaBeans(JavaBean e, JavaBean r) {
        return e.isMyBoolean() == r.isMyBoolean() && e.getMyByte() == r.getMyByte() && e.getMyShort() == r.getMyShort() && e.getMyInt() == r.getMyInt() && e.getMyLong() == r.getMyLong() && e.getMyFloat() == r.getMyFloat() && e.getMyDouble() == r.getMyDouble() && e.getMyBoolean1().equals(r.getMyBoolean1()) && e.getMyByte1().equals(r.getMyByte1()) && e.getMyShort1().equals(r.getMyShort1()) && e.getMyInt1().equals(r.getMyInt1()) && e.getMyLong1().equals(r.getMyLong1()) && e.getMyFloat1().equals(r.getMyFloat1()) && e.getMyDouble1().equals(r.getMyDouble1()) && e.getMyString().equals(r.getMyString()) && e.getMyBigInteger().equals(r.getMyBigInteger()) && e.getMyBigDecimal().equals(r.getMyBigDecimal()) && JAXRPC_Data.compareCalendars(e.getMyCalendar(), r.getMyCalendar()) && JAXRPC_Data.compareArrayValues(e.getMyBooleanArray(), r.getMyBooleanArray(), "boolean") && JAXRPC_Data.compareArrayValues(e.getMyByteArray(), r.getMyByteArray(), "byte") && JAXRPC_Data.compareArrayValues(e.getMyShortArray(), r.getMyShortArray(), "short") && JAXRPC_Data.compareArrayValues(e.getMyIntArray(), r.getMyIntArray(), "int") && JAXRPC_Data.compareArrayValues(e.getMyLongArray(), r.getMyLongArray(), "long") && JAXRPC_Data.compareArrayValues(e.getMyFloatArray(), r.getMyFloatArray(), "float") && JAXRPC_Data.compareArrayValues(e.getMyDoubleArray(), r.getMyDoubleArray(), "double") && JAXRPC_Data.compareArrayValues(e.getMyBoolean1Array(), r.getMyBoolean1Array(), "Boolean") && JAXRPC_Data.compareArrayValues(e.getMyShort1Array(), r.getMyShort1Array(), "Short") && JAXRPC_Data.compareArrayValues(e.getMyInt1Array(), r.getMyInt1Array(), "Integer") && JAXRPC_Data.compareArrayValues(e.getMyLong1Array(), r.getMyLong1Array(), "Long") && JAXRPC_Data.compareArrayValues(e.getMyFloat1Array(), r.getMyFloat1Array(), "Float") && JAXRPC_Data.compareArrayValues(e.getMyDouble1Array(), r.getMyDouble1Array(), "Double") && JAXRPC_Data.compareArrayValues(e.getMyStringArray(), r.getMyStringArray(), "String") && JAXRPC_Data.compareArrayValues(e.getMyBigIntegerArray(), r.getMyBigIntegerArray(), "BigInteger") && JAXRPC_Data.compareArrayValues(e.getMyBigDecimalArray(), r.getMyBigDecimalArray(), "BigDecimal") && JAXRPC_Data.compareArrayValues(e.getMyCalendarArray(), r.getMyCalendarArray(), "Calendar");
    }

    private void dumpArrayValues(Object o, String t) {
        System.out.println("JAXRPC_Data:dumpArrayValues");
        System.out.println("Dumping " + t + " array, size=" + this.getArraySize(o, t));
        if (t.equals("JavaBean")) {
            JavaBean[] v = (JavaBean[])o;
            for (int i = 0; i < v.length; ++i) {
                System.out.println("- " + this.toStringJavaBean(v[i]));
            }
        }
    }

    private void dumpMultiArrayValues(Object o, String t) {
        System.out.println("JAXRPC_Data:dumpMultiArrayValues");
        System.out.println("Dumping " + t + " multiarray, size=" + this.getMultiArraySize(o, t));
        if (t.equals("JavaBean")) {
            JavaBean[][] v = (JavaBean[][])o;
            for (int i = 0; i < v.length; ++i) {
                for (int k = 0; k < v[i].length; ++k) {
                    System.out.println("- " + this.toStringJavaBean(v[i][k]));
                }
            }
        }
    }

    private int getArraySize(Object o, String t) {
        System.out.println("JAXRPC_Data:getArraySize");
        if (t.equals("JavaBean")) {
            return ((JavaBean[])o).length;
        }
        return -1;
    }

    private String getMultiArraySize(Object o, String t) {
        System.out.println("JAXRPC_Data:getMultiArraySize");
        if (t.equals("JavaBean")) {
            JavaBean[][] m = (JavaBean[][])o;
            return "[" + m.length + "][" + m[0].length + "]";
        }
        return "unknown";
    }

    private boolean compareValues(Object e, Object r, String t) {
        boolean pass = true;
        if (t.equals("JavaBean")) {
            JavaBean rec = (JavaBean)r;
            JavaBean exp = (JavaBean)e;
            if (rec == exp) {
                return true;
            }
            if (rec == null && exp != null || rec != null && exp == null) {
                pass = false;
            } else if (!this.compareJavaBeans(exp, rec)) {
                System.out.println("Value Mismatch: expected " + this.toStringJavaBean(exp) + ", received " + this.toStringJavaBean(rec));
                pass = false;
            }
        }
        return pass;
    }

    private boolean compareArrayValues(Object e, Object r, String t) {
        System.out.println("JAXRPC_Data:compareArrayValues");
        boolean pass = true;
        if (t.equals("JavaBean")) {
            JavaBean[] rec = (JavaBean[])r;
            JavaBean[] exp = (JavaBean[])e;
            if (rec.length != exp.length) {
                System.out.println("Array Size MisMatch: expected " + exp.length + ", received " + rec.length);
                pass = false;
            }
            for (int i = 0; i < rec.length; ++i) {
                if (rec[i] == exp[i]) continue;
                if (rec[i] == null && exp[i] != null || rec[i] != null && exp[i] == null) {
                    pass = false;
                    continue;
                }
                if (this.compareJavaBeans(exp[i], rec[i])) continue;
                System.out.println("Array Mismatch: expected " + this.toStringJavaBean(exp[i]) + ", received " + this.toStringJavaBean(rec[i]));
                pass = false;
            }
        }
        return pass;
    }

    private boolean compareMultiArrayValues(Object e, Object r, String t) {
        System.out.println("JAXRPC_Data:compareMultiArrayValues");
        boolean pass = true;
        if (t.equals("JavaBean")) {
            JavaBean[][] rec = (JavaBean[][])r;
            JavaBean[][] exp = (JavaBean[][])e;
            if (rec.length != exp.length) {
                System.out.println("Multi Array Size MisMatch: expected " + exp.length + ", received " + rec.length);
                pass = false;
            }
            for (int i = 0; i < rec.length; ++i) {
                if (rec[i].length != exp[i].length) {
                    System.out.println("Multi Array Size MisMatch: expected " + exp[i].length + ", received " + rec[i].length);
                    pass = false;
                    continue;
                }
                for (int k = 0; k < rec[i].length; ++k) {
                    if (rec[i][k] == exp[i][k]) continue;
                    if (rec[i][k] == null && exp[i][k] != null && rec[i][k] != null && exp[i][k] == null) {
                        pass = false;
                        continue;
                    }
                    if (this.compareJavaBeans(exp[i][k], exp[i][k])) continue;
                    System.out.println("Array Mismatch: expected " + this.toStringJavaBean(exp[i][k]) + ", received " + this.toStringJavaBean(rec[i][k]));
                    pass = false;
                }
            }
        }
        return pass;
    }

    private String returnArrayValues(Object o, String t) {
        String values = null;
        if (t.equals("JavaBean")) {
            JavaBean[] v = (JavaBean[])o;
            for (int i = 0; i < v.length; ++i) {
                values = values + ", " + this.toStringJavaBean(v[i]);
            }
        }
        return values;
    }

    private String returnMultiArrayValues(Object o, String t) {
        String values = null;
        if (t.equals("JavaBean")) {
            JavaBean[][] v = (JavaBean[][])o;
            for (int i = 0; i < v.length; ++i) {
                for (int k = 0; k < v[i].length; ++k) {
                    values = values + ", " + this.toStringJavaBean(v[i][k]);
                }
            }
        }
        return values;
    }
}

