/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.wsi.document.literal.httptest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.wsi.document.literal.httptest.Hello;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.wsi.document.literal.httptest.";
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";
    private static final String NAMESPACE_URI = "http://httptestservice.org/wsdl";
    private static final String SERVICE_NAME = "HttpTestService";
    private static final String PORT_NAME = "HelloPort";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private static final Class PORT_CLASS = Hello.class;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private String username = null;
    private String password = null;
    private static final String ENDPOINT_URL = "wsidlhttptest.endpoint.1";
    private static final String WSDLLOC_URL = "wsidlhttptest.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    String GoodSoapMessage = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ns=\"http://httptestservice.org/types\"><soap:Body><ns:HelloRequestElement><string>World</string></ns:HelloRequestElement></soap:Body></soap:Envelope>";
    String GoodSoapMessageNoXMLDeclaration = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ns=\"http://httptestservice.org/types\"><soap:Body><ns:HelloRequestElement><string>World</string></ns:HelloRequestElement></soap:Body></soap:Envelope>";
    String GoodOneWaySoapMessage = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ns=\"http://httptestservice.org/types\"><soap:Body><ns:HelloOneWayElement><string>World</string></ns:HelloOneWayElement></soap:Body></soap:Envelope>";
    String GoodOneWaySoapMessageNoXMLDeclaration = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ns=\"http://httptestservice.org/types\"><soap:Body><ns:HelloOneWayElement><string>World</string></ns:HelloOneWayElement></soap:Body></soap:Envelope>";
    String SoapMessageUsingUTF16Encoding = "<?xml version=\"1.0\" encoding=\"utf-16\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ns=\"http://httptestservice.org/types\"><soap:Body><ns:HelloRequestElement><string>World</string></ns:HelloRequestElement></soap:Body></soap:Envelope>";
    Hello port = null;
    Stub stub = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getTestURLfromStub() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        this.url = (String)this.stub._getProperty("javax.xml.rpc.service.endpoint.address");
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
    }

    private void getStubJaxrpc() throws Exception {
        TestUtil.logMsg((String)"Get stub from service implementation class using JAXRPC porting instance");
        this.port = (Hello)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.wsi.document.literal.httptest.HttpTestService", "getHelloPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getStub() throws Exception {
        InitialContext ctx = new InitialContext();
        TestUtil.logMsg((String)"Obtained InitialContext");
        TestUtil.logMsg((String)"Lookup java:comp/env/service/wsidlhttptest");
        Service svc = (Service)ctx.lookup("java:comp/env/service/wsidlhttptest");
        TestUtil.logMsg((String)"Obtained service");
        this.port = (Hello)svc.getPort(Hello.class);
        TestUtil.logMsg((String)"Obtained port");
        TestUtil.logMsg((String)"Cast port to base Stub class");
        this.stub = (Stub)this.port;
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName(NAMESPACE_URI, SERVICE_NAME);
        this.PORT_QNAME = new QName(NAMESPACE_URI, PORT_NAME);
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.username = p.getProperty(USERNAME);
            this.password = p.getProperty(PASSWORD);
            TestUtil.logMsg((String)"Creating stub instance ...");
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubJaxrpc();
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
                JAXRPC_Util.setSOAPLogging(this.stub, System.out);
            } else {
                this.getStub();
                this.getTestURLfromStub();
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void TestGoodSoapMessage() throws EETest.Fault {
        boolean pass = true;
        Object iterator = null;
        try {
            TestUtil.logMsg((String)"TestGoodSoapMessage");
            TestUtil.logMsg((String)"Send good SOAP RPC request (expect 2xx status code)");
            HttpURLConnection conn = this.openHttpConnection(this.url);
            int httpStatusCode = this.sendRequest(conn, this.GoodSoapMessage);
            this.closeHttpConnection(conn);
            if (httpStatusCode < 200 || httpStatusCode > 299) {
                TestUtil.logErr((String)("Expected 2xx status code, instead got " + httpStatusCode));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected 2xx status code of " + httpStatusCode));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TestGoodSoapMessage failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("TestGoodSoapMessage failed");
        }
    }

    public void TestGoodSoapMessageNoXMLDeclaration() throws EETest.Fault {
        boolean pass = true;
        Object iterator = null;
        try {
            TestUtil.logMsg((String)"TestGoodSoapMessageNoXMLDeclaration");
            TestUtil.logMsg((String)"Send good SOAP RPC request (expect 2xx status code)");
            HttpURLConnection conn = this.openHttpConnection(this.url);
            int httpStatusCode = this.sendRequest(conn, this.GoodSoapMessageNoXMLDeclaration);
            this.closeHttpConnection(conn);
            if (httpStatusCode < 200 || httpStatusCode > 299) {
                TestUtil.logErr((String)("Expected 2xx status code, instead got " + httpStatusCode));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected 2xx status code of " + httpStatusCode));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TestGoodSoapMessageNoXMLDeclaration failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("TestGoodSoapMessageNoXMLDeclaration failed");
        }
    }

    public void TestGoodOneWaySoapMessage() throws EETest.Fault {
        boolean pass = true;
        Object iterator = null;
        try {
            TestUtil.logMsg((String)"TestGoodOneWaySoapMessage");
            TestUtil.logMsg((String)"Send good SOAP RPC request (expect 2xx status code)");
            HttpURLConnection conn = this.openHttpConnection(this.url);
            int httpStatusCode = this.sendRequest(conn, this.GoodOneWaySoapMessage);
            this.closeHttpConnection(conn);
            if (httpStatusCode < 200 || httpStatusCode > 299) {
                TestUtil.logErr((String)("Expected 2xx status code, instead got " + httpStatusCode));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected 2xx status code of " + httpStatusCode));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TestGoodOneWaySoapMessage failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("TestGoodOneWaySoapMessage failed");
        }
    }

    public void TestGoodOneWaySoapMessageNoXMLDeclaration() throws EETest.Fault {
        boolean pass = true;
        Object iterator = null;
        try {
            TestUtil.logMsg((String)"TestGoodOneWaySoapMessageNoXMLDeclaration");
            TestUtil.logMsg((String)"Send good SOAP RPC request (expect 2xx status code)");
            HttpURLConnection conn = this.openHttpConnection(this.url);
            int httpStatusCode = this.sendRequest(conn, this.GoodOneWaySoapMessageNoXMLDeclaration);
            this.closeHttpConnection(conn);
            if (httpStatusCode < 200 || httpStatusCode > 299) {
                TestUtil.logErr((String)("Expected 2xx status code, instead got " + httpStatusCode));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected 2xx status code of " + httpStatusCode));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TestGoodOneWaySoapMessageNoXMLDeclaration failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("TestGoodOneWaySoapMessageNoXMLDeclaration failed");
        }
    }

    public void TestSoapMessageUsingUTF16Encoding() throws EETest.Fault {
        boolean pass = true;
        Object iterator = null;
        try {
            TestUtil.logMsg((String)"TestSoapMessageUsingUTF16Encoding");
            TestUtil.logMsg((String)"Send SOAP RPC request using utf-16 encoding (expect 2xx status code)");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)baos, "utf-16");
            out.write(this.SoapMessageUsingUTF16Encoding);
            out.flush();
            out.close();
            boolean debug = false;
            if (debug) {
                FileOutputStream faos = new FileOutputStream("/tmp/foo");
                out = new OutputStreamWriter((OutputStream)faos, "utf-16");
                out.write(this.SoapMessageUsingUTF16Encoding);
                out.flush();
                out.close();
                faos.close();
            }
            TestUtil.logMsg((String)("Original SOAP message length=" + this.SoapMessageUsingUTF16Encoding.length()));
            TestUtil.logMsg((String)("Encoded SOAP message length=" + baos.toByteArray().length));
            HttpURLConnection conn = this.openHttpConnection(this.url);
            conn.setRequestProperty("Content-Type", "text/xml; charset=\"utf-16\"");
            int httpStatusCode = this.sendRequest(conn, baos.toByteArray());
            this.closeHttpConnection(conn);
            if (httpStatusCode < 200 || httpStatusCode > 299) {
                TestUtil.logErr((String)("Expected 2xx status code, instead got " + httpStatusCode));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected 2xx status code of " + httpStatusCode));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("TestSoapMessageUsingUTF16Encoding failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("TestSoapMessageUsingUTF16Encoding failed");
        }
    }

    private HttpURLConnection openHttpConnection(String s) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(s).openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("HTTP-Version", "HTTP/1.1");
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("SOAPAction", "\"\"");
        return conn;
    }

    private void closeHttpConnection(HttpURLConnection conn) throws IOException {
        conn.disconnect();
    }

    private int sendRequest(HttpURLConnection conn, String request) throws IOException {
        TestUtil.logMsg((String)("Request=" + request));
        return this._sendRequest(conn, request.getBytes());
    }

    private int sendRequest(HttpURLConnection conn, byte[] request) throws IOException {
        TestUtil.logMsg((String)("Request=" + request));
        return this._sendRequest(conn, request);
    }

    private int _sendRequest(HttpURLConnection conn, byte[] data) throws IOException {
        InputStream istream;
        int length = data.length;
        conn.setRequestProperty("Content-Length", new Integer(data.length).toString());
        OutputStream outputStream = conn.getOutputStream();
        outputStream.write(data);
        boolean isFailure = true;
        int responseCode = conn.getResponseCode();
        String responseMessage = conn.getResponseMessage();
        TestUtil.logMsg((String)("ResponseCode=" + responseCode));
        TestUtil.logMsg((String)("ResponseMessage=" + responseMessage));
        if (responseCode == 200) {
            isFailure = false;
        }
        InputStream inputStream = istream = !isFailure ? conn.getInputStream() : conn.getErrorStream();
        if (istream != null) {
            String response = null;
            String buf = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
            while ((buf = reader.readLine()) != null) {
                if (response != null) {
                    response = response + buf;
                    continue;
                }
                response = buf;
            }
        }
        return responseCode;
    }
}

