/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.invocationcontext;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.common.invocationcontext.InvocationContextIF;
import java.util.Arrays;
import java.util.Map;
import javax.interceptor.InvocationContext;

public class InvocationContextTestImpl {
    private static final String[] paramsNew = new String[]{"new", "new"};
    private static final String[] paramsOld = new String[]{"old", "old"};
    private static final String paramsCombined = "newnew";

    private InvocationContextTestImpl() {
    }

    public static void interceptAll(InvocationContext inv) throws TestFailedException {
        InvocationContextTestImpl impl = new InvocationContextTestImpl();
        String methodName = inv.getMethod().getName();
        if ("setParametersIllegalArgumentExceptionForNumber".equals(methodName)) {
            impl.setParametersIllegalArgumentExceptionForNumber(inv, methodName);
        } else if ("setParametersIllegalArgumentExceptionForChar".equals(methodName)) {
            impl.setParametersIllegalArgumentExceptionForChar(inv, methodName);
        } else if ("setParametersIllegalArgumentExceptionForString".equals(methodName)) {
            impl.setParametersIllegalArgumentExceptionForString(inv, methodName);
        } else if ("setParametersIllegalArgumentExceptionForStringArray".equals(methodName)) {
            impl.setParametersIllegalArgumentExceptionForStringArray(inv, methodName);
        } else if ("setParametersIllegalArgumentExceptionForShortLong".equals(methodName)) {
            impl.setParametersIllegalArgumentExceptionForShortLong(inv, methodName);
        } else if ("proceedAgain".equals(methodName)) {
            impl.proceedAgain(inv, methodName);
        } else if ("getTarget".equals(methodName)) {
            impl.getTarget(inv, methodName);
        } else if ("getSetParametersEmpty".equals(methodName)) {
            impl.getSetParametersEmpty(inv, methodName);
        } else if ("getSetParameters".equals(methodName)) {
            impl.getSetParameters(inv, methodName);
        } else if ("getContextData".equals(methodName)) {
            impl.getContextData(inv, methodName);
        } else if ("getTimer".equals(methodName)) {
            impl.getTimer(inv, methodName);
        }
    }

    private void getTimer(InvocationContext inv, String methodName) throws TestFailedException {
        Object t = inv.getTimer();
        if (t != null) {
            throw new TestFailedException("Expecting null from getTimer(), but got " + t);
        }
    }

    private void handleException(Exception exception) throws TestFailedException {
        if (exception != null) {
            if (exception instanceof TestFailedException) {
                throw (TestFailedException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TestFailedException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getContextData(InvocationContext inv, String methodName) throws TestFailedException {
        Object result = null;
        Exception exception = null;
        Map contextData = inv.getContextData();
        String key = "one";
        Integer data = 1;
        contextData.put(key, data);
        try {
            result = inv.proceed();
            if (result != null) {
                throw new TestFailedException("Expecting proceed() to return null.");
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            this.handleException(exception);
            Object actual = inv.getContextData().get(key);
            if (!((Object)data).equals(actual)) {
                throw new TestFailedException("Expecting " + data + " from getContextData, but got " + actual);
            }
            Helper.getLogger().info("Got expected data from getContextData:" + actual);
        }
    }

    private void getSetParameters(InvocationContext inv, String methodName) throws TestFailedException {
        Object[] params = inv.getParameters();
        if (!Arrays.equals(params, paramsOld)) {
            throw new TestFailedException("Expecting " + Arrays.asList(paramsOld) + ", actual " + Arrays.asList(params));
        }
        inv.setParameters((Object[])paramsNew);
    }

    private void getSetParametersEmpty(InvocationContext inv, String methodName) throws TestFailedException {
        Object[] params = inv.getParameters();
        if (params != null && params.length != 0) {
            throw new TestFailedException("Expecting null/empty from InvocationContext.getParameters(), but got " + params);
        }
        Helper.getLogger().info("Got expected null/empty params from InvocationContext.getParameters()");
        try {
            inv.setParameters(new Object[]{Boolean.TRUE});
            throw new TestFailedException("Expecting IllegalArgumentException from InvocationContext.setParameters, but got none.");
        }
        catch (IllegalArgumentException e) {
            Helper.getLogger().info("Got expected IllegalArgumentException from InvocationContext.setParameters");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTarget(InvocationContext inv, String methodName) throws TestFailedException {
        int id1 = System.identityHashCode(inv.getTarget());
        int id2 = 0;
        Exception exception = null;
        try {
            id2 = (Integer)inv.proceed();
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            this.handleException(exception);
            if (id1 != id2) {
                throw new TestFailedException("target1: " + id1 + ", and target2" + id2 + " are not the same bean instance.");
            }
            Helper.getLogger().info("Got the expected bean instance from getTarget(): " + id1);
        }
    }

    private void proceedAgain(InvocationContext inv, String methodName) throws TestFailedException {
        Object result = null;
        try {
            result = inv.proceed();
            throw new TestFailedException("Expecting TestFailedException, but got none.");
        }
        catch (TestFailedException e) {
            Helper.getLogger().info("Got expected TestFailedException in the 1st proceed call: " + e);
            Object[] params = inv.getParameters();
            params[0] = 1;
            try {
                result = inv.proceed();
            }
            catch (Exception ee) {
                throw new TestFailedException("Unexpected exception: ", e);
            }
        }
        catch (Exception e) {
            throw new TestFailedException("Expecting TestFailedException, but got ", e);
        }
    }

    private void setParametersIllegalArgumentExceptionForNumber(InvocationContext inv, String methodName) throws TestFailedException {
        String reason = "";
        Object[] objects = null;
        try {
            inv.setParameters(null);
            throw new TestFailedException("Didn't get IllegalArgumentException when setParameters(null).  The original business method is " + methodName);
        }
        catch (IllegalArgumentException e) {
            reason = "Got expected IllegalArgumentException when setParameters(null).  The original business method is " + methodName;
            Helper.getLogger().info(reason);
            try {
                objects = new Object[]{new Integer(0)};
                inv.setParameters(objects);
                throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
            }
            catch (IllegalArgumentException e2) {
                reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                Helper.getLogger().info(reason);
                try {
                    objects = new Object[]{new Integer(0), new Integer(1), new Integer(2)};
                    inv.setParameters(objects);
                    throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
                }
                catch (IllegalArgumentException e3) {
                    reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                    Helper.getLogger().info(reason);
                    try {
                        objects = new Object[]{"a", "b"};
                        inv.setParameters(objects);
                        throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
                    }
                    catch (IllegalArgumentException e4) {
                        reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                        Helper.getLogger().info(reason);
                        Object[] ints = new Integer[]{5, 5};
                        inv.setParameters(ints);
                        Object[] paramsAgain = inv.getParameters();
                        if (!Arrays.equals(ints, paramsAgain)) {
                            throw new TestFailedException("Expecting " + Arrays.asList(ints) + "when getParameters() after setParameters(...), but got " + paramsAgain);
                        }
                        return;
                    }
                }
            }
        }
    }

    private void setParametersIllegalArgumentExceptionForChar(InvocationContext inv, String methodName) throws TestFailedException {
        String reason = "";
        Object[] objects = null;
        try {
            inv.setParameters(null);
            throw new TestFailedException("Didn't get IllegalArgumentException when setParameters(null).  The original business method is " + methodName);
        }
        catch (IllegalArgumentException e) {
            reason = "Got expected IllegalArgumentException when setParameters(null).  The original business method is " + methodName;
            Helper.getLogger().info(reason);
            try {
                objects = new Object[]{new Character('0')};
                inv.setParameters(objects);
                throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
            }
            catch (IllegalArgumentException e2) {
                reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                Helper.getLogger().info(reason);
                try {
                    objects = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2')};
                    inv.setParameters(objects);
                    throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
                }
                catch (IllegalArgumentException e3) {
                    reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                    Helper.getLogger().info(reason);
                    try {
                        objects = new Object[]{"a", "b"};
                        inv.setParameters(objects);
                        throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
                    }
                    catch (IllegalArgumentException e4) {
                        reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                        Helper.getLogger().info(reason);
                        objects = new Object[]{new Character('5'), new Character('5')};
                        inv.setParameters(objects);
                        Object[] paramsAgain = inv.getParameters();
                        if (!Arrays.equals(objects, paramsAgain)) {
                            throw new TestFailedException("Expecting " + Arrays.asList(objects) + "when getParameters() after setParameters(...), but got " + paramsAgain);
                        }
                        return;
                    }
                }
            }
        }
    }

    private void setParametersIllegalArgumentExceptionForString(InvocationContext inv, String methodName) throws TestFailedException {
        String reason = "";
        Object[] objects = null;
        try {
            inv.setParameters(null);
            throw new TestFailedException("Didn't get IllegalArgumentException when setParameters(null).  The original business method is " + methodName);
        }
        catch (IllegalArgumentException e) {
            reason = "Got expected IllegalArgumentException when setParameters(null).  The original business method is " + methodName;
            Helper.getLogger().info(reason);
            try {
                objects = new Object[]{"0"};
                inv.setParameters(objects);
                throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
            }
            catch (IllegalArgumentException e2) {
                reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                Helper.getLogger().info(reason);
                try {
                    objects = new String[]{"", "", ""};
                    inv.setParameters(objects);
                    throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
                }
                catch (IllegalArgumentException e3) {
                    reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                    Helper.getLogger().info(reason);
                    try {
                        objects = new Object[]{new Object(), new Object()};
                        inv.setParameters(objects);
                        throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
                    }
                    catch (IllegalArgumentException e4) {
                        reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                        Helper.getLogger().info(reason);
                        objects = new Object[]{null, null};
                        inv.setParameters(objects);
                        Object[] paramsAgain = inv.getParameters();
                        if (!Arrays.equals(objects, paramsAgain)) {
                            throw new TestFailedException("Expecting " + Arrays.asList(objects) + "when getParameters() after setParameters(...), but got " + paramsAgain);
                        }
                        return;
                    }
                }
            }
        }
    }

    private void setParametersIllegalArgumentExceptionForStringArray(InvocationContext inv, String methodName) throws TestFailedException {
        String reason = "";
        Object[] objects = null;
        try {
            inv.setParameters(null);
            throw new TestFailedException("Didn't get IllegalArgumentException when setParameters(null).  The original business method is " + methodName);
        }
        catch (IllegalArgumentException e) {
            reason = "Got expected IllegalArgumentException when setParameters(null).  The original business method is " + methodName;
            Helper.getLogger().info(reason);
            try {
                objects = new String[]{"0"};
                inv.setParameters(objects);
                throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
            }
            catch (IllegalArgumentException e2) {
                reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                Helper.getLogger().info(reason);
                try {
                    objects = new Object[]{new Object[]{"0"}};
                    inv.setParameters(objects);
                    throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
                }
                catch (IllegalArgumentException e3) {
                    reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                    Helper.getLogger().info(reason);
                    try {
                        objects = new Object[]{new Object()};
                        inv.setParameters(objects);
                        throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
                    }
                    catch (IllegalArgumentException e4) {
                        reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                        Helper.getLogger().info(reason);
                        objects = new Object[]{new String[]{null}};
                        inv.setParameters(objects);
                        Object[] paramsAgain = inv.getParameters();
                        if (!Arrays.equals(objects, paramsAgain)) {
                            throw new TestFailedException("Expecting " + Arrays.asList(objects) + "when getParameters() after setParameters(...), but got " + paramsAgain);
                        }
                        return;
                    }
                }
            }
        }
    }

    private void setParametersIllegalArgumentExceptionForShortLong(InvocationContext inv, String methodName) throws TestFailedException {
        String reason = "";
        Object[] objects = null;
        try {
            objects = new Object[]{-32769, new Long(1L)};
            inv.setParameters(objects);
            throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
        }
        catch (IllegalArgumentException e) {
            reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
            Helper.getLogger().info(reason);
            try {
                objects = new Object[]{Integer.MAX_VALUE, new Long(1L)};
                inv.setParameters(objects);
                throw new TestFailedException("Didn't get IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName);
            }
            catch (IllegalArgumentException e2) {
                reason = "Got expected IllegalArgumentException when setParameters to " + Arrays.asList(objects) + ".  The original business method is " + methodName;
                Helper.getLogger().info(reason);
                objects = new Object[]{(short)5, 5L};
                inv.setParameters(objects);
                Object[] paramsAgain = inv.getParameters();
                if (!Arrays.equals(objects, paramsAgain)) {
                    throw new TestFailedException("Expecting " + Arrays.asList(objects) + "when getParameters() after setParameters(...), but got " + paramsAgain);
                }
                Helper.getLogger().info("Got expected values from getParameters(): " + Arrays.toString(paramsAgain));
                return;
            }
        }
    }

    public static void setParametersIllegalArgumentException(InvocationContextIF[] beans) throws TestFailedException {
        for (InvocationContextIF b : beans) {
            InvocationContextTestImpl.setParametersIllegalArgumentExceptionForNumber0(b);
            InvocationContextTestImpl.setParametersIllegalArgumentExceptionForChar0(b);
            InvocationContextTestImpl.setParametersIllegalArgumentExceptionForString0(b);
            InvocationContextTestImpl.setParametersIllegalArgumentExceptionForStringArray0(b);
            InvocationContextTestImpl.setParametersIllegalArgumentExceptionForShortLong0(b);
        }
    }

    public static void getTarget(InvocationContextIF[] beans) throws TestFailedException {
        for (InvocationContextIF b : beans) {
            Helper.getLogger().info(String.format("bean instance from getTarget(): %s", b.getTarget()));
        }
    }

    public static void getContextData(InvocationContextIF[] beans) throws TestFailedException {
        for (InvocationContextIF b : beans) {
            b.getContextData();
        }
    }

    public static void getSetParametersEmpty(InvocationContextIF[] beans) throws TestFailedException {
        for (InvocationContextIF b : beans) {
            b.getSetParametersEmpty();
        }
    }

    public static void getSetParameters(InvocationContextIF[] beans) throws TestFailedException {
        for (InvocationContextIF b : beans) {
            String result = b.getSetParameters(paramsOld[0], paramsOld[1]);
            if (!result.equals(paramsCombined)) {
                throw new TestFailedException("Expecting newnew, actual, " + result + ", from bean " + b);
            }
            Helper.getLogger().info("Got expected result after InvocationContext.setParameters: " + result + ", from bean " + b);
        }
    }

    public static void proceedAgain(InvocationContextIF[] beans) throws TestFailedException {
        for (InvocationContextIF b : beans) {
            if (!b.proceedAgain(0)) {
                throw new TestFailedException("Expecting true from proceedAgain, but got false from bean " + b);
            }
            Helper.getLogger().info("Got expected result from calling proceed twice: true from bean " + b);
        }
    }

    public static void getTimer(InvocationContextIF[] beans) throws TestFailedException {
        for (InvocationContextIF b : beans) {
            b.getTimer();
        }
    }

    private static void setParametersIllegalArgumentExceptionForNumber0(InvocationContextIF bean) throws TestFailedException {
        Integer m = 8;
        Integer n = 9;
        Object[] result = null;
        Object[] expected = new Number[]{5, 5};
        if (!Arrays.equals(expected, result = bean.setParametersIllegalArgumentExceptionForNumber(m, n))) {
            throw new RuntimeException("Expecting " + Arrays.asList(expected) + ", but the actual result is " + Arrays.asList(result) + " from bean " + bean);
        }
        Helper.getLogger().info("Got expected return value " + Arrays.asList(result) + " from bean " + bean);
    }

    private static void setParametersIllegalArgumentExceptionForChar0(InvocationContextIF bean) throws TestFailedException {
        char m = '8';
        char n = '9';
        char[] result = null;
        char[] expected = new char[]{'5', '5'};
        result = bean.setParametersIllegalArgumentExceptionForChar(m, n);
        if (!Arrays.equals(expected, result)) {
            throw new TestFailedException("Expecting " + Arrays.asList(new char[][]{expected}) + ", but the actual result is " + Arrays.asList(new char[][]{result}) + " from bean " + bean);
        }
        Helper.getLogger().info("Got expected return value " + Arrays.asList(new char[][]{result}) + " from bean " + bean);
    }

    private static void setParametersIllegalArgumentExceptionForString0(InvocationContextIF bean) throws TestFailedException {
        String m = "8";
        String n = "9";
        Object[] result = null;
        Object[] expected = new String[]{null, null};
        result = bean.setParametersIllegalArgumentExceptionForString(m, n);
        if (!Arrays.equals(expected, result)) {
            throw new TestFailedException("Expecting " + Arrays.asList(expected) + ", but the actual result is " + Arrays.asList(result) + " from bean " + bean);
        }
        Helper.getLogger().info("Got expected return value " + Arrays.asList(result) + " from bean " + bean);
    }

    private static void setParametersIllegalArgumentExceptionForStringArray0(InvocationContextIF bean) throws TestFailedException {
        String m = "8";
        String[] strings = new String[]{m};
        Object[] result = null;
        Object[] expected = new String[]{null};
        result = bean.setParametersIllegalArgumentExceptionForStringArray(strings);
        if (!Arrays.equals(expected, result)) {
            throw new TestFailedException("Expecting " + Arrays.asList(expected) + ", but the actual result is " + Arrays.asList(result) + " from bean " + bean);
        }
        Helper.getLogger().info("Got expected return value " + Arrays.asList(result) + " from bean " + bean);
    }

    private static void setParametersIllegalArgumentExceptionForShortLong0(InvocationContextIF bean) throws TestFailedException {
        short m = 0;
        long n = 1L;
        Number[] result = null;
        Number[] expected = new Number[]{new Byte(5), new Integer(5)};
        result = bean.setParametersIllegalArgumentExceptionForShortLong(m, n);
        if (result == null || result.length != 2 || result[0] == null || result[1] == null || result[0].intValue() != expected[0].intValue() || result[1].intValue() != expected[1].intValue()) {
            throw new TestFailedException("Expecting " + Arrays.asList(expected) + ", but the actual result is " + Arrays.asList(result) + " from bean " + bean);
        }
        Helper.getLogger().info("Got expected return value " + Arrays.asList(result) + " from bean " + bean);
    }
}

