/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.ByteArrayHolder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Data;
import java.util.Properties;
import javax.xml.rpc.holders.ByteArrayHolder;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private static final byte[] myByteArray = new byte[]{-128, 0, 127};

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void ByteArrayHolderConstructorTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"ByteArrayHolderConstructorTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via ByteArrayHolder() ...");
            ByteArrayHolder n = new ByteArrayHolder();
            if (n != null) {
                TestUtil.logMsg((String)"ByteArrayHolder object created successfully");
            } else {
                TestUtil.logErr((String)"ByteArrayHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("ByteArrayHolderConstructorTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("ByteArrayHolderConstructorTest1 failed");
        }
    }

    public void ByteArrayHolderConstructorTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"ByteArrayHolderConstructorTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via ByteArrayHolder(byte[]) ...");
            ByteArrayHolder n = new ByteArrayHolder(myByteArray);
            if (n != null) {
                TestUtil.logMsg((String)"ByteArrayHolder object created successfully");
            } else {
                TestUtil.logErr((String)"ByteArrayHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("ByteArrayHolderConstructorTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("ByteArrayHolderConstructorTest2 failed");
        }
    }

    public void getValueTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest");
        boolean pass = true;
        if (!this.getValueTest1()) {
            pass = false;
        }
        if (!this.getValueTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getValueTest failed");
        }
    }

    private boolean getValueTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via ByteArrayHolder() ...");
            ByteArrayHolder n = new ByteArrayHolder();
            if (n != null) {
                byte[] v = n.value;
                if (v == null) {
                    TestUtil.logMsg((String)"Value set to null as expected");
                } else {
                    TestUtil.logErr((String)("Value: expected - null, received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"ByteArrayHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean getValueTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via ByteArrayHolder(byte[]) ...");
            ByteArrayHolder n = new ByteArrayHolder(myByteArray);
            if (n != null) {
                byte[] v = n.value;
                pass = JAXRPC_Data.compareArrayValues(myByteArray, v, "byte");
            } else {
                TestUtil.logErr((String)"ByteArrayHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

