/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.bmp.pkey;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.variants.CompoundPK;
import com.sun.ts.tests.common.dao.coffee.variants.CompoundPKCoffeeDAO;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class CompoundBeanEJB
implements EntityBean {
    private float cofPrice;
    protected TSNamingContext nctx = null;
    protected EntityContext ectx = null;
    protected CompoundPKCoffeeDAO dao = null;

    public void ping() {
    }

    public CompoundPK ejbCreate(Properties props, CompoundPK cofID, String cofName, float cofPrice) throws CreateException {
        try {
            TestUtil.logTrace((String)"[CompoundBean] ejbCreate()");
            TestUtil.logTrace((String)"[CompoundBean] Initialize remote logging");
            TestUtil.init((Properties)props);
            TestUtil.logMsg((String)"[CompoundBean] DBSupport Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCompoundPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[CompoundBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[CompoundBean] Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cofPrice = cofPrice;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[CompoundBean] Caught exception: " + e), (Throwable)e);
            throw new CreateException("Cannot create bean: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return cofID;
    }

    public void ejbPostCreate(Properties props, CompoundPK cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"[CompoundBean] ejbPostCreate()");
    }

    public void setEntityContext(EntityContext c) throws EJBException {
        TestUtil.logTrace((String)"[CompoundBean] setEntityContext()");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"[CompoundBean] Obtaining TS Naming Context...");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("[CompoundBean] Naming Exception : " + e), (Throwable)e);
            throw new EJBException("Cannot obtain Naming Context" + e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[CompoundBean] Caught exception: " + e), (Throwable)e);
            throw new EJBException("Caught exception: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"[CompoundBean] unsetEntityContext()");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"[CompoundBean] ejbRemove()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[CompoundBean] Initialize DBSupport...");
                this.dao = DAOFactory.getInstance().getCompoundPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[CompoundBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[CompoundBean] Remove row...");
            this.dao.delete((CompoundPK)this.ectx.getPrimaryKey());
        }
        catch (Exception e) {
            TestUtil.logErr((String)("[CompoundBean] Caught Exception: " + e), (Throwable)e);
            throw new RemoveException("Cannot remove bean: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"[CompoundBean] ejbActivate()");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"[CompoundBean] ejbPassivate()");
    }

    public void ejbLoad() throws EJBException {
        TestUtil.logTrace((String)"[CompoundBean] ejbLoad()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[CompoundBean] Initialize DBSupport()");
                this.dao = DAOFactory.getInstance().getCompoundPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[CompoundBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[CompoundBean] Load row...");
            this.cofPrice = this.dao.loadPrice((CompoundPK)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            TestUtil.logErr((String)"[CompoundBean] No such entity exists: ", (Throwable)e);
            throw new NoSuchEntityException("[ejbLoad] DAOException" + e);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("[ejbLoad] Unexpected exception" + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbStore() throws EJBException {
        TestUtil.logTrace((String)"[CompoundBean] ejbStore()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[CompoundBean] Initializing DBSupport...");
                this.dao = DAOFactory.getInstance().getCompoundPKCoffeeDAO();
            }
            TestUtil.logTrace((String)"[CompoundBean] Get DB connection...");
            this.dao.startSession();
            TestUtil.logTrace((String)"[CompoundBean] Store row...");
            this.dao.storePrice((CompoundPK)this.ectx.getPrimaryKey(), this.cofPrice);
        }
        catch (DAOException e) {
            TestUtil.logErr((String)("[CompoundBean] No such entity" + e.getCause()), (Throwable)e);
            throw new NoSuchEntityException("[ejbStore] DAOException" + e);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("[ejbStore] Unable to init DBSupport");
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public CompoundPK ejbFindByPrimaryKey(CompoundPK key) throws FinderException {
        TestUtil.logTrace((String)"[CompoundBean] ejbFindByPrimaryKey()");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"[CompoundBean] Initializing DBSupport...");
                this.dao = DAOFactory.getInstance().getCompoundPKCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                CompoundPK compoundPK = key;
                return compoundPK;
            }
            try {
                throw new FinderException("[CompoundBean] Key not found: " + key);
            }
            catch (DAOException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("DAOException " + e.getCause());
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }
}

