/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.ee.platform.negdep.multi.ee;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.negdep.NegdepUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class multiClient
extends ServiceEETest {
    protected NegdepUtil ndu;
    protected String baseAppDir;
    protected Properties testProps;

    public static void main(String[] args) {
        multiClient theTests = new multiClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"Setup");
        this.testProps = p;
        this.baseAppDir = this.testProps.getProperty("ts_home") + "/src/com/sun/ts/tests/servlet/ee/platform/negdep/multi/apps/";
        this.ndu = new NegdepUtil(this.testProps);
    }

    public void cleanup() throws EETest.Fault {
        this.ndu.cleanup();
    }

    public void multiSessionConfigTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Starting multiSessionConfigTest");
        boolean pass = false;
        String appDir = this.baseAppDir + "session-config/";
        String badModuleName = appDir + "BadSessionConfig.war";
        String goodModuleName = appDir + "GoodSessionConfig.war";
        String badPlanName = appDir + "servlet_ee_platform_negdep_multi_apps_badsession-config_web.war.sun-web.xml";
        String goodPlanName = appDir + "servlet_ee_platform_negdep_multi_apps_goodsession-config_web.war.sun-web.xml";
        try {
            FileInputStream badModuleStream = new FileInputStream(new File(badModuleName));
            FileInputStream goodModuleStream = new FileInputStream(new File(goodModuleName));
            InputStream badPlanStream = this.ndu.getDeploymentPlan(badModuleName, new String[]{badPlanName});
            InputStream goodPlanStream = this.ndu.getDeploymentPlan(goodModuleName, new String[]{goodPlanName});
            if (goodPlanStream == null || badPlanStream == null) {
                throw new EETest.Fault("Failed: Null deployment plan received");
            }
            pass = this.ndu.negativeTestDistributeModule(badModuleStream, badPlanStream);
            this.logTrace("pass after bad module is " + pass);
            if (pass) {
                pass = this.ndu.positiveTestDistributeModule(goodModuleStream, goodPlanStream);
                this.logTrace("pass after good module is " + pass);
            }
            if (!pass) {
                throw new EETest.Fault("Failed: multiSessionConfigTest");
            }
            this.logMsg("Passed: multiSessionConfigTest");
        }
        catch (Exception ex) {
            TestUtil.printStackTrace((Throwable)ex);
            throw new EETest.Fault("Failed: " + ex.getMessage());
        }
    }

    public void multiLoginConfigTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Starting multiLoginConfigTest");
        boolean pass = false;
        String appDir = this.baseAppDir + "login-config/";
        String badModuleName = appDir + "BadLoginConfig.war";
        String goodModuleName = appDir + "GoodLoginConfig.war";
        String badPlanName = appDir + "servlet_ee_platform_negdep_multi_apps_badlogin-config_web.war.sun-web.xml";
        String goodPlanName = appDir + "servlet_ee_platform_negdep_multi_apps_goodlogin-config_web.war.sun-web.xml";
        try {
            FileInputStream badModuleStream = new FileInputStream(new File(badModuleName));
            FileInputStream goodModuleStream = new FileInputStream(new File(goodModuleName));
            InputStream badPlanStream = this.ndu.getDeploymentPlan(badModuleName, new String[]{badPlanName});
            InputStream goodPlanStream = this.ndu.getDeploymentPlan(goodModuleName, new String[]{goodPlanName});
            if (goodPlanStream == null || badPlanStream == null) {
                throw new EETest.Fault("Failed: Null deployment plan received");
            }
            pass = this.ndu.negativeTestDistributeModule(badModuleStream, badPlanStream);
            this.logTrace("pass after bad module is " + pass);
            if (pass) {
                pass = this.ndu.positiveTestDistributeModule(goodModuleStream, goodPlanStream);
                this.logTrace("pass after good module is " + pass);
            }
            if (!pass) {
                throw new EETest.Fault("Failed: multiLoginConfigTest");
            }
            this.logMsg("Passed: multiLoginConfigTest");
        }
        catch (Exception ex) {
            TestUtil.printStackTrace((Throwable)ex);
            throw new EETest.Fault("Failed: " + ex.getMessage());
        }
    }

    public void multiJspConfigTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Starting multiJspConfigTest");
        boolean pass = false;
        String appDir = this.baseAppDir + "jsp-config/";
        String badModuleName = appDir + "BadJspConfig.war";
        String goodModuleName = appDir + "GoodJspConfig.war";
        String badPlanName = appDir + "servlet_ee_platform_negdep_multi_apps_badjsp-config_web.war.sun-web.xml";
        String goodPlanName = appDir + "servlet_ee_platform_negdep_multi_apps_goodjsp-config_web.war.sun-web.xml";
        try {
            FileInputStream badModuleStream = new FileInputStream(new File(badModuleName));
            FileInputStream goodModuleStream = new FileInputStream(new File(goodModuleName));
            InputStream badPlanStream = this.ndu.getDeploymentPlan(badModuleName, new String[]{badPlanName});
            InputStream goodPlanStream = this.ndu.getDeploymentPlan(goodModuleName, new String[]{goodPlanName});
            if (goodPlanStream == null || badPlanStream == null) {
                throw new EETest.Fault("Failed: Null deployment plan received");
            }
            pass = this.ndu.negativeTestDistributeModule(badModuleStream, badPlanStream);
            this.logTrace("pass after bad module is " + pass);
            if (pass) {
                pass = this.ndu.positiveTestDistributeModule(goodModuleStream, goodPlanStream);
                this.logTrace("pass after good module is " + pass);
            }
            if (!pass) {
                throw new EETest.Fault("Failed: multiJspConfigTest");
            }
            this.logMsg("Passed: multiJspConfigTest");
        }
        catch (Exception ex) {
            TestUtil.printStackTrace((Throwable)ex);
            throw new EETest.Fault("Failed: " + ex.getMessage());
        }
    }
}

