/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.bindable;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import java.util.Properties;
import java.util.Set;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getBindableType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                TestUtil.logTrace((String)"Obtained Non-null Set of EntityType");
                for (EntityType eType : aSet) {
                    TestUtil.logTrace((String)("entity's BindableType is  = " + eType.getBindableType()));
                    if (eType.getBindableType().equals((Object)Bindable.BindableType.ENTITY_TYPE)) {
                        TestUtil.logTrace((String)"as Expected BindableType is ENTITY_TYPE");
                        pass = true;
                        continue;
                    }
                    TestUtil.logTrace((String)"bindableType is non ENTITY_TYPE");
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getBindableType failed");
        }
    }

    public void getBindableJavaType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                TestUtil.logTrace((String)"Obtained Non-null Set of EntityType");
                for (EntityType eType : aSet) {
                    TestUtil.logTrace((String)("entity's BindableJavaType is  = " + eType.getBindableJavaType().getName()));
                    String bindableJavaType = eType.getBindableJavaType().getName();
                    if (bindableJavaType == null) continue;
                    if (bindableJavaType.equals("com.sun.ts.tests.jpa.core.metamodelapi.bindable.A")) {
                        TestUtil.logTrace((String)("as Expected BindableJavaType for A is " + bindableJavaType));
                        pass = true;
                        continue;
                    }
                    TestUtil.logTrace((String)"bindableJavaType is incorrect");
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getBindableJavaType failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

