/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.validation;

import com.sun.ts.tests.interop.csiv2.common.parser.IORASContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORSASContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORTransportMechEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.NullTransEntry;
import com.sun.ts.tests.interop.csiv2.common.validation.IORValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ValidationException;
import java.util.Vector;

public class IOR4ValidationStrategy
extends IORValidationStrategy {
    private boolean nonzeroPort;
    private int expectedTokenType;

    public IOR4ValidationStrategy(boolean nonzeroPort, int expectedTokenType) {
        this.nonzeroPort = nonzeroPort;
        this.expectedTokenType = expectedTokenType;
    }

    @Override
    public String getName() {
        return "IOR.4";
    }

    @Override
    public boolean verifyIIOPProfilePort(int port) {
        boolean result = false;
        boolean bl = result = !(port != 0 ^ this.nonzeroPort);
        if (!result) {
            this.log.logInfo("IIOPProfilePort : Expected : 0 : received : " + port);
        }
        return result;
    }

    @Override
    public boolean verifyTargetRequires(int targetRequires) {
        boolean result = false;
        boolean bl = result = targetRequires == 0;
        if (!result) {
            this.log.logInfo("TargetRequires : Expected : None : received : " + this.getTargetOptions(targetRequires));
        }
        return result;
    }

    @Override
    public boolean verifyIORTransportMech(IORTransportMechEntry iorTransportMech) {
        boolean result = true;
        this.log.logInfo("Validating IORTransportMech...");
        NullTransEntry nullTrans = iorTransportMech.getNullTrans();
        if (nullTrans == null) {
            this.log.logMismatch("Expecting IOR Transport Mech = TAG_NULL_TAG.");
            result = false;
        }
        this.log.logInfo("IORTransportMech " + (result ? "Valid." : "Invalid."));
        return result;
    }

    @Override
    public boolean verifyASContext(IORASContextEntry asContext) {
        boolean result = true;
        this.log.logInfo("Validating ASContext...");
        int targetSupports = asContext.getTargetSupports();
        boolean bl = result = result && targetSupports == 0;
        if (!result) {
            this.log.logInfo("TargetSupports : Expected : None : received : " + this.getTargetOptions(targetSupports));
        }
        this.log.logInfo("ASContext " + (result ? "Valid." : "Invalid."));
        return result;
    }

    @Override
    public boolean verifySASContext(IORSASContextEntry sasContext) throws ValidationException {
        boolean result = true;
        this.log.logInfo("Validating SASContext...");
        int targetSupports = sasContext.getTargetSupports();
        int targetRequires = sasContext.getTargetRequires();
        Vector supportedNamingMechanisms = sasContext.getSupportedNamingMechanisms();
        int supportedIdentityTypes = sasContext.getSupportedIdentityTypes();
        boolean bl = result = result && (targetSupports & 0x400) == 1024 && supportedIdentityTypes != 0;
        if (!result) {
            this.log.logInfo("TargetSupports : Expected : ( IDENTITY_ASSERTION ) : received : " + this.getTargetOptions(targetSupports));
        }
        boolean bl2 = result = result && targetRequires == 0;
        if (!result) {
            this.log.logInfo("TargetRequires : Expected : None : received : " + this.getTargetOptions(targetRequires));
        }
        boolean valid1 = supportedNamingMechanisms.size() > 0 && (supportedIdentityTypes & 2) == 2;
        boolean valid2 = supportedNamingMechanisms.size() == 0 && (supportedIdentityTypes & 2) == 0;
        result = result && valid1 ^ valid2;
        boolean bl3 = result = result && (this.expectedTokenType & supportedIdentityTypes) == this.expectedTokenType;
        if (this.expectedTokenType == 2) {
            result = result && this.atLeastOneValidNamingMech(supportedNamingMechanisms);
        }
        this.log.logInfo("SASContext " + (result ? "Valid." : "Invalid."));
        return result;
    }
}

