/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry_infomodel.Versionable;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Service;

public class JAXRClient
extends JAXRCommonClient {
    Timestamp createTS = null;
    Timestamp updateTS = null;
    Timestamp deleteTS = null;
    Timestamp versionedTS = null;
    Timestamp unDeprecateTS = null;
    Timestamp deprecateTS = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void versionable_Test() throws EETest.Fault {
        int failcount;
        String testName;
        block20: {
            testName = "versionable_Test";
            failcount = 0;
            Key serviceKey = null;
            String serviceId = null;
            ArrayList<Key> serviceKeys = null;
            int providerlevel = 0;
            try {
                String serviceName = testName + "_service";
                this.debug.add("Create an service registryObject \n");
                Service service = this.blm.createService(serviceName);
                String userVersion = testName + "_User_Revision";
                service.setUserVersion(userVersion);
                providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                if (providerlevel == 0) {
                    throw new EETest.Fault(testName + " UnsupportedCapabilityException expected for level 0 providers!");
                }
                serviceKey = this.saveMyService(service);
                if (serviceKey == null) {
                    throw new EETest.Fault(testName + " due to save service errors , test did not complete!");
                }
                serviceId = serviceKey.getId();
                serviceKeys = new ArrayList<Key>();
                serviceKeys.add(serviceKey);
                service = this.retrieveMyObject(serviceKey);
                this.debug.add("user version should be " + userVersion + "\n");
                if (service.getUserVersion().equals(userVersion)) {
                    this.debug.add("getUserVersion returned expected result \n");
                } else {
                    this.debug.add("Unexpected result from getUserVersion, it returned: " + service.getUserVersion() + "\n");
                    ++failcount;
                }
            }
            catch (UnsupportedCapabilityException ue) {
                if (providerlevel == 0) {
                    this.debug.add(" UnsupportedCapabilityException thrown as expected\n");
                    break block20;
                }
                throw new EETest.Fault(testName + " UnsupportedCapabilityException not expected for level 1 providers!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            finally {
                this.debug.add("End of test method - delete the Service \n");
                try {
                    BulkResponse br = this.blm.deleteServices(serviceKeys);
                    this.debug.add("do cleanup - delete service \n");
                    if (br.getExceptions() != null) {
                        this.debug.add("WARNING:  cleanup encountered an error while trying to delete the service.\n");
                    }
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                    this.debug.add("Caught Exception while trying to delete the service \n");
                }
            }
        }
        if (failcount > 0) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    private Key saveMyService(Service service) {
        Key key2 = null;
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(service);
        try {
            BulkResponse br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("Error:   saveServices failed \n");
                return null;
            }
            Collection serviceKeys = br.getCollection();
            for (Key key2 : serviceKeys) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return key2;
    }

    private Service retrieveMyObject(Key key) {
        Service service2 = null;
        ArrayList<Key> serviceKeys = new ArrayList<Key>();
        serviceKeys.add(key);
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            BulkResponse br = bqm.getRegistryObjects(serviceKeys, "Service");
            if (br.getExceptions() != null) {
                this.debug.add("Error:  encountered an error while trying to retrieve the SERVICE.\n");
                return null;
            }
            Collection retServices = br.getCollection();
            if (retServices.size() != 1) {
                return null;
            }
            for (Service service2 : retServices) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return service2;
    }
}

